/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.injections;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.injections.JSInjectionPlaceInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringInterpolationErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    private static final Key<List<TextRange>> STRING_FRAGMENTS_KEY = new Key("STRING_FRAGMENTS_KEY");
    private static final Comparator<TextRange> RANGE_START_COMPARATOR = Comparator.comparingInt(TextRange::getStartOffset);
    private static final List<TextRange> UNINITIALIZED_VALUE = new ArrayList<TextRange>();

    public static void register(@NotNull List<? extends JSInjectionPlaceInfo> places, @NotNull MultiHostRegistrar registrar) {
        if (places == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(1);
        }
        if (places.size() <= 1) {
            return;
        }
        StringInterpolationErrorFilter.register(registrar);
    }

    public static void register(@NotNull MultiHostRegistrar registrar) {
        if (registrar == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(2);
        }
        registrar.putInjectedFileUserData(STRING_FRAGMENTS_KEY, UNINITIALIZED_VALUE);
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        List<TextRange> acceptedRanges;
        if (element == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(3);
        }
        if ((acceptedRanges = StringInterpolationErrorFilter.getAcceptedRanges(element.getContainingFile())) == null) {
            return true;
        }
        TextRange stringRange = StringInterpolationErrorFilter.findRange(element.getTextRange(), acceptedRanges);
        return stringRange == null || stringRange.contains(element.getTextRange());
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile psiFile) {
        List<TextRange> acceptedRanges;
        if (highlightInfo == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(4);
        }
        if ((acceptedRanges = StringInterpolationErrorFilter.getAcceptedRanges(psiFile)) == null) {
            return true;
        }
        if (highlightInfo.getSeverity() == HighlightSeverity.WARNING || highlightInfo.getSeverity() == HighlightSeverity.WEAK_WARNING || highlightInfo.getSeverity() == HighlightSeverity.ERROR) {
            TextRange highlightRange = TextRange.create((Segment)highlightInfo);
            TextRange stringRange = StringInterpolationErrorFilter.findRange(highlightRange, acceptedRanges);
            return stringRange == null || highlightInfo.startOffset > stringRange.getStartOffset() && highlightInfo.endOffset < stringRange.getEndOffset();
        }
        return true;
    }

    private static List<TextRange> getAcceptedRanges(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        List fragments = (List)file.getUserData(STRING_FRAGMENTS_KEY);
        if (fragments == null) {
            return null;
        }
        if (fragments == UNINITIALIZED_VALUE) {
            fragments = InjectedLanguageManager.getInstance((Project)file.getProject()).intersectWithAllEditableFragments(file, file.getTextRange());
            file.putUserData(STRING_FRAGMENTS_KEY, (Object)fragments);
        }
        return fragments;
    }

    @Nullable
    private static TextRange findRange(@NotNull TextRange range, @NotNull List<TextRange> list) {
        int i;
        if (range == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(5);
        }
        if (list == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(6);
        }
        if ((i = Collections.binarySearch(list, range, RANGE_START_COMPARATOR)) == -1) {
            return null;
        }
        return list.get(i < 0 ? -i - 2 : i);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/injections/StringInterpolationErrorFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

