/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean statementMayCompleteNormally(@Nullable JSStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSReturnStatement || statement instanceof JSThrowStatement) {
            return false;
        }
        if (statement instanceof JSExpressionStatement || statement instanceof JSEmptyStatement || statement instanceof JSVarStatement) {
            return true;
        }
        if (statement instanceof JSForStatement) {
            return ControlFlowUtils.forStatementMayReturnNormally((JSForStatement)statement);
        }
        if (statement instanceof JSForInStatement) {
            return ControlFlowUtils.foreachStatementMayReturnNormally((JSForInStatement)statement);
        }
        if (statement instanceof JSWhileStatement) {
            return ControlFlowUtils.whileStatementMayReturnNormally((JSWhileStatement)statement);
        }
        if (statement instanceof JSDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayReturnNormally((JSDoWhileStatement)statement);
        }
        if (statement instanceof JSBlockStatement) {
            return ControlFlowUtils.blockMayCompleteNormally((JSBlockStatement)statement);
        }
        if (statement instanceof JSLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((JSLabeledStatement)statement);
        }
        if (statement instanceof JSIfStatement) {
            return ControlFlowUtils.ifStatementMayReturnNormally((JSIfStatement)statement);
        }
        if (statement instanceof JSTryStatement) {
            return ControlFlowUtils.tryStatementMayReturnNormally((JSTryStatement)statement);
        }
        if (statement instanceof JSSwitchStatement) {
            return ControlFlowUtils.switchStatementMayReturnNormally((JSSwitchStatement)statement);
        }
        if (statement instanceof JSWithStatement) {
            return ControlFlowUtils.withStatementMayReturnNormally((JSWithStatement)statement);
        }
        return true;
    }

    private static boolean withStatementMayReturnNormally(JSWithStatement jsWithStatement) {
        JSStatement body = jsWithStatement.getStatement();
        return ControlFlowUtils.statementMayCompleteNormally(body);
    }

    private static boolean doWhileStatementMayReturnNormally(@NotNull JSDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(0);
        }
        JSExpression test = loopStatement.getCondition();
        JSStatement body = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body) && !ControlFlowUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget(loopStatement);
    }

    private static boolean whileStatementMayReturnNormally(@NotNull JSWhileStatement loopStatement) {
        JSExpression test;
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(1);
        }
        return !ControlFlowUtils.isTrue(test = loopStatement.getCondition()) || ControlFlowUtils.statementIsBreakTarget(loopStatement);
    }

    private static boolean forStatementMayReturnNormally(@NotNull JSForStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(2);
        }
        JSExpression test = loopStatement.getCondition();
        if (ControlFlowUtils.statementIsBreakTarget(loopStatement)) {
            return true;
        }
        if (test == null) {
            return false;
        }
        return !ControlFlowUtils.isTrue(test);
    }

    private static boolean foreachStatementMayReturnNormally(@NotNull JSForInStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(3);
        }
        return true;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull JSSwitchStatement switchStatement) {
        if (switchStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(4);
        }
        if (ControlFlowUtils.statementIsBreakTarget(switchStatement)) {
            return true;
        }
        JSCaseClause[] caseClauses = switchStatement.getCaseClauses();
        if (caseClauses.length == 0) {
            return true;
        }
        boolean hasDefaultCase = false;
        for (JSCaseClause clause : caseClauses) {
            if (!clause.isDefault()) continue;
            hasDefaultCase = true;
        }
        if (!hasDefaultCase) {
            return true;
        }
        JSCaseClause lastClause = caseClauses[caseClauses.length - 1];
        JSSourceElement[] statements = lastClause.getStatementListItems();
        if (statements.length == 0 || Arrays.stream(statements).allMatch(e -> e instanceof JSFunction)) {
            return true;
        }
        for (int i = statements.length - 1; i >= 0; --i) {
            JSSourceElement statement = statements[i];
            if (statement instanceof JSFunction) continue;
            return !(statement instanceof JSStatement) || ControlFlowUtils.statementMayCompleteNormally((JSStatement)statement);
        }
        return true;
    }

    private static boolean tryStatementMayReturnNormally(@NotNull JSTryStatement tryStatement) {
        JSStatement finallyBlock;
        if (tryStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(5);
        }
        if ((finallyBlock = tryStatement.getFinallyStatement()) != null && !ControlFlowUtils.statementMayCompleteNormally(finallyBlock)) {
            return false;
        }
        JSStatement tryBlock = tryStatement.getStatement();
        if (ControlFlowUtils.statementMayCompleteNormally(tryBlock)) {
            return true;
        }
        JSCatchBlock[] allCatchBlocks = tryStatement.getAllCatchBlocks();
        if (allCatchBlocks.length == 0) {
            return false;
        }
        for (JSCatchBlock c : allCatchBlocks) {
            if (!ControlFlowUtils.statementMayCompleteNormally(c.getStatement())) continue;
            return true;
        }
        return tryStatement.getContainingFile().getLanguage() == FlexSupportLoader.ECMA_SCRIPT_L4;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull JSIfStatement ifStatement) {
        JSStatement thenBranch;
        if (ifStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(6);
        }
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch = (JSStatement)ifStatement.getThenBranch())) {
            return true;
        }
        JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
        return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull JSLabeledStatement labeledStatement) {
        JSStatement statement;
        if (labeledStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(7);
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement = labeledStatement.getStatement()) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean blockMayCompleteNormally(@Nullable JSBlockStatement block) {
        JSSourceElement[] statements;
        if (block == null) {
            return true;
        }
        for (JSSourceElement statement : statements = block.getStatementListItems()) {
            if (!(statement instanceof JSStatement) || ControlFlowUtils.statementMayCompleteNormally((JSStatement)statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull JSStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(8);
        }
        return SyntaxTraverser.psiTraverser((PsiElement)statement).filter(JSBreakStatement.class).filter(b -> BreakFinder.isAcceptableBreak(statement, b)).isNotEmpty();
    }

    public static boolean elementContainsReturn(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(9);
        }
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept(returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean elementContainsReturnOrYield(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(10);
        }
        ReturnFinder finder = new ReturnFinder(){

            @Override
            public void visitJSYieldExpression(@NotNull JSYieldExpression statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.m_found = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$1", "visitJSYieldExpression"));
            }
        };
        element.accept(finder);
        return finder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull JSStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(11);
        }
        return SyntaxTraverser.psiTraverser((PsiElement)statement).filter(JSContinueStatement.class).filter(b -> ContinueFinder.isAcceptableContinue(statement, b)).isNotEmpty();
    }

    public static boolean isInFinallyBlock(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(12);
        }
        JSElement currentElement = element;
        JSTryStatement tryStatement;
        while ((tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, JSTryStatement.class, (boolean)true, (Class[])new Class[]{JSFunction.class})) != null) {
            JSStatement finallyBlock = tryStatement.getFinallyStatement();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static JSStatement stripBraces(@Nullable JSStatement branch) {
        if (branch instanceof JSBlockStatement) {
            JSBlockStatement block = (JSBlockStatement)branch;
            JSSourceElement[] statements = block.getStatementListItems();
            if (statements.length == 1 && statements[0] instanceof JSStatement) {
                return (JSStatement)statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean statementCompletesWithStatement(@NotNull JSStatement containingStatement, @NotNull JSStatement statement) {
        if (containingStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(13);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(14);
        }
        JSElement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            JSElement container = ControlFlowUtils.getContainingStatement(statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof JSBlockStatement ? !ControlFlowUtils.statementIsLastInBlock((JSBlockStatement)container, statementToCheck) : container instanceof JSSwitchStatement && !ControlFlowUtils.statementIsLastInSwitch((JSSwitchStatement)container, statementToCheck)) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof JSSwitchStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull JSBlockStatement body, @NotNull JSStatement statement) {
        if (body == null) {
            ControlFlowUtils.$$$reportNull$$$0(15);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(16);
        }
        JSElement statementToCheck = statement;
        while (statementToCheck != null) {
            JSElement container = ControlFlowUtils.getContainingStatement(statementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof JSBlockStatement) {
                if (!ControlFlowUtils.statementIsLastInBlock((JSBlockStatement)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)container, JSStatement.class);
                continue;
            }
            if (container instanceof JSSwitchStatement) {
                if (!ControlFlowUtils.statementIsLastInSwitch((JSSwitchStatement)container, statementToCheck)) {
                    return false;
                }
                statementToCheck = container;
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    private static boolean isLoop(@NotNull JSElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(17);
        }
        return element instanceof JSLoopStatement;
    }

    @Nullable
    private static JSElement getContainingStatement(@NotNull JSElement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(18);
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)statement, JSStatement.class);
    }

    private static boolean statementIsLastInBlock(@NotNull JSBlockStatement block, @NotNull JSStatement statement) {
        if (block == null) {
            ControlFlowUtils.$$$reportNull$$$0(19);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(20);
        }
        return ControlFlowUtils.statementIsLastIn(statement, block.getStatementListItems());
    }

    private static boolean statementIsLastInSwitch(@NotNull JSSwitchStatement switchStatement, @NotNull JSStatement statement) {
        if (switchStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(21);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(22);
        }
        return ControlFlowUtils.statementIsLastIn(statement, switchStatement.getAllStatementListItems());
    }

    private static boolean statementIsLastIn(@NotNull JSStatement statement, JSSourceElement[] items) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(23);
        }
        for (int i = items.length - 1; i >= 0; --i) {
            JSSourceElement item = items[i];
            if (item instanceof JSFunction) continue;
            if (statement.equals(item)) {
                return true;
            }
            if (statement instanceof JSEmptyStatement) continue;
            return false;
        }
        return false;
    }

    public static boolean isConstantExpression(@Nullable JSExpression expression) {
        return ControlFlowUtils.isUndefinedOrNull(expression) || ControlFlowUtils.isTrue(expression) || ControlFlowUtils.isFalse(expression);
    }

    public static boolean isNotConstantExpression(@NotNull JSExpression expression) {
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(24);
        }
        if (JSSymbolUtil.isNullLiteral(expression) || JSSymbolUtil.isUndefinedExpression(expression)) {
            return false;
        }
        return !ControlFlowUtils.isTrueOrFalse(expression) && !JSTypeGuardChecker.containsDecorator(expression, JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED, JSDecoratedType.TypeDecoration.INFERRED_NULL);
    }

    public static boolean isUndefined(@Nullable JSExpression expression) {
        if (expression == null) {
            return false;
        }
        if (JSSymbolUtil.isUndefinedExpression(expression)) {
            return true;
        }
        return JSTypeGuardChecker.containsDecorator(expression, JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED);
    }

    public static boolean isNull(@Nullable JSExpression expression) {
        if (expression == null) {
            return false;
        }
        if (JSSymbolUtil.isNullLiteral(expression)) {
            return true;
        }
        return JSTypeGuardChecker.containsDecorator(expression, JSDecoratedType.TypeDecoration.INFERRED_NULL);
    }

    public static boolean isUndefinedOrNull(@Nullable JSExpression expression) {
        if (expression == null) {
            return false;
        }
        if (JSSymbolUtil.isNullLiteral(expression) || JSSymbolUtil.isUndefinedExpression(expression)) {
            return true;
        }
        return JSTypeGuardChecker.containsDecorator(expression, JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED, JSDecoratedType.TypeDecoration.INFERRED_NULL);
    }

    public static boolean isFalse(@Nullable JSExpression expression) {
        return expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).getExpressionKind(false) == JSLiteralExpressionKind.FALSE;
    }

    public static boolean isTrue(@Nullable JSExpression expression) {
        return expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).getExpressionKind(false) == JSLiteralExpressionKind.TRUE;
    }

    public static boolean isTrueOrFalse(@Nullable JSExpression expression) {
        return ControlFlowUtils.isTrue(expression) || ControlFlowUtils.isFalse(expression);
    }

    @Nullable
    public static JSVariable resolveVariable(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JSReferenceExpression) {
            PsiElement variable = ((JSReferenceExpression)expression).resolve();
            return variable instanceof JSVariable ? (JSVariable)variable : null;
        }
        if (expression instanceof JSDefinitionExpression) {
            JSExpression referentExpression = ((JSDefinitionExpression)expression).getExpression();
            PsiReference reference = referentExpression == null ? null : referentExpression.getReference();
            PsiElement variable = reference == null ? null : reference.resolve();
            return variable instanceof JSVariable ? (JSVariable)variable : null;
        }
        return null;
    }

    public static void appendStatementsInSequence(StringBuilder buffer, JSStatement statement1, JSStatement statement2) {
        if (statement1 == null) {
            buffer.append(' ').append(statement2.getText());
        } else if (statement2 == null) {
            buffer.append(' ').append(statement1.getText());
        } else {
            buffer.append('{');
            ControlFlowUtils.appendStatementStripped(buffer, statement1);
            ControlFlowUtils.appendStatementStripped(buffer, statement2);
            buffer.append('}');
        }
    }

    private static void appendStatementStripped(StringBuilder buffer, JSStatement statement) {
        if (statement instanceof JSBlockStatement) {
            for (JSSourceElement child : ((JSBlockStatement)statement).getStatementListItems()) {
                buffer.append(child.getText());
            }
        } else {
            buffer.append(statement.getText());
        }
    }

    public static boolean canBeMerged(JSStatement statement1, JSStatement statement2) {
        if (!ControlFlowUtils.statementMayCompleteNormally(statement1)) {
            return false;
        }
        Set<String> statement1Declarations = ControlFlowUtils.calculateTopLevelDeclarations(statement1);
        if (ControlFlowUtils.containsConflictingDeclarations(statement1Declarations, statement2)) {
            return false;
        }
        Set<String> statement2Declarations = ControlFlowUtils.calculateTopLevelDeclarations(statement2);
        return !ControlFlowUtils.containsConflictingDeclarations(statement2Declarations, statement1);
    }

    private static Set<String> calculateTopLevelDeclarations(JSStatement statement) {
        HashSet<String> out = new HashSet<String>();
        if (statement instanceof JSVarStatement) {
            ControlFlowUtils.addDeclarations((JSVarStatement)statement, out);
        } else if (statement instanceof JSBlockStatement) {
            for (JSSourceElement subStatement : ((JSBlockStatement)statement).getStatementListItems()) {
                if (!(subStatement instanceof JSVarStatement)) continue;
                ControlFlowUtils.addDeclarations((JSVarStatement)subStatement, out);
            }
        }
        return out;
    }

    private static void addDeclarations(JSVarStatement statement, Set<String> declaredVars) {
        for (JSVariable variable : statement.getVariables()) {
            declaredVars.add(variable.getName());
        }
    }

    private static boolean containsConflictingDeclarations(Set<String> declarations, JSStatement statement) {
        return SyntaxTraverser.psiTraverser((PsiElement)statement).filter(JSVariable.class).filter(v -> declarations.contains(v.getName())).isNotEmpty();
    }

    public static boolean statementContainsExitingBreak(@Nullable JSStatement statement) {
        if (statement == null) {
            return false;
        }
        ExitingBreakFinder breakFinder = new ExitingBreakFinder();
        statement.accept(breakFinder);
        return breakFinder.breakFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/ControlFlowUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhileStatementMayReturnNormally";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "whileStatementMayReturnNormally";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forStatementMayReturnNormally";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "foreachStatementMayReturnNormally";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStatementMayReturnNormally";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryStatementMayReturnNormally";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "ifStatementMayReturnNormally";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "labeledStatementMayCompleteNormally";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsBreakTarget";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "elementContainsReturn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "elementContainsReturnOrYield";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsContinueTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isInFinallyBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "statementCompletesWithStatement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "blockCompletesWithStatement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isLoop";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingStatement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsLastInBlock";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsLastInSwitch";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "statementIsLastIn";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotConstantExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReturnFinder
    extends JSRecursiveElementVisitor {
        protected boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        @Override
        public void visitJSReturnStatement(@NotNull JSReturnStatement returnStatement) {
            if (returnStatement == null) {
                ReturnFinder.$$$reportNull$$$0(0);
            }
            this.m_found = true;
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                ReturnFinder.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
            if (node == null) {
                ReturnFinder.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void visitJSFunctionProperty(@NotNull JSFunctionProperty functionProperty) {
            if (functionProperty == null) {
                ReturnFinder.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionProperty";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ReturnFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReturnStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionProperty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ExitingBreakFinder
    extends JSRecursiveElementVisitor {
        private boolean found;

        private ExitingBreakFinder() {
        }

        private boolean breakFound() {
            return this.found;
        }

        @Override
        public void visitJSReferenceExpression(@NotNull JSReferenceExpression exp) {
            if (exp == null) {
                ExitingBreakFinder.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void visitJSBreakStatement(@NotNull JSBreakStatement breakStatement) {
            if (breakStatement == null) {
                ExitingBreakFinder.$$$reportNull$$$0(1);
            }
            if (breakStatement.getLabel() != null) {
                return;
            }
            this.found = true;
        }

        @Override
        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
            if (statement == null) {
                ExitingBreakFinder.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                ExitingBreakFinder.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void visitJSForInStatement(@NotNull JSForInStatement statement) {
            if (statement == null) {
                ExitingBreakFinder.$$$reportNull$$$0(4);
            }
        }

        @Override
        public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
            if (statement == null) {
                ExitingBreakFinder.$$$reportNull$$$0(5);
            }
        }

        @Override
        public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
            if (statement == null) {
                ExitingBreakFinder.$$$reportNull$$$0(6);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakStatement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ExitingBreakFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBreakStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDoWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSWhileStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSSwitchStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ContinueFinder {
        private ContinueFinder() {
        }

        static boolean isAcceptableContinue(JSStatement target, @NotNull JSContinueStatement continueStatement) {
            JSStatement exitedStatement;
            if (continueStatement == null) {
                ContinueFinder.$$$reportNull$$$0(0);
            }
            return (exitedStatement = continueStatement.getStatementToContinue()) != null && PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)target, (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continueStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ContinueFinder", "isAcceptableContinue"));
        }
    }

    private static final class BreakFinder {
        private BreakFinder() {
        }

        static boolean isAcceptableBreak(JSStatement target, @NotNull JSBreakStatement breakStatement) {
            JSStatement prevStatement;
            JSStatement exitedStatement;
            if (breakStatement == null) {
                BreakFinder.$$$reportNull$$$0(0);
            }
            return (exitedStatement = breakStatement.getStatementToBreak()) != null && PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)target, (boolean)false) && ((prevStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)breakStatement, JSStatement.class)) == null || ControlFlowUtils.statementMayCompleteNormally(prevStatement));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$BreakFinder", "isAcceptableBreak"));
        }
    }
}

