/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringTemplateBuilder;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringPropertiesGenerateProvider
extends AbstractDomGenerateProvider<SpringProperty> {
    public SpringPropertiesGenerateProvider() {
        super(SpringBundle.message("spring.generate.properties", new Object[0]), SpringProperty.class);
    }

    protected DomElement getParentDomElement(Project project, Editor editor, PsiFile file) {
        return SpringBeanCoreUtils.getSpringBeanForCurrentCaretPosition(editor, file);
    }

    public SpringProperty generate(@Nullable DomElement parent, Editor editor) {
        if (parent instanceof SpringBean) {
            PsiMethodMember[] members;
            SpringBean springBean = (SpringBean)parent;
            Collection<PsiMethod> setters = SpringPropertiesGenerateProvider.getNonInjectedPropertySetters(springBean);
            PsiMethodMember[] psiMethodMembers = SpringPropertiesGenerateProvider.getPsiMethodMembers(setters);
            Project project = parent.getManager().getProject();
            MemberChooser chooser = new MemberChooser((ClassMember[])psiMethodMembers, false, true, project);
            chooser.setTitle(SpringBundle.message("spring.bean.properties.chooser.title", new Object[0]));
            chooser.setCopyJavadocVisible(false);
            chooser.show();
            if (chooser.getExitCode() == 0 && (members = (PsiMethodMember[])chooser.getSelectedElements((ClassMember[])new PsiMethodMember[0])) != null && members.length > 0) {
                PsiMethod[] methods = new PsiMethod[members.length];
                for (int i = 0; i < members.length; ++i) {
                    methods[i] = (PsiMethod)members[i].getElement();
                }
                SpringPropertiesGenerateProvider.doGenerate(editor, springBean, project, methods);
            }
        }
        return null;
    }

    public static void doGenerate(Editor editor, SpringBean springBean, Project project, PsiMethod ... methods) {
        if (!GenerateSpringBeanDependenciesUtil.ensureFileWritable((DomElement)springBean)) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            SpringTemplateBuilder builder = new SpringTemplateBuilder(project);
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)springBean);
            for (PsiMethod method : methods) {
                SpringPropertiesGenerateProvider.createProperty(method, model, builder);
            }
            SpringTemplateBuilder.preparePlace(editor, project, (DomElement)springBean.addProperty());
            builder.startTemplate(editor, AbstractDomGenerateProvider.createNamespacePrefixMap((DomElement)springBean));
        });
    }

    private static PsiMethodMember[] getPsiMethodMembers(Collection<PsiMethod> setters) {
        ArrayList<1> psiMethodMembers = new ArrayList<1>();
        for (final PsiMethod psiMethod : setters) {
            psiMethodMembers.add(new PsiMethodMember(psiMethod){

                public void renderTreeNode(SimpleColoredComponent component, JTree tree) {
                    component.append(this.getText(), this.getTextAttributes(tree));
                    component.append(": ", this.getTextAttributes(tree));
                    component.append(psiMethod.getParameterList().getParameters()[0].getType().getCanonicalText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    component.setIcon(SpringApiIcons.SpringProperty);
                }

                @NotNull
                public Icon getIcon(int flags) {
                    Icon icon = SpringApiIcons.SpringProperty;
                    if (icon == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon;
                }

                @Nls
                @NotNull
                public String getSecondaryText() {
                    String string = psiMethod.getParameterList().getParameters()[0].getType().getCanonicalText();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @NotNull
                public SimpleTextAttributes getAttributes() {
                    SimpleTextAttributes simpleTextAttributes = this.getTextAttributes();
                    if (simpleTextAttributes == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return simpleTextAttributes;
                }

                @NotNull
                public String getText() {
                    String string = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod);
                    if (string == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/spring/model/actions/generate/SpringPropertiesGenerateProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIcon";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSecondaryText";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getAttributes";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            });
        }
        return psiMethodMembers.toArray(new PsiMethodMember[0]);
    }

    public static Collection<PsiMethod> getNonInjectedPropertySetters(SpringBean springBean) {
        LinkedHashMap<MethodSignature, PsiMethod> map = new LinkedHashMap<MethodSignature, PsiMethod>();
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (psiClass != null) {
            for (PsiMethod method : psiClass.getAllMethods()) {
                MethodSignature key;
                if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) || !method.hasModifierProperty("public") || method.hasModifierProperty("static") || SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method)) != null || map.containsKey(key = method.getSignature(PsiSubstitutor.UNKNOWN))) continue;
                map.put(key, method);
            }
        }
        return map.values();
    }

    private static void createProperty(@NotNull PsiMethod method, CommonSpringModel model, SpringTemplateBuilder builder) {
        if (method == null) {
            SpringPropertiesGenerateProvider.$$$reportNull$$$0(0);
        }
        PsiType type = method.getParameterList().getParameters()[0].getType();
        @NonNls String name = PropertyUtilBase.getPropertyName((PsiMethod)method);
        builder.addTextSegment("<");
        builder.addVariableSegment("NS_PREFIX");
        builder.addTextSegment("property name=\"" + name + "\"");
        builder.createValueAndClose(type, model, "property");
    }

    public boolean isAvailableForElement(@NotNull DomElement contextElement) {
        SpringBean springBean;
        if (contextElement == null) {
            SpringPropertiesGenerateProvider.$$$reportNull$$$0(1);
        }
        return (springBean = (SpringBean)DomUtil.getParentOfType((DomElement)contextElement, SpringBean.class, (boolean)false)) != null && !SpringPropertiesGenerateProvider.getNonInjectedPropertySetters(springBean).isEmpty();
    }

    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement element) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/actions/generate/SpringPropertiesGenerateProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

