/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringConstructorArgUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.CNamespaceRefValue;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringConstructorArgResolveUtil
extends SpringConstructorArgUtils {
    protected SpringConstructorArgResolveUtil() {
    }

    public static List<PsiMethod> findMatchingMethods(SpringBean springBean) {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)springBean);
        return SpringConstructorArgResolveUtil.findMatchingMethods(springBean, model);
    }

    private static List<PsiMethod> findMatchingMethods(SpringBean springBean, CommonSpringModel springModel) {
        List methods = springBean.getInstantiationMethods();
        if (methods.isEmpty()) {
            return methods;
        }
        HashSet<ConstructorArgDefinition> all_args = new HashSet<ConstructorArgDefinition>();
        Set args = springBean.getAllConstructorArgs();
        all_args.addAll(args);
        all_args.addAll(springBean.getCNamespaceConstructorArgDefinitions());
        boolean constructorAutowire = SpringAutowireUtil.isConstructorAutowire(springBean);
        Map<Integer, ConstructorArg> indexedArgs = SpringConstructorArgResolveUtil.getIndexedConstructorArgs(args);
        ArrayList<PsiMethod> accepted = new ArrayList<PsiMethod>(methods.size());
        for (PsiMethod method : methods) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (!SpringConstructorArgResolveUtil.acceptMethodByAutowire(constructorAutowire, all_args, parameters) || !SpringConstructorArgResolveUtil.acceptMethodByParameterTypes(indexedArgs, constructorAutowire, springModel, all_args, parameters)) continue;
            accepted.add(method);
        }
        return accepted;
    }

    public static boolean acceptMethodByAutowire(boolean constructorAutowire, Set<ConstructorArgDefinition> args, PsiParameter[] parameters) {
        return (constructorAutowire || parameters.length == args.size()) && (!constructorAutowire || parameters.length >= args.size());
    }

    private static boolean acceptMethodByParameterTypes(Map<Integer, ConstructorArg> indexedArgs, boolean constructorAutowire, CommonSpringModel model, Set<? extends ConstructorArgDefinition> args, PsiParameter[] parameters) {
        SmartList usedArgs = new SmartList();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (SpringConstructorArgResolveUtil.acceptParameter(parameter, args, indexedArgs, i, (Collection<? super ConstructorArgDefinition>)usedArgs) || constructorAutowire && !SpringAutowireUtil.autowireByType(model, parameter.getType(), parameter.getName(), false).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean acceptParameter(PsiParameter parameter, Collection<? extends ConstructorArgDefinition> allConstructorArgs, Map<Integer, ConstructorArg> indexedArgs, int i, Collection<? super ConstructorArgDefinition> usedArgs) {
        if (SpringAutowireUtil.isValueAnnoInjection((PsiModifierListOwner)parameter)) {
            return true;
        }
        PsiType psiType = parameter.getType();
        if (indexedArgs.get(i) != null) {
            ConstructorArg arg = indexedArgs.get(i);
            return arg.isAssignable(psiType);
        }
        for (ConstructorArgDefinition constructorArgDefinition : allConstructorArgs) {
            boolean assignable;
            if (usedArgs.contains(constructorArgDefinition)) continue;
            if (constructorArgDefinition instanceof CNamespaceDomElement && SpringConstructorArgResolveUtil.acceptParameter(parameter, i, (CNamespaceDomElement)constructorArgDefinition)) {
                usedArgs.add((ConstructorArgDefinition)constructorArgDefinition);
                return true;
            }
            if (!(constructorArgDefinition instanceof ConstructorArg) || indexedArgs.containsValue(constructorArgDefinition) || !(assignable = ((ConstructorArg)constructorArgDefinition).isAssignable(psiType))) continue;
            usedArgs.add((ConstructorArgDefinition)constructorArgDefinition);
            return true;
        }
        return false;
    }

    private static boolean acceptParameter(PsiParameter parameter, int i, CNamespaceDomElement cNamespaceDomElement) {
        String parameterName = parameter.getName();
        if (parameterName.equals(cNamespaceDomElement.getAttributeName())) {
            return true;
        }
        Integer index = cNamespaceDomElement.getIndex();
        return index != null && i == index;
    }

    public static Map<Integer, ConstructorArg> getIndexedConstructorArgs(Collection<? extends ConstructorArg> list) {
        HashMap<Integer, ConstructorArg> indexed = new HashMap<Integer, ConstructorArg>();
        for (ConstructorArg constructorArg : list) {
            Integer value = (Integer)constructorArg.getIndex().getValue();
            if (value == null) continue;
            indexed.put(value, constructorArg);
        }
        return indexed;
    }

    @Nullable
    public PsiMethod getSpringBeanConstructor(SpringBean springBean, CommonSpringModel springModel) {
        if (springBean == null || springModel == null) {
            return null;
        }
        if (SpringConstructorArgResolveUtil.isInstantiatedByFactory(springBean)) {
            return null;
        }
        List<PsiMethod> psiMethods = SpringConstructorArgResolveUtil.findMatchingMethods(springBean, springModel);
        PsiMethod resolvedConstructor = null;
        for (PsiMethod psiMethod : psiMethods) {
            if (resolvedConstructor != null && resolvedConstructor.getParameterList().getParametersCount() >= psiMethod.getParameterList().getParametersCount()) continue;
            resolvedConstructor = psiMethod;
        }
        return resolvedConstructor;
    }

    public static boolean isInstantiatedByFactory(SpringBean springBean) {
        return DomUtil.hasXml((DomElement)springBean.getFactoryMethod());
    }

    public static boolean hasEmptyConstructor(SpringBean springBean) {
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(false));
        if (beanClass != null) {
            PsiMethod[] constructors = beanClass.getConstructors();
            if (constructors.length == 0) {
                return true;
            }
            for (PsiMethod constructor : constructors) {
                if (constructor.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String suggestParamsForConstructorArgsAsString(SpringBean springBean) {
        ArrayList<String> params = new ArrayList<String>();
        for (PsiParameter psiParameter : SpringConstructorArgResolveUtil.suggestParamsForConstructorArgs(springBean)) {
            params.add(psiParameter.getText());
        }
        return StringUtil.join(params, (String)",");
    }

    public static List<PsiParameter> suggestParamsForConstructorArgs(SpringBean springBean) {
        LinkedList<PsiParameter> methodParameters = new LinkedList<PsiParameter>();
        Project project = springBean.getManager().getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        for (Pair<String, PsiType> param : SpringConstructorArgResolveUtil.suggestConstructorParamsForBean(springBean)) {
            methodParameters.add(elementFactory.createParameter((String)param.first, (PsiType)param.second));
        }
        return methodParameters;
    }

    public static List<Pair<String, PsiType>> suggestConstructorParamsForBean(SpringBean springBean) {
        LinkedList<Pair<String, PsiType>> result2 = new LinkedList<Pair<String, PsiType>>();
        Project project = springBean.getManager().getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiClassType defaultParamType = SpringConstructorArgResolveUtil.getDefaultParamType(project, elementFactory);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        ArrayList existedNames = new ArrayList();
        List cNamespaceDomElements = springBean.getCNamespaceConstructorArgDefinitions();
        if (!cNamespaceDomElements.isEmpty()) {
            for (CNamespaceDomElement namespaceDomElement : cNamespaceDomElements) {
                String name = namespaceDomElement.getAttributeName();
                if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                result2.add((Pair<String, PsiType>)Pair.create((Object)StringUtil.sanitizeJavaIdentifier((String)name), (Object)SpringConstructorArgResolveUtil.getConstructorArgDefinitionType(defaultParamType, (ConstructorArgDefinition)namespaceDomElement)));
            }
        } else {
            for (ConstructorArg arg : SpringConstructorArgResolveUtil.sortConstructorArgsByIndex(springBean.getConstructorArgs())) {
                if (arg == null) continue;
                PsiType type = SpringConstructorArgResolveUtil.getConstructorArgDefinitionType(defaultParamType, (ConstructorArgDefinition)arg);
                String name = SpringConstructorArgResolveUtil.getConstructorArgParamName(codeStyleManager, existedNames, arg, type);
                result2.add((Pair<String, PsiType>)Pair.create((Object)name, (Object)type));
            }
        }
        return result2;
    }

    private static String getConstructorArgParamName(JavaCodeStyleManager codeStyleManager, List<? super String> existedNames, ConstructorArg arg, PsiType type) {
        Object name = arg.getNameAttr().getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)name) || !PsiNameHelper.getInstance((Project)arg.getManager().getProject()).isIdentifier((String)name)) {
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type);
            name = nameInfo.names.length > 0 ? nameInfo.names[0] : "p";
            int i = 1;
            while (existedNames.contains(name)) {
                name = (String)name + ++i;
            }
        }
        existedNames.add((String)name);
        return name;
    }

    private static PsiClassType getDefaultParamType(Project project, PsiElementFactory elementFactory) {
        return elementFactory.createTypeByFQClassName("java.lang.String", GlobalSearchScope.allScope((Project)project));
    }

    private static PsiType getConstructorArgDefinitionType(PsiClassType defaultParamType, ConstructorArgDefinition arg) {
        PsiType type = SpringConstructorArgResolveUtil.getConstructorArgType(arg);
        if (type == null || type.equals(PsiTypes.nullType())) {
            type = defaultParamType;
        }
        return type;
    }

    @Nullable
    private static PsiType getConstructorArgType(@NotNull ConstructorArgDefinition arg) {
        Collection effectiveBeanType2;
        PsiType psiType;
        if (arg == null) {
            SpringConstructorArgResolveUtil.$$$reportNull$$$0(0);
        }
        if (arg instanceof ConstructorArg && (psiType = (PsiType)((ConstructorArg)arg).getType().getValue()) != null && !psiType.getCanonicalText().endsWith(".")) {
            return psiType;
        }
        SpringBeanPointer<?> referencedSpringBean = SpringConstructorArgResolveUtil.getReferencedSpringBean(arg);
        if (referencedSpringBean != null && !(effectiveBeanType2 = referencedSpringBean.getEffectiveBeanTypes()).isEmpty()) {
            return (PsiType)effectiveBeanType2.iterator().next();
        }
        return null;
    }

    @Nullable
    private static SpringBeanPointer<?> getReferencedSpringBean(ConstructorArgDefinition arg) {
        if (arg instanceof ConstructorArg) {
            return SpringPropertyUtils.findReferencedBean((SpringInjection)((ConstructorArg)arg));
        }
        if (arg instanceof CNamespaceRefValue) {
            return arg.getRefValue();
        }
        return null;
    }

    private static ConstructorArg[] sortConstructorArgsByIndex(List<? extends ConstructorArg> constructorArgs) {
        int i;
        ConstructorArg[] args = new ConstructorArg[constructorArgs.size()];
        Map<Integer, ConstructorArg> indexedConstructorArgs = SpringConstructorArgResolveUtil.getIndexedConstructorArgs(constructorArgs);
        if (indexedConstructorArgs.isEmpty()) {
            return constructorArgs.toArray(new ConstructorArg[0]);
        }
        ArrayList<ConstructorArg> indexed = new ArrayList<ConstructorArg>();
        for (Integer n : indexedConstructorArgs.keySet()) {
            ConstructorArg arg;
            i = n;
            if (i < 0 || i >= args.length) continue;
            args[i] = arg = indexedConstructorArgs.get(n);
            indexed.add(arg);
        }
        for (ConstructorArg constructorArg : constructorArgs) {
            if (indexed.contains(constructorArg)) continue;
            for (i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = constructorArg;
            }
        }
        return args;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/spring/model/highlighting/xml/SpringConstructorArgResolveUtil", "getConstructorArgType"));
    }
}

