/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.ui.DialogElementWrapper;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import org.jetbrains.annotations.Nullable;

public class ExistingElementWrapper<T extends JavaeeDomModelElement>
implements DialogElementWrapper<T> {
    private final T myExistingElement;
    private final T myCopy;

    public ExistingElementWrapper(T existingElement, @Nullable JavaeeFacet facet) {
        this.myExistingElement = existingElement;
        this.myCopy = (JavaeeDomModelElement)WriteCommandAction.writeCommandAction((Project)existingElement.getManager().getProject()).compute(() -> {
            JavaeeDomModelElement t = (JavaeeDomModelElement)this.getExistingElement().createMockCopy(false);
            JavaeeFacetUtil.getInstance().setFacetForMockElement((DomElement)t, facet);
            return t;
        });
    }

    @Override
    public final T getElement() {
        return this.myCopy;
    }

    protected T getExistingElement() {
        return this.myExistingElement;
    }

    @Override
    public T save() {
        T t = this.getExistingElement();
        t.copyFrom(this.myCopy);
        return t;
    }

    @Override
    public String getDialogTitle() {
        return J2EEBundle.message("dialog.title.edit.0", StringUtil.capitalizeWords((String)ElementPresentationManager.getTypeNameForObject((Object)this.getElement()), (boolean)true));
    }
}

