/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.engine;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.hibernate.engine.HibernateConnectionManager;
import com.intellij.hibernate.engine.HibernateEngine;
import com.intellij.jpa.engine.JpaConsoleAdapter;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackagePointer;
import icons.HibernateCoreIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConsole
extends JpaConsoleBase {
    public static final String CONSOLE_TOOLWINDOW_ID = "Hibernate Console";

    @NotNull
    public static JpaConsoleBase.Builder<HibernateConsole> newConsole(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            HibernateConsole.$$$reportNull$$$0(0);
        }
        return new JpaConsoleBase.Builder<HibernateConsole>(unitFile){

            public HibernateConsole build() {
                SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)this.getProject(), (String)this.myUnitFile.getElementName());
                HibernateConsole console = new HibernateConsole(this.myUnitFile, this.myConfiguration, (DataBus.Consuming)broker, this.myQuery);
                HibernateEngine engine = new HibernateEngine((DataBus.Producing)broker, this.myUnitFile, this.myConfiguration);
                Disposer.register((Disposable)console, (Disposable)engine);
                return console;
            }
        };
    }

    public HibernateConsole(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @Nullable String query) {
        if (unitFile == null) {
            HibernateConsole.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            HibernateConsole.$$$reportNull$$$0(2);
        }
        if (messageBus == null) {
            HibernateConsole.$$$reportNull$$$0(3);
        }
        super(unitFile, configuration, messageBus, "hql", HibernateConsole.getInitialLanguage(unitFile.getPersistenceFacet()), query);
        this.getLanguageConsole().setPrompt("hql> ");
        this.getMessageBus().addAuditor(new DataAuditor(){

            public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (errorInfo == null) {
                    2.$$$reportNull$$$0(1);
                }
                Throwable throwable = errorInfo.getOriginalThrowable();
                if (context.request.owner != HibernateConsole.this || throwable == null) {
                    return;
                }
                if (StringUtil.getThrowableText((Throwable)throwable).contains("org.hibernate.") || throwable instanceof IllegalStateException || throwable instanceof ClassNotFoundException) {
                    return;
                }
                LOG.error(throwable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorInfo";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/hibernate/engine/HibernateConsole$2";
                objectArray[2] = "error";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static List<HibernateConsole> getActiveConsoles(Project project) {
        return JpaConsoleAdapter.getActiveSessions((Project)project, (String)CONSOLE_TOOLWINDOW_ID);
    }

    private static Language getInitialLanguage(PersistenceFacet facet) {
        Language qlLanguage = facet.getQlLanguage();
        return qlLanguage == null ? JpqlLanguage.JPQL : qlLanguage;
    }

    @NotNull
    public String getToolWindowId() {
        return CONSOLE_TOOLWINDOW_ID;
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = HibernateCoreIcons.HibConsoleToolWindow;
        if (icon == null) {
            HibernateConsole.$$$reportNull$$$0(4);
        }
        return icon;
    }

    protected String getHelpID() {
        return "tool.window.reference.hibernate.console";
    }

    public boolean isStarted() {
        return HibernateConnectionManager.getInstance(this.getProject()).getActiveConfigurations((PersistencePackagePointer)this.getTarget()).contains(this.getConfiguration());
    }

    public void terminate() {
        HibernateConnectionManager.getInstance(this.getProject()).releaseConnection((PersistencePackagePointer)this.getTarget(), this.getConfiguration());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/engine/HibernateConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/engine/HibernateConsole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

