/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.socket;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.jetbrains.codeWithMe.model.DebugTrafficInfo;
import com.jetbrains.codeWithMe.model.RdConnection;
import com.jetbrains.codeWithMe.model.RdForwardedPort;
import com.jetbrains.codeWithMe.model.RdPortState;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.utils.PortForwardingUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/SocketWrapperForPort;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdPort", "Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/codeWithMe/model/RdForwardedPort;)V", "meter", "Lio/opentelemetry/api/metrics/Meter;", "sentBytesCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "receivedBytesCounter", "monitorConnection", "", "port", "rdConnection", "Lcom/jetbrains/codeWithMe/model/RdConnection;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "Companion", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nSocketWrapperForPort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketWrapperForPort.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/SocketWrapperForPort\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,185:1\n60#2,5:186\n60#2,5:191\n67#2,4:196\n60#2,5:200\n67#2,4:205\n60#2,5:209\n60#2,5:214\n60#2,5:219\n60#2,5:224\n60#2,5:229\n60#2,5:234\n60#2,5:239\n60#2,5:244\n60#2,5:249\n67#2,4:254\n23#2:258\n*S KotlinDebug\n*F\n+ 1 SocketWrapperForPort.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/SocketWrapperForPort\n*L\n85#1:186,5\n131#1:191,5\n138#1:196,4\n142#1:200,5\n158#1:205,4\n164#1:209,5\n181#1:214,5\n48#1:219,5\n54#1:224,5\n63#1:229,5\n93#1:234,5\n96#1:239,5\n107#1:244,5\n110#1:249,5\n122#1:254,4\n36#1:258\n*E\n"})
public final class SocketWrapperForPort {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdForwardedPort rdPort;
    @NotNull
    private final Meter meter;
    private final LongCounter sentBytesCounter;
    private final LongCounter receivedBytesCounter;
    @NotNull
    private static final Logger logger;

    public SocketWrapperForPort(@NotNull Lifetime lifetime, @NotNull RdForwardedPort rdPort) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)rdPort, (String)"rdPort");
        this.lifetime = lifetime;
        this.rdPort = rdPort;
        this.meter = TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT);
        this.sentBytesCounter = this.meter.counterBuilder("rdct.SocketWrapperForPort.sentBytes").setUnit("bytes").build();
        this.receivedBytesCounter = this.meter.counterBuilder("rdct.SocketWrapperForPort.receivedBytes").setUnit("bytes").build();
        logger.info("Starting socket wrapper for port " + this.rdPort.getPortNumber());
        this.rdPort.getRdPortState().advise(this.lifetime, arg_0 -> SocketWrapperForPort._init_$lambda$0(this, arg_0));
        SingleThreadScheduler incomingSignalsScheduler = new SingleThreadScheduler(this.lifetime, "Scheduler for port forwarding <" + this.rdPort.getPortNumber() + ">");
        this.rdPort.getConnections().view(this.lifetime, (arg_0, arg_1, arg_2) -> SocketWrapperForPort._init_$lambda$1(this, incomingSignalsScheduler, arg_0, arg_1, arg_2));
    }

    private final void monitorConnection(Lifetime lifetime, RdForwardedPort port, RdConnection rdConnection, IScheduler scheduler) {
        Logger logger;
        Socket socket;
        int portNumber = port.getPortNumber();
        PortForwardingUtilsKt.setScheduler(rdConnection, scheduler);
        String connectionId = rdConnection.getConnectionId();
        try {
            socket = new Socket(InetAddress.getLoopbackAddress(), portNumber);
        }
        catch (IOException e) {
            SocketWrapperForPort.logger.warn("No application listening on <" + portNumber + ">. Failed to connect, id: " + connectionId, (Throwable)e);
            rdConnection.getDestinationSocketInputShutdown().fire((Object)Unit.INSTANCE);
            rdConnection.getDestinationSocketOutputShutdown().fire((Object)Unit.INSTANCE);
            return;
        }
        Socket socket2 = socket;
        Logger $this$debug_u24default$iv = SocketWrapperForPort.logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Client socket connection to port <" + portNumber + "> created, id: " + connectionId, e$iv);
        }
        int connectionTimeout = Registry.Companion.intValue("codeWithMe.portForwarding.clientConnectionTimeout");
        if (connectionTimeout > 0) {
            socket2.setSoTimeout(connectionTimeout);
        }
        rdConnection.getAcceptedConnectionSocketInputShutdown().advise(lifetime, arg_0 -> SocketWrapperForPort.monitorConnection$lambda$1(socket2, portNumber, connectionId, arg_0));
        rdConnection.getAcceptedConnectionSocketOutputShutdown().advise(lifetime, arg_0 -> SocketWrapperForPort.monitorConnection$lambda$2(socket2, portNumber, connectionId, arg_0));
        rdConnection.getToDestinationSocket().advise(lifetime, arg_0 -> SocketWrapperForPort.monitorConnection$lambda$3(this, socket2, portNumber, connectionId, rdConnection, arg_0));
        Logger $this$debug_u24default$iv2 = SocketWrapperForPort.logger;
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            RdPortState rdPortState;
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Setting connection ready: " + rdConnection.getClientInitiatedPortNumber() + " -> " + ((rdPortState = (RdPortState)port.getRdPortState().getValueOrNull()) != null && (rdPortState = rdPortState.getSocketAddress()) != null ? Integer.valueOf(rdPortState.getPort()) : null) + " -> " + portNumber + ", id: " + connectionId, e$iv2);
        }
        rdConnection.getReady().fire((Object)Unit.INSTANCE);
        int counter = 0;
        byte[] bytes = new byte[0x400000];
        block11: while (RLifetimeKt.isAlive((Lifetime)lifetime)) {
            boolean $i$f$debug3;
            try {
                Logger $this$trace$iv = SocketWrapperForPort.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Going to read from socket, id: " + connectionId);
                }
                int bytesRead = socket2.getInputStream().read(bytes);
                switch (bytesRead) {
                    case -1: {
                        Logger $this$debug_u24default$iv3 = SocketWrapperForPort.logger;
                        Throwable e$iv3 = null;
                        $i$f$debug3 = false;
                        if (!$this$debug_u24default$iv3.isDebugEnabled()) break block11;
                        logger = $this$debug_u24default$iv3;
                        boolean bl = false;
                        logger.debug("Read -1 bytes -> EOF, id: " + connectionId, e$iv3);
                        break block11;
                    }
                    case 0: {
                        SocketWrapperForPort.logger.error("unexpected zero-length buffer read. Veeeery straaange..., id: " + connectionId);
                        break block11;
                    }
                    default: {
                        this.sentBytesCounter.add((long)bytesRead);
                        Logger $this$trace$iv2 = SocketWrapperForPort.logger;
                        boolean $i$f$trace2 = false;
                        if ($this$trace$iv2.isTraceEnabled()) {
                            logger = $this$trace$iv2;
                            boolean bl = false;
                            logger.trace("sending buffer " + counter + " to model. size: " + bytesRead + ", id: " + connectionId);
                        }
                        rdConnection.getToServerSocket().fire((Object)new DebugTrafficInfo(counter, CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])bytes, (int)bytesRead))));
                        ++counter;
                        break;
                    }
                }
            }
            catch (SocketTimeoutException e) {
                Logger $this$debug_u24default$iv4 = SocketWrapperForPort.logger;
                Object e$iv4 = null;
                $i$f$debug3 = false;
                if (!$this$debug_u24default$iv4.isDebugEnabled()) break;
                logger = $this$debug_u24default$iv4;
                boolean bl = false;
                logger.debug("Closing socket after " + socket2.getSoTimeout() + " milliseconds with no data to read, id: " + connectionId, (Throwable)e$iv4);
                break;
            }
            catch (SocketException e) {
                Class<?> clazz = e.getClass();
                String string = e.getMessage();
                if (string == null) {
                    string = "(no message)";
                }
                SocketWrapperForPort.logger.warn("SocketException for connection \"" + clazz + ": " + string + "\", id: " + connectionId);
                break;
            }
            catch (IOException e) {
                SocketWrapperForPort.logger.warn("IOException for connection, id: " + connectionId, (Throwable)e);
                break;
            }
            catch (Throwable e) {
                SocketWrapperForPort.logger.warn("Exception for connection, id: " + connectionId, e);
                break;
            }
        }
        Logger $this$debug_u24default$iv5 = SocketWrapperForPort.logger;
        Throwable e$iv5 = null;
        boolean $i$f$debug4 = false;
        if ($this$debug_u24default$iv5.isDebugEnabled()) {
            logger = $this$debug_u24default$iv5;
            boolean bl = false;
            logger.debug("Firing hostSocketInputShutdown, hostSocketOutputShutdown, id: " + connectionId + ". isAlive: " + RLifetimeKt.isAlive((Lifetime)lifetime), e$iv5);
        }
        rdConnection.getDestinationSocketInputShutdown().fire((Object)Unit.INSTANCE);
        rdConnection.getDestinationSocketOutputShutdown().fire((Object)Unit.INSTANCE);
    }

    private static final Unit _init_$lambda$0(SocketWrapperForPort this$0, RdPortState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            RdPortState rdPortState = (RdPortState)this$0.rdPort.getRdPortState().getValueOrNull();
            logger.debug("Client port state: " + (rdPortState != null ? PortForwardingUtilsKt.readable(rdPortState) : null), e$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(SocketWrapperForPort this$0, SingleThreadScheduler $incomingSignalsScheduler, Lifetime connectionLifetime, int n, RdConnection rdConnection) {
        Intrinsics.checkNotNullParameter((Object)connectionLifetime, (String)"connectionLifetime");
        Intrinsics.checkNotNullParameter((Object)rdConnection, (String)"rdConnection");
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Socket For Port. Received a new connection. id: " + rdConnection.getConnectionId() + ", client port: " + rdConnection.getClientInitiatedPortNumber(), e$iv);
        }
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)("Port forwarding: Connection: " + this$0.rdPort.getPortNumber() + ", id: " + rdConnection.getConnectionId()), (int)0, () -> SocketWrapperForPort.lambda$1$1(rdConnection, this$0, connectionLifetime, $incomingSignalsScheduler), (int)21, null);
        connectionLifetime.onTermination(() -> SocketWrapperForPort.lambda$1$2(rdConnection));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$1(RdConnection $rdConnection, SocketWrapperForPort this$0, Lifetime $connectionLifetime, SingleThreadScheduler $incomingSignalsScheduler) {
        logger.info("Port Forwarding. New connection from client started. id: " + $rdConnection.getConnectionId());
        this$0.monitorConnection($connectionLifetime, this$0.rdPort, $rdConnection, (IScheduler)$incomingSignalsScheduler);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$2(RdConnection $rdConnection) {
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Port Forwarding. Lifetime of rdConnection is terminating. id: " + $rdConnection.getConnectionId(), e$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit monitorConnection$lambda$1(Socket $socket, int $portNumber, String $connectionId, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            Logger logger;
            Logger $this$debug_u24default$iv = SocketWrapperForPort.logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("clientSocketInputShutdown -> Closing connection to <" + $portNumber + ">, id: " + $connectionId, e$iv);
            }
            $socket.shutdownOutput();
            if ($socket.isInputShutdown()) {
                $this$debug_u24default$iv = SocketWrapperForPort.logger;
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Got clientSocketInputShutdown. isInputShutdown is true. Closing socket of <" + $portNumber + ">, id: " + $connectionId, e$iv);
                }
                $socket.close();
            }
        }
        catch (Throwable e) {
            logger.warn("clientSocketInputShutdown: Failed to shutdownOutput of <" + $portNumber + ">, id: " + $connectionId, e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit monitorConnection$lambda$2(Socket $socket, int $portNumber, String $connectionId, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            Logger logger;
            Logger $this$debug_u24default$iv = SocketWrapperForPort.logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Got clientSocketOutputShutdown. Make socket.shutdownInput() of <" + $portNumber + ">, id: " + $connectionId, e$iv);
            }
            $socket.shutdownInput();
            if ($socket.isOutputShutdown()) {
                $this$debug_u24default$iv = SocketWrapperForPort.logger;
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Got clientSocketOutputShutdown. isOutputShutdown is true. Closing socket of <" + $portNumber + ">, id: " + $connectionId, e$iv);
                }
                $socket.close();
            }
        }
        catch (Throwable e) {
            logger.warn("clientSocketOutputShutdown: Failed to shutdownInput of <" + $portNumber + ">, id: " + $connectionId, e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit monitorConnection$lambda$3(SocketWrapperForPort this$0, Socket $socket, int $portNumber, String $connectionId, RdConnection $rdConnection, DebugTrafficInfo data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this$0.receivedBytesCounter.add((long)data.getBytes().length);
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("got chunk " + data.getCounter() + " on id: " + $connectionId);
            }
            $socket.getOutputStream().write(data.getBytes());
        }
        catch (IOException e) {
            logger.debug("sendToServer: Failed to write to outputStream of <" + $portNumber + ">, id: " + $connectionId, (Throwable)e);
            $rdConnection.getDestinationSocketOutputShutdown().fire((Object)Unit.INSTANCE);
        }
        return Unit.INSTANCE;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SocketWrapperForPort.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/SocketWrapperForPort$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

