/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetTime;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;

public interface JdbcInjection
extends Serializable {
    public void inject(int var1, @NotNull RemotePreparedStatementImpl var2, @NotNull JdbcHelperImpl var3) throws Exception;

    public static class OraTimestampInjection
    implements JdbcInjection {
        private final String myValue;

        public OraTimestampInjection(@NotNull String value) {
            if (value == null) {
                OraTimestampInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                OraTimestampInjection.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                OraTimestampInjection.$$$reportNull$$$0(2);
            }
            Class<?> aClass = helper.classForName("oracle.sql.TIMESTAMPTZ");
            Constructor<?> constructor = aClass.getConstructor(Connection.class, String.class);
            Object o = constructor.newInstance(helper.getConnection(), this.myValue.replaceAll("\\+", ""));
            statement.setObject(idx, o);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$OraTimestampInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MsDateTimeOffsetInjection
    implements JdbcInjection {
        private final String myValue;

        public MsDateTimeOffsetInjection(@NotNull String value) {
            if (value == null) {
                MsDateTimeOffsetInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                MsDateTimeOffsetInjection.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                MsDateTimeOffsetInjection.$$$reportNull$$$0(2);
            }
            statement.setObject(idx, this.myValue, -155);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$MsDateTimeOffsetInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SFlakeTimestampInjection
    implements JdbcInjection {
        private final Timestamp myValue;

        public SFlakeTimestampInjection(@NotNull Timestamp value) {
            if (value == null) {
                SFlakeTimestampInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                SFlakeTimestampInjection.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                SFlakeTimestampInjection.$$$reportNull$$$0(2);
            }
            statement.setString(idx, this.myValue.toString() + " +0000");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$SFlakeTimestampInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UtcTimestampInjection
    implements JdbcInjection {
        private final Timestamp myValue;

        public UtcTimestampInjection(@NotNull Timestamp value) {
            if (value == null) {
                UtcTimestampInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                UtcTimestampInjection.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                UtcTimestampInjection.$$$reportNull$$$0(2);
            }
            statement.setTimestamp(idx, this.myValue, JdbcNativeUtil.getUtcCalendar());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$UtcTimestampInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OffsetTimeInjection
    implements JdbcInjection {
        private final OffsetTime myValue;

        public OffsetTimeInjection(@NotNull OffsetTime value) {
            if (value == null) {
                OffsetTimeInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                OffsetTimeInjection.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                OffsetTimeInjection.$$$reportNull$$$0(2);
            }
            statement.setObject(idx, this.myValue, 2013);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$OffsetTimeInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DefaultTimestampInjection
    implements JdbcInjection {
        private final String myValue;

        public DefaultTimestampInjection(@NotNull String value) {
            if (value == null) {
                DefaultTimestampInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                DefaultTimestampInjection.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                DefaultTimestampInjection.$$$reportNull$$$0(2);
            }
            statement.setObject(idx, this.myValue, 93);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$DefaultTimestampInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateInjection
    implements JdbcInjection {
        private final Date myDate;

        public DateInjection(@NotNull Date date) {
            if (date == null) {
                DateInjection.$$$reportNull$$$0(0);
            }
            this.myDate = date;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                DateInjection.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                DateInjection.$$$reportNull$$$0(2);
            }
            if (helper.supportsCalendarInPreparedStatement()) {
                try {
                    statement.setDate(idx, this.myDate, JdbcNativeUtil.getUtcCalendar());
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            statement.setDate(idx, this.myDate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "date";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$DateInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeInjection
    implements JdbcInjection {
        private final Calendar myCalendar;
        private final Time myDate;

        public TimeInjection(@NotNull Calendar calendar, @NotNull Time date) {
            if (calendar == null) {
                TimeInjection.$$$reportNull$$$0(0);
            }
            if (date == null) {
                TimeInjection.$$$reportNull$$$0(1);
            }
            this.myCalendar = calendar;
            this.myDate = date;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement, @NotNull JdbcHelperImpl helper) throws Exception {
            if (statement == null) {
                TimeInjection.$$$reportNull$$$0(2);
            }
            if (helper == null) {
                TimeInjection.$$$reportNull$$$0(3);
            }
            if (helper.supportsCalendarInPreparedStatement()) {
                try {
                    statement.setTime(idx, this.myDate, this.myCalendar);
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            statement.setTime(idx, this.myDate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calendar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "date";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$TimeInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

