/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GBaseJdbcHelper
extends MysqlBaseJdbcHelper {
    private static final Pattern GITBASE_VERSION_PATTERN = Pattern.compile("(?:\\d+(?:\\.\\d+)+)-v(\\d+(?:\\.\\d+)+)");

    public GBaseJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("GITBASE", version, connection, jdbcClassLoader);
    }

    public GBaseJdbcHelper() {
        this(null, null, null);
    }

    private GBaseJdbcHelper(@NotNull GBaseJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            GBaseJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            GBaseJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return GBaseJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new GBaseJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            GBaseJdbcHelper.$$$reportNull$$$0(2);
        }
        return new GBaseJdbcHelper(this, jdbcClassLoader);
    }

    @NotNull
    static GBaseJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr, @Nullable ClassLoader jdbcClassLoader) {
        String version = GBaseJdbcHelper.extractVersion(versionStr);
        return new GBaseJdbcHelper(version, delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, GITBASE_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/GBaseJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

