/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.profiler;

import com.intellij.build.events.StartEvent;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.gradle.profiler.GradleRunConfigurationExtensionKt;
import com.intellij.gradle.profiler.OnTaskStartedListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.NewProcessStartedFromGradleCommunicator;
import com.intellij.profiler.ultimate.async.StartedFromExternalSystemProcess;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.GradleTasksUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001aL\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0017H\u0000\u001a,\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00100 H\u0002\"'\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"'\u0010\u0007\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\b0\b0\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\""}, d2={"targetTaskFqnKey", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTargetTaskFqnKey", "()Lcom/intellij/openapi/util/Key;", "noJavaTaskDataInfo", "", "getNoJavaTaskDataInfo", "doProcessGradleTasks", "runConfiguration", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "javaTaskDataAvailable", "findTargetTask", "doAttachToGradleProcess", "", "T", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "profilerProcessFactory", "Lkotlin/Function2;", "Lcom/intellij/profiler/ultimate/NewProcessStartedFromGradleCommunicator;", "", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/ultimate/async/StartedFromExternalSystemProcess;", "onTaskStarted", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler;", "targetTask", "onTaskStartedCallback", "Lkotlin/Function1;", "Lcom/intellij/build/events/StartEvent;", "intellij.gradle.profiler"})
@SourceDebugExtension(value={"SMAP\nGradleRunConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleRunConfigurationExtension.kt\ncom/intellij/gradle/profiler/GradleRunConfigurationExtensionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1761#2,3:110\n1563#2:113\n1634#2,3:114\n774#2:117\n865#2,2:118\n1617#2,9:120\n1869#2:129\n1870#2:132\n1626#2:133\n1#3:130\n1#3:131\n*S KotlinDebug\n*F\n+ 1 GradleRunConfigurationExtension.kt\ncom/intellij/gradle/profiler/GradleRunConfigurationExtensionKt\n*L\n40#1:110,3\n49#1:113\n49#1:114,3\n50#1:117\n50#1:118,2\n52#1:120,9\n52#1:129\n52#1:132\n52#1:133\n52#1:131\n*E\n"})
public final class GradleRunConfigurationExtensionKt {
    @NotNull
    private static final Key<String> targetTaskFqnKey;
    @NotNull
    private static final Key<Boolean> noJavaTaskDataInfo;

    @NotNull
    public static final Key<String> getTargetTaskFqnKey() {
        return targetTaskFqnKey;
    }

    @NotNull
    public static final Key<Boolean> getNoJavaTaskDataInfo() {
        return noJavaTaskDataInfo;
    }

    public static final boolean doProcessGradleTasks(@NotNull GradleRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        if (GradleRunConfigurationExtensionKt.javaTaskDataAvailable(runConfiguration)) {
            String string = GradleRunConfigurationExtensionKt.findTargetTask(runConfiguration);
            if (string == null) {
                return false;
            }
            String targetTask = string;
            runConfiguration.putUserData(targetTaskFqnKey, (Object)targetTask);
        } else {
            runConfiguration.putUserData(noJavaTaskDataInfo, (Object)true);
        }
        return true;
    }

    private static final boolean javaTaskDataAvailable(GradleRunConfiguration runConfiguration) {
        boolean bl;
        block4: {
            String gradleProjectPath = runConfiguration.getSettings().getExternalProjectPath();
            Project project = runConfiguration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            MultiMap multiMap = (MultiMap)GradleTasksUtilKt.getGradleTasks((Project)project).get(gradleProjectPath);
            if (multiMap == null) {
                return false;
            }
            MultiMap allKnownTasks = multiMap;
            Collection collection = allKnownTasks.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GradleTaskData it = (GradleTaskData)element$iv;
                    boolean bl2 = false;
                    if (!it.isJvm()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final String findTargetTask(GradleRunConfiguration runConfiguration) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        String gradleProjectPath = runConfiguration.getSettings().getExternalProjectPath();
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        MultiMap multiMap = (MultiMap)GradleTasksUtilKt.getGradleTasks((Project)project).get(gradleProjectPath);
        if (multiMap == null) {
            return null;
        }
        MultiMap allKnownTasks = multiMap;
        Collection collection = allKnownTasks.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GradleTaskData gradleTaskData = (GradleTaskData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to((Object)it.getFqnTaskName(), (Object)it));
        }
        List fqnTasks = (List)destination$iv$iv;
        Iterable $this$filter$iv = fqnTasks;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair bl = (Pair)element$iv$iv;
            boolean bl2 = false;
            GradleTaskData task = (GradleTaskData)bl.component2();
            if (!(task.isTest() || task.isJvm())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List suitableTasks = (List)destination$iv$iv2;
        List list = runConfiguration.getSettings().getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTaskNames(...)");
        List candidates = list;
        Iterable $this$mapNotNull$iv = candidates;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filterTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object v4;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String name = (String)element$iv$iv;
                boolean bl3 = false;
                Iterable iterable2 = suitableTasks;
                for (Object t : iterable2) {
                    Pair pair = (Pair)t;
                    boolean bl4 = false;
                    String fqnTaskName = (String)pair.component1();
                    Intrinsics.checkNotNull((Object)name);
                    if (!StringsKt.endsWith$default((String)fqnTaskName, (String)name, (boolean)false, (int)2, null)) continue;
                    v4 = t;
                    break block5;
                }
                v4 = null;
            }
            Pair pair = v4;
            if ((pair != null ? (String)pair.getFirst() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List suitableCandidates = (List)destination$iv$iv3;
        return (String)CollectionsKt.firstOrNull((List)suitableCandidates);
    }

    public static final <T> void doAttachToGradleProcess(@NotNull JavaProfilerConfigurationExtension<T> $this$doAttachToGradleProcess, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull ProcessHandler handler, @NotNull Function2<? super NewProcessStartedFromGradleCommunicator, ? super Long, ? extends ProfilerProcess<StartedFromExternalSystemProcess>> profilerProcessFactory) {
        Intrinsics.checkNotNullParameter($this$doAttachToGradleProcess, (String)"<this>");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(profilerProcessFactory, (String)"profilerProcessFactory");
        if (!(handler instanceof ExternalSystemProcessHandler) || !(runConfiguration instanceof GradleRunConfiguration)) {
            return;
        }
        if (Intrinsics.areEqual((Object)((GradleRunConfiguration)runConfiguration).getUserData(noJavaTaskDataInfo), (Object)true)) {
            ((GradleRunConfiguration)runConfiguration).putUserData(noJavaTaskDataInfo, null);
            $this$doAttachToGradleProcess.openToolWindowAndReportStart((ProfilerProcess)profilerProcessFactory.invoke((Object)new NewProcessStartedFromGradleCommunicator((ExternalSystemProcessHandler)handler), (Object)System.currentTimeMillis()), runConfiguration);
            return;
        }
        String string = (String)((GradleRunConfiguration)runConfiguration).getUserData(targetTaskFqnKey);
        if (string == null) {
            return;
        }
        String targetTask = string;
        ((GradleRunConfiguration)runConfiguration).putUserData(targetTaskFqnKey, null);
        ExternalSystemProgressNotificationManager.getInstance();
        GradleRunConfigurationExtensionKt.onTaskStarted((ExternalSystemProcessHandler)handler, targetTask, (Function1<? super StartEvent, Unit>)((Function1)arg_0 -> GradleRunConfigurationExtensionKt.doAttachToGradleProcess$lambda$0($this$doAttachToGradleProcess, profilerProcessFactory, handler, runConfiguration, arg_0)));
    }

    private static final void onTaskStarted(ExternalSystemProcessHandler handler, String targetTask, Function1<? super StartEvent, Unit> onTaskStartedCallback) {
        ExternalSystemTask externalSystemTask = handler.getTask();
        if (externalSystemTask == null) {
            return;
        }
        ExternalSystemTask buildTask = externalSystemTask;
        ExternalSystemProgressNotificationManager notificationManager = ExternalSystemProgressNotificationManager.getInstance();
        OnTaskStartedListener taskListener2 = new OnTaskStartedListener(targetTask, onTaskStartedCallback, notificationManager){
            final /* synthetic */ Function1<StartEvent, Unit> $onTaskStartedCallback;
            final /* synthetic */ ExternalSystemProgressNotificationManager $notificationManager;
            {
                this.$onTaskStartedCallback = $onTaskStartedCallback;
                this.$notificationManager = $notificationManager;
                super($targetTask);
            }

            public void onTaskStarted(StartEvent startEvent) {
                Intrinsics.checkNotNullParameter((Object)startEvent, (String)"startEvent");
                this.$onTaskStartedCallback.invoke((Object)startEvent);
                this.$notificationManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
            }
        };
        notificationManager.addNotificationListener(buildTask.getId(), (ExternalSystemTaskNotificationListener)taskListener2);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(notificationManager, taskListener2){
            final /* synthetic */ ExternalSystemProgressNotificationManager $notificationManager;
            final /* synthetic */ onTaskStarted.taskListener.1 $taskListener;
            {
                this.$notificationManager = $notificationManager;
                this.$taskListener = $taskListener;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$notificationManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this.$taskListener);
            }
        });
    }

    private static final Unit doAttachToGradleProcess$lambda$0(JavaProfilerConfigurationExtension $this_doAttachToGradleProcess, Function2 $profilerProcessFactory, ProcessHandler $handler, RunConfigurationBase $runConfiguration, StartEvent startEvent) {
        Intrinsics.checkNotNullParameter((Object)startEvent, (String)"startEvent");
        $this_doAttachToGradleProcess.openToolWindowAndReportStart((ProfilerProcess)$profilerProcessFactory.invoke((Object)new NewProcessStartedFromGradleCommunicator((ExternalSystemProcessHandler)$handler), (Object)startEvent.getEventTime()), $runConfiguration);
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"profiler.gradle.configuration.target.task.name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        targetTaskFqnKey = key;
        Key key2 = Key.create((String)"profiler.gradle.configuration.no.java.task.data.info");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        noJavaTaskDataInfo = key2;
    }
}

