/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.plugins.webDeployment.WDBundle;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="advancedOptions")
public class AdvancedOptionsConfig
implements Cloneable {
    public static final int DEFAULT_NUMBER_OF_CONNECTIONS = 5;
    public static final int DEFAULT_KEEP_ALIVE_TIMEOUT = 300000;
    @NonNls
    private static final String FILENAMES_ENCODING_PROPERTY = "com.jetbrains.plugins.webDeployment.filenames_encoding";
    @NonNls
    private static final String DISABLING_TLS_13_PROTOCOLS = "TLSv1,TLSv1.1,TLSv1.2";
    private boolean myShowHiddenFiles;
    private boolean myPassiveMode;
    private int myNumberOfConnections = 5;
    private boolean myCompatibilityMode = false;
    private DataChannelProtectionLevel myDataChannelProtectionLevel = DataChannelProtectionLevel.Default;
    private String myControlEncoding = System.getProperty("com.jetbrains.plugins.webDeployment.filenames_encoding", Charset.defaultCharset().name());
    private boolean myForceListCommand = false;
    private int myKeepAliveTimeout = 300000;
    private JBFtpKeepAliveCommand myKeepAliveFtpCommand = JBFtpKeepAliveCommand.NOOP;
    private boolean myShareSslContext = false;
    private String myEnabledFtpsProtocols;
    private boolean myUseRsync = false;
    private boolean myUseSudo = false;

    @Attribute(value="showHiddenFiles")
    public boolean isShowHiddenFiles() {
        return this.myShowHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.myShowHiddenFiles = showHiddenFiles;
    }

    @Attribute(value="passiveMode")
    public boolean isPassiveMode() {
        return this.myPassiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.myPassiveMode = passiveMode;
    }

    @Attribute(value="connections")
    public int getNumberOfConnections() {
        return this.myNumberOfConnections;
    }

    public void setNumberOfConnections(int numberOfConnections) {
        this.myNumberOfConnections = numberOfConnections;
    }

    @Attribute(value="compatibilityMode")
    public boolean isCompatibilityMode() {
        return this.myCompatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.myCompatibilityMode = compatibilityMode;
    }

    @Attribute(value="dataProtectionLevel")
    public DataChannelProtectionLevel getDataChannelProtectionLevel() {
        return this.myDataChannelProtectionLevel;
    }

    public void setDataChannelProtectionLevel(DataChannelProtectionLevel dataChannelProtectionLevel) {
        this.myDataChannelProtectionLevel = dataChannelProtectionLevel;
    }

    @Attribute(value="controlEncoding")
    public String getControlEncoding() {
        return this.myControlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        this.myControlEncoding = controlEncoding;
    }

    @Attribute(value="forceListCommand")
    public boolean isForceListCommand() {
        return this.myForceListCommand;
    }

    public void setForceListCommand(boolean forceListCommand) {
        this.myForceListCommand = forceListCommand;
    }

    @Attribute(value="keepAliveTimeout")
    public int getKeepAliveTimeout() {
        return this.myKeepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.myKeepAliveTimeout = keepAliveTimeout;
    }

    @Attribute(value="keepAliveCommand")
    public JBFtpKeepAliveCommand getKeepAliveFtpCommand() {
        return this.myKeepAliveFtpCommand;
    }

    public void setKeepAliveFtpCommand(JBFtpKeepAliveCommand keepAliveFtpCommand) {
        this.myKeepAliveFtpCommand = keepAliveFtpCommand;
    }

    @Attribute(value="shareSSLContext")
    public boolean isShareSslContext() {
        return this.myShareSslContext;
    }

    public void setShareSslContext(boolean shareSslContext) {
        this.myShareSslContext = shareSslContext;
    }

    @Attribute(value="enabledFtpsProtocols")
    public String getEnabledFtpsProtocols() {
        return this.myEnabledFtpsProtocols;
    }

    public void setEnabledFtpsProtocols(String enabledFtpsProtocols) {
        this.myEnabledFtpsProtocols = enabledFtpsProtocols;
    }

    public boolean isFtpsDisabledTls13() {
        return !StringUtil.isEmptyOrSpaces((String)this.myEnabledFtpsProtocols);
    }

    public void setFtpsDisabledTls13(boolean disabled) {
        this.myEnabledFtpsProtocols = disabled ? DISABLING_TLS_13_PROTOCOLS : null;
    }

    @Attribute(value="isUseRsync")
    public boolean isUseRsync() {
        return this.myUseRsync;
    }

    @Attribute(value="isUseSudo")
    public boolean isUseSudo() {
        return this.myUseSudo;
    }

    public void setUseRsync(boolean useRsync) {
        this.myUseRsync = useRsync;
    }

    public void setUseSudo(boolean useSudo) {
        this.myUseSudo = useSudo;
    }

    public AdvancedOptionsConfig clone() {
        try {
            return (AdvancedOptionsConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancedOptionsConfig that = (AdvancedOptionsConfig)o;
        if (this.myNumberOfConnections != that.myNumberOfConnections) {
            return false;
        }
        if (this.myPassiveMode != that.myPassiveMode) {
            return false;
        }
        if (this.myShowHiddenFiles != that.myShowHiddenFiles) {
            return false;
        }
        if (this.myCompatibilityMode != that.myCompatibilityMode) {
            return false;
        }
        if (this.myDataChannelProtectionLevel != that.myDataChannelProtectionLevel) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myControlEncoding, (CharSequence)that.myControlEncoding)) {
            return false;
        }
        if (this.myForceListCommand != that.myForceListCommand) {
            return false;
        }
        if (this.myKeepAliveTimeout != that.myKeepAliveTimeout) {
            return false;
        }
        if (this.myKeepAliveFtpCommand != that.myKeepAliveFtpCommand) {
            return false;
        }
        if (this.myShareSslContext != that.myShareSslContext) {
            return false;
        }
        if (!Objects.equals(this.myEnabledFtpsProtocols, that.myEnabledFtpsProtocols)) {
            return false;
        }
        return this.myUseRsync == that.myUseRsync;
    }

    public int hashCode() {
        int result = this.myShowHiddenFiles ? 1 : 0;
        result = 31 * result + (this.myPassiveMode ? 1 : 0);
        result = 31 * result + (this.myCompatibilityMode ? 1 : 0);
        result = 31 * result + this.myNumberOfConnections;
        result = 31 * result + this.myDataChannelProtectionLevel.hashCode();
        result = 31 * result + (this.myControlEncoding != null ? this.myControlEncoding.hashCode() : 0);
        result = 31 * result + (this.myForceListCommand ? 1 : 0);
        result = 31 * result + this.myKeepAliveTimeout;
        result = 31 * result + this.myKeepAliveFtpCommand.hashCode();
        result = 31 * result + (this.myShareSslContext ? 1 : 0);
        result = 31 * result + (this.myEnabledFtpsProtocols != null ? this.myEnabledFtpsProtocols.hashCode() : 0);
        result = 31 * result + (this.myUseRsync ? 1 : 0);
        return result;
    }

    public static enum DataChannelProtectionLevel {
        Default{

            @Override
            public FtpsDataChannelProtectionLevel getValue() {
                return null;
            }

            @Override
            @NotNull
            public String getPresentableValue() {
                String string = WDBundle.message("ftps.data.channel.protection.level.default.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$DataChannelProtectionLevel$1", "getPresentableValue"));
            }
        }
        ,
        Clear{

            @Override
            public FtpsDataChannelProtectionLevel getValue() {
                return FtpsDataChannelProtectionLevel.C;
            }

            @Override
            @NotNull
            public String getPresentableValue() {
                String string = WDBundle.message("ftps.data.channel.protection.level.c.title", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$DataChannelProtectionLevel$2", "getPresentableValue"));
            }
        }
        ,
        Private{

            @Override
            public FtpsDataChannelProtectionLevel getValue() {
                return FtpsDataChannelProtectionLevel.P;
            }

            @Override
            @NotNull
            public String getPresentableValue() {
                String string = WDBundle.message("ftps.data.channel.protection.level.p.title", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/AdvancedOptionsConfig$DataChannelProtectionLevel$3", "getPresentableValue"));
            }
        };


        @Nullable
        public abstract FtpsDataChannelProtectionLevel getValue();

        @NotNull
        public abstract String getPresentableValue();
    }
}

