/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedOptionsForm {
    private JCheckBox myShowHiddenFilesCheckBox;
    private JPanel myContentPane;
    private JCheckBox myPassiveModeCheckBox;
    private JTextField myConnectionsTextField;
    private JCheckBox myCompatibilityModeCheckBox;
    private JComboBox<AdvancedOptionsConfig.DataChannelProtectionLevel> myDataProtectionLevelComboBox;
    private JTextField myControlEncodingTextField;
    private JBCheckBox myForceListCommandCheckBox;
    private JCheckBox myKeepAliveCheckbox;
    private JTextField myKeepAliveTimeoutField;
    private JLabel myKeepAliveTimeoutFieldLabel;
    private JComboBox<JBFtpKeepAliveCommand> myKeepAliveFtpCommandComboBox;
    private JBCheckBox myShareSslContextCheckbox;
    private JRadioButton myExplicitFTPSRadioButton;
    private JRadioButton myImplicitFTPSRadioButton;
    private JPanel myFtpPanel;
    private JPanel myFtpsPanel;
    private JPanel myKeepAliveFtpPanel;
    private JBCheckBox myFtpsDisableTLS13;
    private int defaultKeepAliveTimeout;

    public AdvancedOptionsForm() {
        this.$$$setupUI$$$();
        this.myDataProtectionLevelComboBox.setModel((ComboBoxModel<AdvancedOptionsConfig.DataChannelProtectionLevel>)new EnumComboBoxModel(AdvancedOptionsConfig.DataChannelProtectionLevel.class));
        this.myDataProtectionLevelComboBox.setRenderer((ListCellRenderer<AdvancedOptionsConfig.DataChannelProtectionLevel>)SimpleListCellRenderer.create((String)"", AdvancedOptionsConfig.DataChannelProtectionLevel::getPresentableValue));
        this.myKeepAliveFtpCommandComboBox.setModel((ComboBoxModel<JBFtpKeepAliveCommand>)new EnumComboBoxModel(JBFtpKeepAliveCommand.class));
        this.myKeepAliveFtpCommandComboBox.setRenderer((ListCellRenderer<JBFtpKeepAliveCommand>)SimpleListCellRenderer.create((String)"", JBFtpKeepAliveCommand::getCommand));
        this.myKeepAliveCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedOptionsForm.this.myKeepAliveCheckbox.isSelected()) {
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setEnabled(AdvancedOptionsForm.this.myKeepAliveCheckbox.isEnabled());
                    int timeout = AdvancedOptionsForm.this.defaultKeepAliveTimeout > 0 ? AdvancedOptionsForm.this.defaultKeepAliveTimeout : 300000;
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setText(String.valueOf(timeout / 1000));
                    IdeFocusManager.findInstanceByComponent((Component)AdvancedOptionsForm.this.myContentPane).requestFocus((Component)AdvancedOptionsForm.this.myKeepAliveTimeoutField, false);
                } else {
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setText("");
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setEnabled(false);
                }
            }
        });
        ButtonGroup sftpButtonGroup = new ButtonGroup();
        sftpButtonGroup.add(this.myExplicitFTPSRadioButton);
        sftpButtonGroup.add(this.myImplicitFTPSRadioButton);
    }

    public void reset(@NotNull SettingsDeployable deployable) {
        if (deployable == null) {
            AdvancedOptionsForm.$$$reportNull$$$0(0);
        }
        this.updateOnAccessTypeChange(deployable.getAccessType());
        if (deployable.isFtpsExplicit()) {
            this.myExplicitFTPSRadioButton.setSelected(true);
        } else {
            this.myImplicitFTPSRadioButton.setSelected(true);
        }
        AdvancedOptionsConfig config = deployable.getAdvancedOptions();
        this.myShowHiddenFilesCheckBox.setSelected(config.isShowHiddenFiles());
        this.myPassiveModeCheckBox.setSelected(config.isPassiveMode());
        this.myConnectionsTextField.setText(String.valueOf(config.getNumberOfConnections()));
        this.myCompatibilityModeCheckBox.setSelected(config.isCompatibilityMode());
        this.myDataProtectionLevelComboBox.setSelectedIndex(config.getDataChannelProtectionLevel().ordinal());
        this.myControlEncodingTextField.setText(config.getControlEncoding());
        this.myForceListCommandCheckBox.setSelected(config.isForceListCommand());
        int keepAliveTimeout = config.getKeepAliveTimeout();
        boolean keepAliveEnabled = keepAliveTimeout > 0;
        this.myKeepAliveCheckbox.setSelected(keepAliveEnabled);
        this.myKeepAliveTimeoutField.setEnabled(keepAliveEnabled && this.myKeepAliveCheckbox.isEnabled());
        this.myKeepAliveTimeoutField.setText(keepAliveEnabled ? String.valueOf(keepAliveTimeout / 1000) : "");
        this.myKeepAliveTimeoutFieldLabel.setEnabled(this.myKeepAliveCheckbox.isEnabled());
        this.defaultKeepAliveTimeout = keepAliveTimeout;
        this.myKeepAliveFtpCommandComboBox.setSelectedItem(config.getKeepAliveFtpCommand());
        this.myShareSslContextCheckbox.setSelected(config.isShareSslContext());
        this.myFtpsDisableTLS13.setSelected(config.isFtpsDisabledTls13());
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void apply(@NotNull SettingsDeployable deployable) {
        if (deployable == null) {
            AdvancedOptionsForm.$$$reportNull$$$0(1);
        }
        deployable.setFtpsExplicit(this.myExplicitFTPSRadioButton.isSelected());
        AdvancedOptionsConfig config = deployable.getAdvancedOptions();
        config.setShowHiddenFiles(this.myShowHiddenFilesCheckBox.isSelected());
        config.setPassiveMode(this.myPassiveModeCheckBox.isSelected());
        String connections = this.myConnectionsTextField.getText();
        config.setNumberOfConnections(AdvancedOptionsForm.parseInt(connections, 5));
        config.setCompatibilityMode(this.myCompatibilityModeCheckBox.isSelected());
        config.setDataChannelProtectionLevel((AdvancedOptionsConfig.DataChannelProtectionLevel)((Object)this.myDataProtectionLevelComboBox.getSelectedItem()));
        config.setControlEncoding(this.myControlEncodingTextField.getText());
        config.setForceListCommand(this.myForceListCommandCheckBox.isSelected());
        String timeout = this.myKeepAliveTimeoutField.getText();
        config.setKeepAliveTimeout(this.myKeepAliveCheckbox.isSelected() ? AdvancedOptionsForm.parseInt(timeout, 0) * 1000 : 0);
        config.setKeepAliveFtpCommand((JBFtpKeepAliveCommand)this.myKeepAliveFtpCommandComboBox.getSelectedItem());
        config.setShareSslContext(this.myShareSslContextCheckbox.isSelected());
        config.setFtpsDisabledTls13(this.myFtpsDisableTLS13.isSelected());
    }

    public boolean isModified(@NotNull SettingsDeployable deployable) {
        int uiTimeout;
        if (deployable == null) {
            AdvancedOptionsForm.$$$reportNull$$$0(2);
        }
        AdvancedOptionsConfig config = deployable.getAdvancedOptions();
        if (deployable.isFtpsExplicit() != this.myExplicitFTPSRadioButton.isSelected()) {
            return true;
        }
        if (config.isShowHiddenFiles() != this.myShowHiddenFilesCheckBox.isSelected()) {
            return true;
        }
        if (config.isPassiveMode() != this.myPassiveModeCheckBox.isSelected()) {
            return true;
        }
        String connectionsText = this.myConnectionsTextField.getText();
        int connectionsValue = AdvancedOptionsForm.parseInt(connectionsText, 5);
        if (config.getNumberOfConnections() != connectionsValue) {
            return true;
        }
        if (config.isCompatibilityMode() != this.myCompatibilityModeCheckBox.isSelected()) {
            return true;
        }
        if (config.getDataChannelProtectionLevel() != this.myDataProtectionLevelComboBox.getSelectedItem()) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)config.getControlEncoding(), (CharSequence)this.myControlEncodingTextField.getText())) {
            return true;
        }
        if (config.isForceListCommand() != this.myForceListCommandCheckBox.isSelected()) {
            return true;
        }
        int keepAliveTimeout = config.getKeepAliveTimeout();
        if (this.myKeepAliveCheckbox.isSelected() ? keepAliveTimeout != (uiTimeout = AdvancedOptionsForm.parseInt(this.myKeepAliveTimeoutField.getText(), 0) * 1000) : keepAliveTimeout > 0) {
            return true;
        }
        String timeout = this.myKeepAliveTimeoutField.getText();
        config.setKeepAliveTimeout(this.myKeepAliveCheckbox.isSelected() ? AdvancedOptionsForm.parseInt(timeout, 0) * 1000 : 0);
        if (config.getKeepAliveFtpCommand() != this.myKeepAliveFtpCommandComboBox.getSelectedItem()) {
            return true;
        }
        if (config.isShareSslContext() != this.myShareSslContextCheckbox.isSelected()) {
            return true;
        }
        return config.isFtpsDisabledTls13() != this.myFtpsDisableTLS13.isSelected();
    }

    void updateOnAccessTypeChange(AccessType accessType) {
        this.myFtpsPanel.setVisible(accessType == AccessType.FTPS);
        this.myFtpPanel.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myKeepAliveFtpPanel.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        if (accessType == AccessType.SFTP) {
            this.myKeepAliveCheckbox.setEnabled(false);
            this.myKeepAliveCheckbox.setToolTipText(WDBundle.message("disabled.keep.alive.settings.tooltip", new Object[0]));
            this.myKeepAliveTimeoutField.setEnabled(false);
            this.myKeepAliveTimeoutField.setToolTipText(WDBundle.message("disabled.keep.alive.settings.tooltip", new Object[0]));
            this.myKeepAliveTimeoutFieldLabel.setEnabled(false);
        } else {
            this.myKeepAliveCheckbox.setEnabled(true);
            this.myKeepAliveTimeoutField.setEnabled(this.myKeepAliveCheckbox.isSelected());
            this.myKeepAliveTimeoutFieldLabel.setEnabled(true);
        }
    }

    public void updateFromSshConfig(@NotNull SshConfig config) {
        SshConnectionConfigPatch configPatch;
        if (config == null) {
            AdvancedOptionsForm.$$$reportNull$$$0(3);
        }
        if ((configPatch = config.getConnectionConfigPatch()) != null) {
            Duration serverAliveInterval = configPatch.getServerAliveInterval();
            if (serverAliveInterval != null) {
                this.myKeepAliveCheckbox.setSelected(true);
                this.myKeepAliveTimeoutField.setText(String.valueOf(serverAliveInterval.toSeconds()));
            } else {
                this.myKeepAliveCheckbox.setSelected(false);
            }
        }
    }

    private static int parseInt(String timeout, int defaultUnparsedValue) {
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            return defaultUnparsedValue;
        }
    }

    @Nullable
    public String getErrorMessage() {
        String connections = this.myConnectionsTextField.getText();
        if (StringUtil.isEmpty((String)connections)) {
            return WDBundle.message("empty.connections", new Object[0]);
        }
        try {
            if (Integer.parseInt(connections) < 0) {
                return WDBundle.message("invalid.connections", new Object[0]);
            }
        }
        catch (NumberFormatException e) {
            return WDBundle.message("invalid.connections", new Object[0]);
        }
        if (this.myKeepAliveCheckbox.isSelected()) {
            String text = this.myKeepAliveTimeoutField.getText();
            if (StringUtil.isEmpty((String)text)) {
                return WDBundle.message("empty.keep.alive.timeout", new Object[0]);
            }
            try {
                if (Integer.parseInt(text) < 1) {
                    return WDBundle.message("invalid.keep.alive.timeout", new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                return WDBundle.message("invalid.keep.alive.timeout", new Object[0]);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/AdvancedOptionsForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFromSshConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JLabel jLabel;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JBCheckBox jBCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel3;
        JTextField jTextField3;
        JPanel jPanel4;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myControlEncodingTextField = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.command.encoding"));
        jPanel4.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFtpPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.ftp.use.list.command"));
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompatibilityModeCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(1, 1, 0, 1));
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.ftp.list.compatible"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myForceListCommandCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.ftp.list.mlsd"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myShowHiddenFilesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.ftp.hidden"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPassiveModeCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.ftp.passive"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFtpsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.data.channel.protection"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.tls"));
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExplicitFTPSRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.tls.explicit"));
        ((Component)jRadioButton2).setVisible(true);
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImplicitFTPSRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.tls.implicit"));
        ((Component)jRadioButton).setVisible(true);
        jPanel6.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myDataProtectionLevelComboBox = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myShareSslContextCheckbox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.reuse.ssl.session"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myFtpsDisableTLS13 = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.ftps.disable.tls.13"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, true));
        this.myKeepAliveCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.keep.alive.messages"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepAliveTimeoutField = jTextField2 = new JTextField();
        jTextField2.setMargin(new Insets(5, 14, 5, 14));
        jTextField2.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        jTextField2.setMinimumSize(new Dimension(30, 27));
        jTextField2.setPreferredSize(new Dimension(30, 27));
        jPanel7.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myKeepAliveTimeoutFieldLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.keep.alive.seconds"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myKeepAliveFtpPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.keep.alive.command"));
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myKeepAliveFtpCommandComboBox = jComboBox2;
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConnectionsTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/WDBundle", AdvancedOptionsForm.class).getString("advanced.connections"));
        jPanel4.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jComboBox);
        jLabel.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jComboBox2);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

