/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierFormattingScopeKt;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"isApplicable", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.prettierJS"})
public final class PrettierPostFormatProcessorKt {
    public static final boolean isApplicable(@NotNull PsiFile psiFile) {
        Template template;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PrettierConfiguration prettierConfiguration = PrettierConfiguration.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)prettierConfiguration, (String)"getInstance(...)");
        PrettierConfiguration configuration = prettierConfiguration;
        if (!configuration.isRunOnReformat()) {
            return false;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file);
        if (fileEditor instanceof TextEditor && (template = TemplateManager.getInstance((Project)psiFile.getProject()).getActiveTemplate(((TextEditor)fileEditor).getEditor())) != null) {
            return false;
        }
        return PrettierFormattingScopeKt.isPrettierFormattingAllowedFor$default(project2, file, false, 4, null);
    }
}

