/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import java.lang.reflect.Constructor;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.w3c.dom.Element;

public final class ExceptionConverter {
    private ExceptionConverter() {
    }

    public static FileSystemException generate(DavException davExc) throws FileSystemException {
        String msg = davExc.getMessage();
        if (davExc.hasErrorCondition()) {
            try {
                Element error = davExc.toXml(DomUtil.createDocument());
                if (DomUtil.matches(error, "error", DavConstants.NAMESPACE) && DomUtil.hasChildElement(error, "exception", null)) {
                    Element exc = DomUtil.getChildElement(error, "exception", null);
                    if (DomUtil.hasChildElement(exc, "message", null)) {
                        msg = DomUtil.getChildText(exc, "message", null);
                    }
                    if (DomUtil.hasChildElement(exc, "class", null)) {
                        Class<?> cl = Class.forName(DomUtil.getChildText(exc, "class", null));
                        Constructor<?> excConstr = cl.getConstructor(String.class);
                        Object o = excConstr.newInstance(msg);
                        if (o instanceof FileSystemException) {
                            return (FileSystemException)o;
                        }
                        if (o instanceof Exception) {
                            return new FileSystemException(msg, (Throwable)((Exception)o));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        return new FileSystemException(msg);
    }
}

