/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Set;
import org.intellij.plugins.postcss.PostCssLanguage;
import org.intellij.plugins.postcss.lexer.PostCssTokenTypes;
import org.intellij.plugins.postcss.psi.PostCssSimpleVariableDeclaration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostCssSimpleVariableReference
extends PsiReferenceBase<PsiElement>
implements CssReference {
    private static final ResolveCache.AbstractResolver<PostCssSimpleVariableReference, PostCssSimpleVariableDeclaration> RESOLVER = (reference, incompleteCode) -> {
        String varName = reference.getValue();
        if (varName.isEmpty()) {
            return null;
        }
        Ref result = Ref.create();
        PostCssSimpleVariableReference.processSimpleVariableDeclarations(reference.getElement(), (Processor<PostCssSimpleVariableDeclaration>)((Processor)element -> {
            if (varName.equals(element.getName())) {
                result.set(element);
                return false;
            }
            return true;
        }));
        return (PostCssSimpleVariableDeclaration)result.get();
    };

    public PostCssSimpleVariableReference(@NotNull PsiElement element) {
        if (element == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    protected TextRange calculateDefaultRangeInElement() {
        String text = this.myElement.getText();
        if (text.startsWith("$(")) {
            if (text.endsWith(")")) {
                return TextRange.create((int)2, (int)(this.myElement.getTextLength() - 1));
            }
            return TextRange.create((int)2, (int)this.myElement.getTextLength());
        }
        return TextRange.create((int)1, (int)this.myElement.getTextLength());
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"inspections.unresolved.variable", (Object[])new Object[]{this.getCanonicalText()});
        if (string == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
    }

    public Object @NotNull [] getVariants() {
        SmartList result = new SmartList();
        PostCssSimpleVariableReference.processSimpleVariableDeclarations(this.myElement, (Processor<PostCssSimpleVariableDeclaration>)((Processor)element -> {
            LookupElementBuilder lookup = LookupElementBuilder.create((PsiNamedElement)element).withIcon(AllIcons.Nodes.Variable);
            CssTermList initializer = element.getInitializer();
            if (initializer != null) {
                lookup = lookup.withTailText(" " + initializer.getText(), true);
            }
            result.add((Object)lookup);
            return true;
        }));
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        String text;
        if (newElementName == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(3);
        }
        String newText = (text = this.myElement.getText()).startsWith("$(") ? "$(" + newElementName + ")" : "$" + newElementName;
        PsiFile file = PsiFileFactory.getInstance((Project)this.myElement.getProject()).createFileFromText((Language)PostCssLanguage.INSTANCE, (CharSequence)newText);
        PsiElement oldVarToken = this.myElement.getFirstChild();
        PsiElement newVarToken = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (oldVarToken != null && oldVarToken.getNode().getElementType() == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN && newVarToken.getNode().getElementType() == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN) {
            oldVarToken.replace(newVarToken);
        }
        return this.myElement;
    }

    private static void processSimpleVariableDeclarations(@NotNull PsiElement context, @NotNull Processor<PostCssSimpleVariableDeclaration> processor) {
        CssRulesetList rulesetList;
        if (context == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(5);
        }
        if ((rulesetList = (CssRulesetList)PsiTreeUtil.getParentOfType((PsiElement)context, CssRulesetList.class)) == null) {
            return;
        }
        if (!PostCssSimpleVariableReference.processSimpleVarsInRulesetList(rulesetList, processor)) {
            return;
        }
        PsiFile contextFile = context.getContainingFile();
        Set otherFiles = CssUtil.getImportedFiles((PsiFile)context.getContainingFile(), (PsiElement)context, (boolean)true);
        for (VirtualFile otherFile : otherFiles) {
            CssStylesheet otherStylesheet;
            CssRulesetList otherRulesetList;
            PsiFile otherPsiFile = contextFile.getManager().findFile(otherFile);
            if (!(otherPsiFile instanceof StylesheetFile) || otherFile.equals(contextFile.getVirtualFile()) || (otherRulesetList = (otherStylesheet = ((StylesheetFile)otherPsiFile).getStylesheet()) == null ? null : otherStylesheet.getRulesetList()) == null || PostCssSimpleVariableReference.processSimpleVarsInRulesetList(otherRulesetList, processor)) continue;
            return;
        }
    }

    private static boolean processSimpleVarsInRulesetList(@NotNull CssRulesetList rulesetList, @NotNull Processor<PostCssSimpleVariableDeclaration> processor) {
        if (rulesetList == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PostCssSimpleVariableReference.$$$reportNull$$$0(7);
        }
        for (PsiElement child = rulesetList.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PostCssSimpleVariableDeclaration) || processor.process((Object)((PostCssSimpleVariableDeclaration)child))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/postcss/references/PostCssSimpleVariableReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesetList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/postcss/references/PostCssSimpleVariableReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSimpleVariableDeclarations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processSimpleVarsInRulesetList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

