/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.build.jspValidation;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.PathStringDescriptors;

public final class JspDependenciesStorage
extends AbstractStateStorage<String, List<Pair<String, Long>>> {
    public JspDependenciesStorage(File storePath) throws IOException {
        super(storePath, PathStringDescriptors.createPathStringDescriptor(), (DataExternalizer)new DependenciesListExternalizer());
    }

    public void update(String path, @Nullable List<Pair<String, Long>> state) throws IOException {
        super.update((Object)FileUtil.toSystemIndependentName((String)path), state);
    }

    public void appendData(String path, List<Pair<String, Long>> data) throws IOException {
        super.appendData((Object)FileUtil.toSystemIndependentName((String)path), data);
    }

    public void appendData(String outputPath, String path, long timestamp) throws IOException {
        super.appendData((Object)outputPath, Collections.singletonList(Pair.create((Object)path, (Object)timestamp)));
    }

    public void remove(String path) throws IOException {
        super.remove((Object)FileUtil.toSystemIndependentName((String)path));
    }

    @Nullable
    public List<Pair<String, Long>> getState(String path) throws IOException {
        return (List)super.getState((Object)FileUtil.toSystemIndependentName((String)path));
    }

    private static class DependenciesListExternalizer
    implements DataExternalizer<List<Pair<String, Long>>> {
        private DependenciesListExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<Pair<String, Long>> value) throws IOException {
            if (out == null) {
                DependenciesListExternalizer.$$$reportNull$$$0(0);
            }
            for (Pair<String, Long> pair : value) {
                IOUtil.writeUTF((DataOutput)out, (String)((String)pair.first));
                out.writeLong((Long)pair.second);
            }
        }

        public List<Pair<String, Long>> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                DependenciesListExternalizer.$$$reportNull$$$0(1);
            }
            SmartList result = new SmartList();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                String path = IOUtil.readUTF((DataInput)stream);
                long timestamp = stream.readLong();
                result.add(Pair.create((Object)path, (Object)timestamp));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/javaee/build/jspValidation/JspDependenciesStorage$DependenciesListExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

