/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;

class ExplodedArtifactForModulesTemplate
extends ArtifactTemplate {
    private final PackagingElementResolvingContext myContext;
    private final JavaeeArtifactTypeBase myType;

    ExplodedArtifactForModulesTemplate(PackagingElementResolvingContext context, JavaeeArtifactTypeBase type) {
        this.myContext = context;
        this.myType = type;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getPresentableName() {
        return J2EEBundle.message((String)"action.create.artifact.from.modules.text", (Object[])new Object[0]);
    }

    public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
        List<Module> modules = ExplodedArtifactForModulesTemplate.getModulesWithAppropriateFacets(this.myType, this.myContext);
        ChooseModulesDialog dialog = new ChooseModulesDialog(this.myContext.getProject(), modules, J2EEBundle.message((String)"dialog.title.select.modules", (Object[])new Object[0]), J2EEBundle.message((String)"label.selected.modules.will.be.included.in.created.artifact.with.all.dependencies", (Object[])new Object[0]));
        dialog.show();
        List selected = dialog.getChosenElements();
        if (selected.isEmpty()) {
            return null;
        }
        ArtifactRootElement<?> rootElement = this.createRootElement(selected);
        String moduleName = ((Module)ContainerUtil.getFirstItem((Collection)selected, null)).getName();
        String artifactName = JavaeeUtil.suggestArtifactName(moduleName, null, this.myType.getFacetTypeId());
        return new ArtifactTemplate.NewArtifactConfiguration(rootElement, artifactName, (ArtifactType)this.myType);
    }

    public static List<Module> getModulesWithAppropriateFacets(JavaeeArtifactTypeBase type, PackagingElementResolvingContext context) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : context.getModulesProvider().getModules()) {
            Collection facets;
            if (!(ModuleType.get((Module)module) instanceof JavaModuleType) || (facets = context.getFacetsProvider().getFacetsByType(module, type.getFacetTypeId())).isEmpty()) continue;
            modules.add(module);
        }
        return modules;
    }

    private ArtifactRootElement<?> createRootElement(List<Module> mainModules) {
        LinkedHashSet modules = new LinkedHashSet();
        LinkedHashSet libraries = new LinkedHashSet();
        LinkedHashSet facets = new LinkedHashSet();
        OrderEnumerator orderEnumerator = ProjectRootManager.getInstance((Project)this.myContext.getProject()).orderEntries(mainModules);
        orderEnumerator.using((RootModelProvider)this.myContext.getModulesProvider()).productionOnly().runtimeOnly().withoutSdk().recursively().forEach(entry -> {
            Library library;
            if (entry instanceof ModuleSourceOrderEntry) {
                Module module11 = entry.getOwnerModule();
                modules.add(module11);
                for (FacetTypeId typeId : JavaeeFacetUtil.getInstance().getAllJavaeeFacetTypes()) {
                    facets.addAll(this.myContext.getFacetsProvider().getFacetsByType(module11, typeId));
                }
            } else if (entry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)entry).getLibrary()) != null && !JavaeeArtifactTypeBase.isStandardJavaeeLibrary(library)) {
                libraries.add(library);
            }
            return true;
        });
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        ArtifactRootElement rootElement = factory.createArtifactRootElement();
        String pathForDirectories = this.myType.getDefaultPathFor(PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES);
        for (Module module : modules) {
            if (pathForDirectories == null || !ProductionModuleOutputElementType.ELEMENT_TYPE.isSuitableModule(this.myContext.getModulesProvider(), module)) continue;
            factory.getOrCreateDirectory((CompositePackagingElement)rootElement, pathForDirectories).addOrFindChild(factory.createModuleOutput(module));
        }
        for (Library library : libraries) {
            String path = this.myType.getDefaultPathFor(LibraryPackagingElement.getKindForLibrary((Library)library));
            if (path == null) continue;
            factory.getOrCreateDirectory((CompositePackagingElement)rootElement, path).addOrFindChildren((Collection)factory.createLibraryElements(library));
        }
        for (JavaeeFacet facet : facets) {
            rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement(facet));
        }
        return rootElement;
    }
}

