/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.tasks.provider.schema.json.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.resource.SchemaLoaders;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\b\u001a\u00020\t2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u0007H\u0002J/\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00140\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/grazie/tasks/provider/schema/json/validation/JsonSchemaReader;", "", "<init>", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "jsonSchema", "Lcom/networknt/schema/JsonSchema;", "readSchema", "Lcom/fasterxml/jackson/databind/JsonNode;", "path", "Ljava/nio/file/Path;", "context", "Ljava/lang/Class;", "", "input", "Ljava/io/InputStream;", "schema", "readBaseSchema", "withPath", "T", "uri", "Ljava/net/URI;", "block", "Lkotlin/Function1;", "(Ljava/net/URI;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "tasks-provider-task-schema"})
@SourceDebugExtension(value={"SMAP\nJsonSchemaReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaReader.kt\nai/grazie/tasks/provider/schema/json/validation/JsonSchemaReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1#2:79\n1187#3,2:80\n1261#3,4:82\n*S KotlinDebug\n*F\n+ 1 JsonSchemaReader.kt\nai/grazie/tasks/provider/schema/json/validation/JsonSchemaReader\n*L\n54#1:80,2\n54#1:82,4\n*E\n"})
public final class JsonSchemaReader {
    @NotNull
    public static final JsonSchemaReader INSTANCE = new JsonSchemaReader();
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    @NotNull
    private static final JsonSchema jsonSchema = INSTANCE.readBaseSchema();

    private JsonSchemaReader() {
    }

    @NotNull
    public final JsonNode readSchema(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.readSchema(PathsKt.readText$default((Path)path, null, (int)1, null));
    }

    @NotNull
    public final JsonNode readSchema(@NotNull Class<?> context2, @NotNull String path) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = context2.getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new IllegalStateException(("missing resource " + path).toString());
        }
        InputStream inputStream2 = inputStream;
        return this.readSchema(inputStream2);
    }

    @NotNull
    public final JsonNode readSchema(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        return this.readSchema(TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset)));
    }

    @NotNull
    public final JsonNode readSchema(@NotNull String schema) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        try {
            jsonNode = mapper.readTree(schema);
        }
        catch (Exception e) {
            throw new IllegalStateException("provided schema is not a JSON node", e);
        }
        JsonNode data2 = jsonNode;
        if (data2.isMissingNode()) {
            throw new IllegalStateException("provided schema is not a JSON node".toString());
        }
        Set set = jsonSchema.validate(data2);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"validate(...)");
        jsonNode = (ValidationMessage)CollectionsKt.firstOrNull((Iterable)set);
        if (jsonNode != null) {
            JsonNode it = jsonNode;
            boolean bl = false;
            String string = it.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            String string2 = "provided schema is not a valid JSON schema - " + StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)"$"), (CharSequence)".");
            throw new IllegalStateException(string2.toString());
        }
        Intrinsics.checkNotNull((Object)data2);
        return data2;
    }

    private final JsonSchema readBaseSchema() {
        Serializable serializable = this.getClass().getClassLoader().getResource("json_schema_202012/schema.json");
        if (serializable == null || (serializable = serializable.toURI()) == null) {
            throw new IllegalStateException("Failed to find JSON schema resource file".toString());
        }
        Serializable mainSchema = serializable;
        Object t = this.withPath((URI)mainSchema, JsonSchemaReader::readBaseSchema$lambda$5);
        Intrinsics.checkNotNullExpressionValue(t, (String)"withPath(...)");
        return (JsonSchema)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withPath(URI uri, Function1<? super Path, ? extends T> block) {
        Object object;
        try {
            Path path = Paths.get(uri);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            object = block.invoke((Object)path);
        }
        catch (FileSystemNotFoundException e) {
            Object object2;
            Closeable closeable = FileSystems.newFileSystem(uri, MapsKt.emptyMap());
            Throwable throwable = null;
            try {
                FileSystem it = (FileSystem)closeable;
                boolean bl = false;
                Path path = Paths.get(uri);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                object2 = block.invoke((Object)path);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = object2;
        }
        return (T)object;
    }

    private static final void readBaseSchema$lambda$5$lambda$4$lambda$3(Map $schemaLib, SchemaLoaders.Builder builder) {
        builder.schemas($schemaLib);
    }

    private static final void readBaseSchema$lambda$5$lambda$4(Map $schemaLib, JsonSchemaFactory.Builder it) {
        it.schemaLoaders(arg_0 -> JsonSchemaReader.readBaseSchema$lambda$5$lambda$4$lambda$3($schemaLib, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonSchema readBaseSchema$lambda$5(Path mainSchemaPath) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mainSchemaPath, (String)"mainSchemaPath");
        Path metaPath = mainSchemaPath.resolveSibling("meta");
        Intrinsics.checkNotNull((Object)metaPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(metaPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-check-JsonSchemaReader$readBaseSchema$1$22 = false;
            String $i$a$-check-JsonSchemaReader$readBaseSchema$1$22 = "Failed to find JSON schema 'meta' folder";
            throw new IllegalStateException($i$a$-check-JsonSchemaReader$readBaseSchema$1$22.toString());
        }
        Iterable $this$associate$iv = PathsKt.listDirectoryEntries$default((Path)metaPath, null, (int)1, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)("meta/" + PathsKt.getName((Path)it)), (Object)PathsKt.readText$default((Path)it, null, (int)1, null));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map schemaLib = destination$iv$iv;
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, arg_0 -> JsonSchemaReader.readBaseSchema$lambda$5$lambda$4(schemaLib, arg_0));
        SchemaValidatorsConfig config = SchemaValidatorsConfig.builder().failFast(true).pathType(PathType.LEGACY).build();
        return factory.getSchema(PathsKt.readText$default((Path)mainSchemaPath, null, (int)1, null), config);
    }
}

