/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.mssql.TsqlDmlHelper;
import com.intellij.database.dialects.mssql.model.MsRoot;
import com.intellij.database.dialects.mssql.model.properties.MsEngineVersion;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0013\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u0014\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J:\u0010\u001a\u001a\u00020\u00162\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010!\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0011\u0010\"\u001a\u0004\u0018\u00010#*\u0004\u0018\u00010$H\u0082\u0010J \u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001eH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/mssql/MsDmlHelper;", "Lcom/intellij/database/dialects/mssql/TsqlDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInsertDefaultValues", "", "getSupportsInsertDefaultValues", "()Z", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/LimitPlace;", "table", "Lcom/intellij/database/model/DasObject;", "hasRowId", "Lcom/intellij/database/model/DasTable;", "version", "Lcom/intellij/database/util/Version;", "isMssql2008", "isDynamics", "isSynapse", "appendRowId", "Lcom/intellij/database/util/DdlBuilder;", "builder", "alias", "", "appendLimit", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "supportsOffset", "findRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "Lcom/intellij/database/model/basic/BasicElement;", "offsetFetch", "rows", "intellij.database.dialects.mssql"})
public final class MsDmlHelper
extends TsqlDmlHelper {
    public MsDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    public boolean getSupportsInsertDefaultValues() {
        return true;
    }

    @Override
    @NotNull
    public LimitPlace getPlaceForLimit(@Nullable DasObject table) {
        return this.supportsOffset(table) ? LimitPlace.END : LimitPlace.BEGIN;
    }

    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        boolean isSynapse = this.isSynapse((DasObject)table);
        boolean isAzureDynamics = this.isDynamics((DasObject)table);
        boolean isMssql2008 = this.isMssql2008(version);
        return !isSynapse && !isAzureDynamics && !isMssql2008;
    }

    private final boolean isMssql2008(Version version) {
        int[] nArray;
        return this.getDbms().eq(Dbms.MSSQL) && version != null && version.less(nArray = new int[]{11, 0});
    }

    private final boolean isDynamics(DasObject table) {
        if (!this.getDbms().eq(Dbms.AZURE)) {
            return false;
        }
        DasObject dasObject = table;
        if (dasObject != null && (dasObject = DasObjectFun.getBasicElement((DasObject)dasObject)) != null && (dasObject = dasObject.getDatabase()) != null && (dasObject = dasObject.getDasParent()) != null) {
            DasObject it = dasObject;
            boolean bl = false;
            if (it instanceof MsRoot) {
                return ((MsRoot)it).getEngineVersion() == MsEngineVersion.DYNAMICS;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSynapse(DasObject table) {
        if (this.getDbms().eq(Dbms.SYNAPSE)) {
            return true;
        }
        if (table == null) return false;
        BasicElement basicElement = DasObjectFun.getBasicElement((DasObject)table);
        if (basicElement == null) return false;
        BasicRoot basicRoot = this.findRoot(basicElement);
        BasicRoot root = basicRoot;
        if (root == null) return false;
        BasicDatabase basicDatabase = root.getCurrentDatabase();
        BasicDatabase basicDatabase2 = basicDatabase;
        if (basicDatabase == null) return false;
        BasicModel basicModel = basicDatabase2.getModel();
        basicDatabase2 = basicModel;
        if (basicModel == null) return false;
        Dbms dbms = basicDatabase2.getDbms();
        basicDatabase2 = dbms;
        if (dbms == null) return false;
        if (!basicDatabase2.eq(Dbms.SYNAPSE)) return false;
        return true;
    }

    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("%%physloc%% as \"%%physloc%%\"");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"literal(...)");
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder appendLimit(@Nullable DasObject table, @NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return GridUtilCore.isPageSizeUnlimited((int)limit) ? builder : (this.supportsOffset(table) ? this.offsetFetch(builder, offset, limit) : this.top(builder, "TOP", limit));
    }

    public boolean supportsOffset(@Nullable DasObject table) {
        BasicRoot basicRoot;
        BasicElement basicElement;
        if (!Registry.Companion.is("sql.dialects.mssql.use.offset.fetch", false)) {
            return false;
        }
        if (this.isDynamics(table)) {
            return false;
        }
        if (this.isSynapse(table)) {
            return false;
        }
        Version version = table != null && (basicElement = DasObjectFun.getBasicElement((DasObject)table)) != null && (basicRoot = this.findRoot(basicElement)) != null ? basicRoot.getServerVersion() : null;
        return version != null && !this.isMssql2008(version);
    }

    private final BasicRoot findRoot(BasicElement $this$findRoot) {
        BasicRoot basicRoot;
        MsDmlHelper msDmlHelper = this;
        while (true) {
            BasicElement basicElement;
            if ((basicElement = $this$findRoot) == null) {
                basicRoot = null;
                break;
            }
            if (basicElement instanceof BasicRoot) {
                basicRoot = (BasicRoot)$this$findRoot;
                break;
            }
            MsDmlHelper msDmlHelper2 = msDmlHelper;
            BasicElement basicElement2 = $this$findRoot.getParent();
            msDmlHelper = msDmlHelper2;
            $this$findRoot = basicElement2;
        }
        return basicRoot;
    }

    private final DdlBuilder offsetFetch(DdlBuilder builder, int offset, int rows) {
        String string = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"ORDER", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"ROWS", "FETCH", "NEXT"};
            DdlBuilder ddlBuilder = builder.newLine().keyword("OFFSET").space().literal(String.valueOf(offset)).space().keywords(stringArray).space().literal(String.valueOf(rows)).space();
            stringArray = new String[]{"ROWS", "ONLY"};
            DdlBuilder ddlBuilder2 = ddlBuilder.keywords(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"keywords(...)");
            return ddlBuilder2;
        }
        String[] stringArray = new String[]{"ORDER", "BY", "(", "SELECT", "NULL", ")"};
        DdlBuilder ddlBuilder = builder.newLine().keywords(stringArray).newLine().keyword("OFFSET").space().literal(String.valueOf(offset)).space();
        stringArray = new String[]{"ROWS", "FETCH", "NEXT"};
        DdlBuilder ddlBuilder3 = ddlBuilder.keywords(stringArray).space().literal(String.valueOf(rows)).space();
        stringArray = new String[]{"ROWS", "ONLY"};
        DdlBuilder ddlBuilder4 = ddlBuilder3.keywords(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder4, (String)"keywords(...)");
        return ddlBuilder4;
    }
}

