/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.dialects.mssql.TsqlErrorHandler;
import com.intellij.database.remote.jdbc.SQLExceptionWithProperties;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsErrorHandler
extends TsqlErrorHandler {
    public MsErrorHandler(@NotNull Dbms dbms) {
        if (dbms == null) {
            MsErrorHandler.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    @NotNull
    protected BaseDatabaseErrorHandler.OffsetInfoBuilder getOffsetInfoBuilder(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            MsErrorHandler.$$$reportNull$$$0(1);
        }
        BaseDatabaseErrorHandler.OffsetInfoBuilder builder = super.getOffsetInfoBuilder(errorInfo);
        Map properties = MsErrorHandler.getProperties((Throwable)errorInfo.getOriginalThrowable());
        if (properties == null) {
            BaseDatabaseErrorHandler.OffsetInfoBuilder offsetInfoBuilder = builder;
            if (offsetInfoBuilder == null) {
                MsErrorHandler.$$$reportNull$$$0(2);
            }
            return offsetInfoBuilder;
        }
        Integer lineNumber = (Integer)SQLExceptionWithProperties.LINE_NUMBER.get(properties);
        BaseDatabaseErrorHandler.OffsetInfoBuilder offsetInfoBuilder = lineNumber == null ? builder : builder.defaultLine(lineNumber.intValue());
        if (offsetInfoBuilder == null) {
            MsErrorHandler.$$$reportNull$$$0(3);
        }
        return offsetInfoBuilder;
    }

    @NotNull
    protected ErrorInfo getErrorInfo(@NotNull Project project, @Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (project == null) {
            MsErrorHandler.$$$reportNull$$$0(4);
        }
        if (original == null) {
            MsErrorHandler.$$$reportNull$$$0(5);
        }
        if (cause == null) {
            MsErrorHandler.$$$reportNull$$$0(6);
        }
        if (MsErrorHandler.getErrorCode((Throwable)cause) == 40852) {
            return new MsSecureServerErrorInfo(dataSource, original, cause, project);
        }
        if (MsErrorHandler.isMsJbDriverErrorInfo(dataSource, original)) {
            if (cause instanceof SQLException) {
                return new MsJbDriverSQLErrorInfo(this, dataSource, original, cause, project);
            }
            return new MsJbDriverUnexpectedErrorInfo(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(project, dataSource, original, cause);
        if (errorInfo == null) {
            MsErrorHandler.$$$reportNull$$$0(7);
        }
        return errorInfo;
    }

    private static boolean isMsJbDriverErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original) {
        if (original == null) {
            MsErrorHandler.$$$reportNull$$$0(8);
        }
        return dataSource != null && MsUtils.isJbMsDriver(dataSource.getDatabaseDriver()) && ExceptionUtil.getThrowableText((Throwable)original).contains("com.jetbrains.jdbc");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsErrorHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsErrorHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsetInfoBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInfoBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMsJbDriverErrorInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7 -> new IllegalStateException(string);
        };
    }

    private static class MsSecureServerErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        MsSecureServerErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull Project project) {
            if (original == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(2);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(3);
            }
            if (fixes == null) {
                MsSecureServerErrorInfo.$$$reportNull$$$0(4);
            }
            MsSecureServerErrorInfo.appendGenericMessage((Throwable)this.myOriginal, (StringBuilder)sb);
            LocalDataSource dataSource = this.getDataSource();
            String url = dataSource == null ? null : dataSource.getUrl();
            String orig = "database.windows.net";
            String repl = "secure.database.windows.net";
            if (url != null && url.contains(orig)) {
                MsSecureServerErrorInfo.addFix(fixes, fac -> fac.setUrl(dataSource, DatabaseBundle.message((String)"switch.to.secure.database.windows.net", (Object[])new Object[0]), url.replace(orig, repl)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mssql/MsErrorHandler$MsSecureServerErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MsJbDriverSQLErrorInfo
    extends BaseDatabaseErrorHandler.SQLErrorInfo {
        MsJbDriverSQLErrorInfo(@Nullable MsErrorHandler msErrorHandler, @NotNull LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, Project project) {
            if (original == null) {
                MsJbDriverSQLErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MsJbDriverSQLErrorInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MsJbDriverSQLErrorInfo.$$$reportNull$$$0(2);
            }
            super((BaseDatabaseErrorHandler)msErrorHandler, project, dataSource, original, cause);
        }

        protected void logIfNeeded() {
            this.LOG.info(this.myOriginal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "original";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/mssql/MsErrorHandler$MsJbDriverSQLErrorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MsJbDriverUnexpectedErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        MsJbDriverUnexpectedErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                MsJbDriverUnexpectedErrorInfo.$$$reportNull$$$0(3);
            }
            MsJbDriverUnexpectedErrorInfo.appendGenericMessage((Throwable)this.myOriginal, (StringBuilder)sb);
        }

        protected void logIfNeeded() {
            this.LOG.error(this.myOriginal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mssql/MsErrorHandler$MsJbDriverUnexpectedErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

