/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.uml.java.project.ModuleItem;
import com.intellij.uml.java.project.ModulesUmlNode;
import com.intellij.uml.java.project.actions.ModuleNodeIntentionActionBase;
import com.intellij.uml.java.project.ui.ModulesListCellRenderer;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.util.Consumer;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ShowPathsToModuleAction
extends ModuleNodeIntentionActionBase {
    public ShowPathsToModuleAction() {
        super(DiagramJavaBundle.message("show.paths.to.a.module", new Object[0]), null, null);
    }

    public void perform(DiagramNode<ModuleItem> n, DiagramBuilder builder) {
        final ModulesUmlNode node = (ModulesUmlNode)n;
        Project project = builder.getProject();
        Module module = ((ModuleItem)n.getIdentifyingElement()).getModule();
        ArrayList<Module> modules = new ArrayList<Module>(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
        modules.remove(module);
        Consumer callback = targetModule -> {
            Task.Backgroundable task = new Task.Backgroundable(builder.getProject(), DiagramJavaBundle.message("task.title.calculating.paths.between.modules", new Object[0]), true, (Module)targetModule, builder, project){
                private ProgressIndicator myIndicator;
                final /* synthetic */ Module val$targetModule;
                final /* synthetic */ DiagramBuilder val$builder;
                final /* synthetic */ Project val$project;
                {
                    this.val$targetModule = module;
                    this.val$builder = diagramBuilder;
                    this.val$project = project;
                    super(arg0, arg1, arg2);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.myIndicator = indicator;
                    this.showPathFor(node, new ModuleItem(this.val$targetModule), this.val$builder);
                }

                private void showPathFor(ModulesUmlNode node1, ModuleItem item, DiagramBuilder builder1) {
                    if (item.isModule()) {
                        Module moduleFrom = node1.getIdentifyingElement().getModule();
                        Module moduleTo = item.getModule();
                        Graph<Module> moduleGraph = ModuleNodeIntentionActionBase.buildModulesGraph(builder1, this.val$project);
                        GraphAlgorithms graphAlgorithms = GraphAlgorithms.getInstance();
                        List shortestPaths = graphAlgorithms.findKShortestPaths(moduleGraph, (Object)moduleFrom, (Object)moduleTo, 5, this.myIndicator);
                        List paths = graphAlgorithms.removePathsWithCycles(shortestPaths);
                        if (this.myIndicator.isCanceled()) {
                            return;
                        }
                        if (paths.isEmpty()) {
                            ApplicationManager.getApplication().invokeLater(() -> DiagramAction.showNotification((String)DiagramJavaBundle.message("notification.message.no.paths.to.module.0.have.been.found", moduleTo.getName()), (DiagramNode)node1, (DiagramBuilder)builder1));
                        } else {
                            ShowPathsToModuleAction.this.showPaths(builder1, paths);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/uml/java/project/actions/ShowPathsToModuleAction$1", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task);
        };
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(modules).setTitle(DiagramJavaBundle.message("popup.title.select.target.module", new Object[0])).setNamerForFiltering(Module::getName).setSelectionMode(0).setRenderer((ListCellRenderer)new ModulesListCellRenderer()).setAutoselectOnMouseMove(true).setItemChosenCallback(callback).createPopup();
        GraphCanvasLocationService.getInstance().showPopupBeneathNode(popup, builder.getGraphBuilder(), Objects.requireNonNull(builder.getNode((DiagramNode)node)));
    }
}

