/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.ui;

import com.intellij.jam.JavaJamBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.ui.EnableDisableAction;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectElementsDialog
extends DialogWrapper {
    private final TableView<PsiElement> myTable;
    private final Set<PsiElement> mySelectedElements = new HashSet<PsiElement>();

    public SelectElementsDialog(Project project, List<PsiElement> elements, @NlsContexts.DialogTitle String title, @NlsContexts.ColumnName String elementsTitle) {
        super(project, true);
        ColumnInfo<?, ?>[] columnInfos = this.createColumnInfos();
        columnInfos[1].setName(elementsTitle);
        this.myTable = new TableView(new ListTableModel(columnInfos));
        this.myTable.setTableHeader(null);
        final ListTableModel model = this.myTable.getListTableModel();
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>(elements);
        arrayList.sort((o1, o2) -> {
            int filesResult = Comparing.compare((Comparable)((Object)o1.getContainingFile().getName()), (Comparable)((Object)o2.getContainingFile().getName()));
            if (filesResult != 0) {
                return filesResult;
            }
            return SelectElementsDialog.getPresentableText(o1).compareTo(SelectElementsDialog.getPresentableText(o2));
        });
        model.setItems(arrayList);
        model.setSortable(false);
        TableSpeedSearch.installOn(this.myTable);
        new EnableDisableAction(){

            protected JTable getTable() {
                return SelectElementsDialog.this.myTable;
            }

            protected boolean isRowChecked(int row) {
                return SelectElementsDialog.this.mySelectedElements.contains(model.getItems().get(row));
            }

            protected void applyValue(int[] rows, boolean valueToBeSet) {
                for (int row : rows) {
                    if (valueToBeSet) {
                        SelectElementsDialog.this.mySelectedElements.add((PsiElement)model.getItems().get(row));
                        continue;
                    }
                    SelectElementsDialog.this.mySelectedElements.remove(model.getItems().get(row));
                }
                int[] selection = SelectElementsDialog.this.myTable.getSelectedRows();
                model.fireTableDataChanged();
                TableUtil.selectRows(SelectElementsDialog.this.myTable, (int[])selection);
                SelectElementsDialog.this.onSelectionChanged();
            }
        }.register();
        this.setTitle(title);
        this.init();
        this.onSelectionChanged();
    }

    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.myTable.getComponent());
    }

    public Collection<PsiElement> getSelectedItems() {
        return this.mySelectedElements;
    }

    protected void onSelectionChanged() {
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    private static String getPresentableText(PsiElement psiElement) {
        NavigationItem navigationItem;
        ItemPresentation presentation;
        if (psiElement instanceof PsiFile) {
            return ((PsiFile)psiElement).getName();
        }
        if (psiElement instanceof PsiClass) {
            return PsiFormatUtil.formatClass((PsiClass)((PsiClass)psiElement), (int)2049);
        }
        if (psiElement instanceof PsiMethod) {
            return PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)psiElement), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)0);
        }
        if (psiElement instanceof PsiField) {
            return PsiFormatUtil.formatVariable((PsiVariable)((PsiField)psiElement), (int)4099, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        if (psiElement instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)psiElement;
            return xmlTag.getContainingFile().getName() + ": <" + xmlTag.getName() + ">";
        }
        if (psiElement instanceof PsiAnnotation) {
            PsiAnnotation annotation = (PsiAnnotation)psiElement;
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class, (boolean)true);
            if (member != null) {
                return SelectElementsDialog.getPresentableText((PsiElement)member) + ": @" + annotation.getQualifiedName();
            }
            return annotation.getContainingFile().getName() + ": @" + annotation.getQualifiedName();
        }
        if (psiElement instanceof NavigationItem && (presentation = (navigationItem = (NavigationItem)psiElement).getPresentation()) != null) {
            return StringUtil.notNullize((String)presentation.getPresentableText(), (String)JavaJamBundle.message((String)"unnamed.element.presentable.name", (Object[])new Object[0]));
        }
        return psiElement.toString();
    }

    private ColumnInfo<?, ?>[] createColumnInfos() {
        final DefaultCellEditor editor = new DefaultCellEditor(new JCheckBox());
        editor.setClickCountToStart(1);
        final BooleanTableCellRenderer renderer = new BooleanTableCellRenderer();
        return new ColumnInfo[]{new ColumnInfo<PsiElement, Boolean>(""){

            public Boolean valueOf(PsiElement psiElement) {
                return SelectElementsDialog.this.mySelectedElements.contains(psiElement);
            }

            public boolean isCellEditable(PsiElement psiElement) {
                return true;
            }

            public Class<?> getColumnClass() {
                return Boolean.TYPE;
            }

            public TableCellRenderer getRenderer(PsiElement psiElement) {
                return renderer;
            }

            public int getWidth(JTable table) {
                return new JCheckBox().getPreferredSize().width + 2;
            }

            public TableCellEditor getEditor(PsiElement psiElement) {
                return editor;
            }

            public void setValue(PsiElement psiElement, Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    SelectElementsDialog.this.mySelectedElements.add(psiElement);
                } else {
                    SelectElementsDialog.this.mySelectedElements.remove(psiElement);
                }
                SelectElementsDialog.this.onSelectionChanged();
            }
        }, new ColumnInfo<PsiElement, String>(this, ""){

            public String valueOf(PsiElement psiElement) {
                return SelectElementsDialog.getPresentableText(psiElement);
            }

            public TableCellRenderer getRenderer(final PsiElement psiElement) {
                return new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                        if (table == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        if (!psiElement.isPhysical()) {
                            this.append("  [" + JavaJamBundle.message((String)"postfix.not.physical.element", (Object[])new Object[0]) + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                        }
                        this.setIcon(psiElement.getIcon(0));
                        this.setOpaque(false);
                        this.setIconOpaque(false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/jam/view/ui/SelectElementsDialog$3$1", "customizeCellRenderer"));
                    }
                };
            }
        }};
    }
}

