/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.ExecutionException;
import com.intellij.idea.AppMode;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.lang.javascript.psi.util.JSPluginPathManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class KarmaJsSourcesLocator {
    private static final KarmaJsSourcesLocator INSTANCE = new KarmaJsSourcesLocator();
    private static final String KARMA_INTELLIJ_NAME = "karma-intellij";
    private static final String JS_REPORTER_NAME = "js_reporter";
    private final Path myKarmaIntellijPackageDir = KarmaJsSourcesLocator.findKarmaIntellijPackageDir();

    private KarmaJsSourcesLocator() {
    }

    @NotNull
    public static KarmaJsSourcesLocator getInstance() {
        KarmaJsSourcesLocator karmaJsSourcesLocator = INSTANCE;
        if (karmaJsSourcesLocator == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(0);
        }
        return karmaJsSourcesLocator;
    }

    @NotNull
    private static Path findKarmaIntellijPackageDir() {
        Path jsReporterDir = KarmaJsSourcesLocator.getBundledJsReporterDir();
        if (Files.isDirectory(jsReporterDir, new LinkOption[0])) {
            Path path = jsReporterDir.resolve(KARMA_INTELLIJ_NAME);
            if (path == null) {
                KarmaJsSourcesLocator.$$$reportNull$$$0(1);
            }
            return path;
        }
        throw new RuntimeException("Cannot find bundled karma-intellij in " + String.valueOf(jsReporterDir));
    }

    @NotNull
    private static Path getBundledJsReporterDir() {
        Path path;
        String relativePathToResources = AppMode.isRunningFromDevBuild() ? "karma" : "js-karma/resources";
        try {
            path = JSPluginPathManager.getPluginResource(KarmaJsSourcesLocator.class, (String)JS_REPORTER_NAME, (String)relativePathToResources);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find bundled karma-intellij in " + relativePathToResources);
        }
        if (path == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(2);
        }
        return path;
    }

    @NotNull
    private Path getAppFile(@NotNull String baseName) throws IOException {
        Path file;
        if (baseName == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(3);
        }
        if (!Files.isRegularFile(file = this.myKarmaIntellijPackageDir.resolve("lib").resolve(baseName), new LinkOption[0])) {
            throw new IOException("Cannot locate " + String.valueOf(file));
        }
        Path path = file;
        if (path == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(4);
        }
        return path;
    }

    @NotNull
    public Path getIntellijConfigFile() throws IOException {
        return this.getAppFile("intellij.conf.js");
    }

    @NotNull
    public Path getClientAppFile() throws ExecutionException {
        try {
            return this.getAppFile("intellijRunner.js");
        }
        catch (IOException e) {
            throw new ExecutionException(KarmaBundle.message("execution.cannot_find_intellijRunner.dialog.message", new Object[0]), (Throwable)e);
        }
    }

    @NotNull
    public Path getKarmaIntellijPackageDir() {
        Path path = this.myKarmaIntellijPackageDir;
        if (path == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(5);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaJsSourcesLocator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findKarmaIntellijPackageDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledJsReporterDir";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaJsSourcesLocator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKarmaIntellijPackageDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAppFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

