/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalDurationFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.temporal.TemporalUnbalanceDateDurationRelativeNode;
import com.oracle.truffle.js.nodes.temporal.ToRelativeTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalDurationFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalDurationFunction> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalDurationFunctionBuiltins();

    protected TemporalDurationFunctionBuiltins() {
        super(JSTemporalDuration.CLASS_NAME, TemporalDurationFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalDurationFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalDurationFunctionBuiltinsFactory.JSTemporalDurationFromNodeGen.create(context, builtin, TemporalDurationFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return TemporalDurationFunctionBuiltinsFactory.JSTemporalDurationCompareNodeGen.create(context, builtin, TemporalDurationFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalDurationFunction implements BuiltinEnum<TemporalDurationFunction>
    {
        from(1),
        compare(2);

        private final int length;

        private TemporalDurationFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSTemporalDurationFrom
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationFrom(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject from(Object item, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch) {
            if (this.isObject(item) && JSTemporalDuration.isJSTemporalDuration(item)) {
                JSTemporalDurationObject duration = (JSTemporalDurationObject)item;
                return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), this, errorBranch);
            }
            return toTemporalDurationNode.execute(item);
        }
    }

    public static abstract class JSTemporalDurationCompare
    extends JSTemporalBuiltinOperation {
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalDurationCompare(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getMethodDateAddNode = GetMethodNode.create(context, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected int compare(Object oneParam, Object twoParam, Object optionsParam, @Cached ToRelativeTemporalObjectNode toRelativeTemporalObjectNode, @Cached TemporalUnbalanceDateDurationRelativeNode unbalanceDurationRelativeNode, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            double days2;
            double days1;
            boolean calendarUnitsPresent;
            JSTemporalDurationObject one = toTemporalDurationNode.execute(oneParam);
            JSTemporalDurationObject two = toTemporalDurationNode.execute(twoParam);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSRealm realm = this.getRealm();
            ToRelativeTemporalObjectNode.Result relativeToRec = toRelativeTemporalObjectNode.execute(options);
            JSTemporalZonedDateTimeObject zonedRelativeTo = relativeToRec.zonedRelativeTo();
            JSTemporalPlainDateObject plainRelativeTo = relativeToRec.plainRelativeTo();
            TimeZoneMethodsRecord timeZoneRec = relativeToRec.timeZoneRec();
            CalendarMethodsRecord calendarRec = relativeToRec.createCalendarMethodsRecord(this.getMethodDateAddNode, this.getMethodDateUntilNode);
            boolean bl = calendarUnitsPresent = one.getYears() != 0.0 || two.getYears() != 0.0 || one.getMonths() != 0.0 || two.getMonths() != 0.0 || one.getWeeks() != 0.0 || two.getWeeks() != 0.0;
            if (zonedRelativeTo != null && (calendarUnitsPresent || one.getDays() != 0.0 || two.getDays() != 0.0)) {
                JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedRelativeTo.getNanoseconds());
                JSTemporalPlainDateTimeObject precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendarRec.receiver());
                BigInt after1 = TemporalUtil.addZonedDateTime(this.getContext(), realm, zonedRelativeTo.getNanoseconds(), timeZoneRec, calendarRec, TemporalUtil.dtol(one.getYears()), TemporalUtil.dtol(one.getMonths()), TemporalUtil.dtol(one.getWeeks()), TemporalUtil.dtol(one.getDays()), TemporalUtil.dtol(one.getHours()), TemporalUtil.dtol(one.getMinutes()), TemporalUtil.dtol(one.getSeconds()), TemporalUtil.dtol(one.getMilliseconds()), TemporalUtil.dtol(one.getMicroseconds()), TemporalUtil.dtol(one.getNanoseconds()), precalculatedPlainDateTime);
                BigInt after2 = TemporalUtil.addZonedDateTime(this.getContext(), realm, zonedRelativeTo.getNanoseconds(), timeZoneRec, calendarRec, TemporalUtil.dtol(two.getYears()), TemporalUtil.dtol(two.getMonths()), TemporalUtil.dtol(two.getWeeks()), TemporalUtil.dtol(two.getDays()), TemporalUtil.dtol(two.getHours()), TemporalUtil.dtol(two.getMinutes()), TemporalUtil.dtol(two.getSeconds()), TemporalUtil.dtol(two.getMilliseconds()), TemporalUtil.dtol(two.getMicroseconds()), TemporalUtil.dtol(two.getNanoseconds()), precalculatedPlainDateTime);
                return after1.compareTo(after2);
            }
            if (calendarUnitsPresent) {
                JSTemporalDurationRecord balanceResult1 = unbalanceDurationRelativeNode.execute(one.getYears(), one.getMonths(), one.getWeeks(), one.getDays(), TemporalUtil.Unit.DAY, plainRelativeTo, calendarRec);
                JSTemporalDurationRecord balanceResult2 = unbalanceDurationRelativeNode.execute(two.getYears(), two.getMonths(), two.getWeeks(), two.getDays(), TemporalUtil.Unit.DAY, plainRelativeTo, calendarRec);
                days1 = balanceResult1.getDays();
                days2 = balanceResult2.getDays();
            } else {
                days1 = one.getDays();
                days2 = two.getDays();
            }
            BigInt ns1 = TemporalUtil.totalDurationNanoseconds(days1, one.getHours(), one.getMinutes(), one.getSeconds(), one.getMilliseconds(), one.getMicroseconds(), one.getNanoseconds());
            BigInt ns2 = TemporalUtil.totalDurationNanoseconds(days2, two.getHours(), two.getMinutes(), two.getSeconds(), two.getMilliseconds(), two.getMicroseconds(), two.getNanoseconds());
            return ns1.compareTo(ns2);
        }
    }
}

