/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Properties;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ImportStatic(value={Strings.class})
@GenerateUncached
public abstract class KeyInfoNode
extends JavaScriptBaseNode {
    public static final int READABLE = 1;
    public static final int MODIFIABLE = 2;
    public static final int INSERTABLE = 4;
    public static final int INVOCABLE = 8;
    public static final int REMOVABLE = 16;
    public static final int READ_SIDE_EFFECTS = 32;
    public static final int WRITE_SIDE_EFFECTS = 64;
    public static final int WRITABLE = 6;

    KeyInfoNode() {
    }

    public abstract boolean execute(JSDynamicObject var1, String var2, int var3);

    @Specialization(guards={"!isJSProxy(target)", "property != null"}, limit="2")
    static boolean cachedOwnProperty(JSDynamicObject target, String key, int query, @Bind(value="this") Node node, @CachedLibrary(value="target") DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared(value="fromJavaString") TruffleString.FromJavaStringNode fromJavaStringNode, @Bind(value="fromJavaString(fromJavaStringNode, key)") TruffleString tStringKey, @Bind(value="objectLibrary.getProperty(target, tStringKey)") Property property, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @Cached InlinedBranchProfile proxyBranch, @Cached InlinedBranchProfile moduleNamespaceBranch) {
        if (JSProperty.isAccessor(property)) {
            Accessor accessor = (Accessor)Properties.getOrDefault(objectLibrary, target, tStringKey, null);
            if ((query & 1) != 0 && accessor.hasGetter()) {
                return true;
            }
            if ((query & 2) != 0 && accessor.hasSetter()) {
                return true;
            }
            if ((query & 0x20) != 0 && accessor.hasGetter()) {
                return true;
            }
            if ((query & 0x40) != 0 && accessor.hasSetter()) {
                return true;
            }
            return (query & 0x10) != 0 && JSProperty.isConfigurable(property);
        }
        assert (JSProperty.isData(property));
        if ((query & 1) != 0) {
            return true;
        }
        if ((query & 2) != 0 && JSProperty.isWritable(property)) {
            return true;
        }
        if ((query & 8) != 0) {
            Object value = Properties.getOrDefault(objectLibrary, target, tStringKey, Undefined.instance);
            if (JSProperty.isDataSpecial(property)) {
                if (JSProperty.isProxy(property)) {
                    proxyBranch.enter(node);
                    value = ((PropertyProxy)value).get(target);
                } else {
                    assert (JSProperty.isModuleNamespaceExport(property)) : property;
                    moduleNamespaceBranch.enter(node);
                    value = JSModuleNamespace.getBindingValue((ExportResolution)value);
                }
            }
            if (isCallable.executeBoolean(value)) {
                return true;
            }
        }
        return (query & 0x10) != 0 && JSProperty.isConfigurable(property);
    }

    @Specialization(replaces={"cachedOwnProperty"})
    static boolean member(JSDynamicObject target, String key, int query, @Cached GetPrototypeNode getPrototype, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @Cached IsExtensibleNode isExtensible, @Cached @Cached.Shared(value="fromJavaString") TruffleString.FromJavaStringNode fromJavaStringNode) {
        boolean writeSideEffects;
        TruffleString tStringKey = Strings.fromJavaString(fromJavaStringNode, key);
        PropertyDescriptor desc = null;
        boolean isProxy = false;
        JSDynamicObject proto = target;
        while (proto != Null.instance) {
            desc = JSObject.getOwnProperty(proto, tStringKey);
            if (JSProxy.isJSProxy(proto)) {
                isProxy = true;
                break;
            }
            if (desc != null) break;
            proto = getPrototype.execute(proto);
        }
        if (desc == null) {
            return (query & 4) != 0 && isExtensible.executeBoolean(target);
        }
        boolean hasGet = desc.hasGet() && desc.getGet() != Undefined.instance;
        boolean hasSet = desc.hasSet() && desc.getSet() != Undefined.instance;
        boolean readable = hasGet || !hasSet;
        boolean writable = hasSet || !hasGet && desc.getIfHasWritable(true);
        boolean readSideEffects = isProxy || hasGet;
        boolean bl = writeSideEffects = isProxy || hasSet;
        if ((query & 1) != 0 && readable) {
            return true;
        }
        if ((query & 2) != 0 && writable) {
            return true;
        }
        if ((query & 0x20) != 0 && readSideEffects) {
            return true;
        }
        if ((query & 0x40) != 0 && writeSideEffects) {
            return true;
        }
        if ((query & 8) != 0 && desc.isDataDescriptor() && isCallable.executeBoolean(desc.getValue())) {
            return true;
        }
        return (query & 0x10) != 0 && desc.getConfigurable();
    }
}

