/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalMonthDayNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getMonthNode;
    @Node.Child
    private PropertyGetNode getMonthCodeNode;
    @Node.Child
    private PropertyGetNode getYearNode;
    @Node.Child
    private PropertyGetNode getCalendarNode;

    protected ToTemporalMonthDayNode() {
    }

    public abstract JSTemporalPlainMonthDayObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalPlainMonthDayObject toTemporalMonthDay(Object item, JSDynamicObject options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile setReferenceYear, @Cached InlinedConditionProfile returnPlainMonthDay, @Cached InlinedConditionProfile getCalendarPath, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached TemporalGetOptionNode temporalGetOptionNode, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
        int referenceISOYear = 1972;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)item;
            if (JSTemporalPlainMonthDay.isJSTemporalPlainMonthDay(itemObj)) {
                return (JSTemporalPlainMonthDayObject)itemObj;
            }
            JSDynamicObject calendar = null;
            boolean calendarAbsent = false;
            if (getCalendarPath.profile(this, JSTemporalPlainDate.isJSTemporalPlainDate(itemObj) || JSTemporalPlainDateTime.isJSTemporalPlainDateTime(itemObj) || JSTemporalPlainTime.isJSTemporalPlainTime(itemObj) || JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth(itemObj) || TemporalUtil.isTemporalZonedDateTime(itemObj))) {
                calendar = ((JSTemporalCalendarHolder)itemObj).getCalendar();
                calendarAbsent = false;
            } else {
                Object calendarObj = this.getCalendar(itemObj);
                calendarAbsent = calendarObj == Undefined.instance;
                calendar = toTemporalCalendarWithISODefaultNode.execute(calendarObj);
            }
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDMMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, itemObj, fieldNames, TemporalUtil.listEmpty);
            if (this.getMonthNode == null || this.getMonthCodeNode == null || this.getYearNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getMonthNode = this.insert(PropertyGetNode.create(TemporalConstants.MONTH, ctx));
                this.getMonthCodeNode = this.insert(PropertyGetNode.create(TemporalConstants.MONTH_CODE, ctx));
                this.getYearNode = this.insert(PropertyGetNode.create(TemporalConstants.YEAR, ctx));
            }
            Object month = this.getMonthNode.getValue(fields);
            Object monthCode = this.getMonthCodeNode.getValue(fields);
            Object year = this.getYearNode.getValue(fields);
            if (setReferenceYear.profile(this, calendarAbsent && month != Undefined.instance && monthCode == Undefined.instance && year == Undefined.instance)) {
                TemporalUtil.createDataPropertyOrThrow(ctx, fields, TemporalConstants.YEAR, referenceISOYear);
            }
            return monthDayFromFieldsNode.execute(calendar, fields, options);
        }
        TemporalUtil.toTemporalOverflow(options, temporalGetOptionNode);
        TruffleString string = toStringNode.executeString(item);
        JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalMonthDayString(string);
        JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(result.getCalendar());
        if (returnPlainMonthDay.profile(this, result.getYear() == Integer.MIN_VALUE)) {
            return JSTemporalPlainMonthDay.create(ctx, realm, result.getMonth(), result.getDay(), calendar, referenceISOYear, this, errorBranch);
        }
        JSTemporalPlainMonthDayObject result2 = JSTemporalPlainMonthDay.create(ctx, realm, result.getMonth(), result.getDay(), calendar, referenceISOYear, this, errorBranch);
        return monthDayFromFieldsNode.execute(calendar, result2, Undefined.instance);
    }

    private Object getCalendar(JSDynamicObject obj) {
        if (this.getCalendarNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarNode = this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, this.getLanguage().getJSContext()));
        }
        return this.getCalendarNode.getValue(obj);
    }
}

