/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleImportsBaseUI;
import com.intellij.application.options.CodeStyleImportsPanelBase;
import com.intellij.application.options.FullyQualifiedNamesInJavadocOptionProvider;
import com.intellij.application.options.JavaCodeStyleImportsUI;
import com.intellij.java.frontback.impl.JavaFrontbackBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaCodeStyleImportsPanel
extends CodeStyleImportsPanelBase {
    private FullyQualifiedNamesInJavadocOptionProvider myFqnInJavadocOption;
    @Nullable
    private JCheckBox myCbPreserveModuleImports;
    @Nullable
    private JCheckBox myCbDeleteUnusedModuleImports;
    private ListTableModel<InnerClassItem> doNotInsertInnerListModel;
    private static final ColumnInfo<?, ?>[] INNER_CLASS_COLUMNS = new ColumnInfo[]{new MyColumnInfo(JavaFrontbackBundle.message("do.not.import.inner.classes.for", new Object[0])){

        public String valueOf(InnerClassItem innerClass) {
            return innerClass.getName();
        }

        public void setValue(InnerClassItem innerClass, String name) {
            innerClass.setName(name);
        }
    }};
    private TableView<InnerClassItem> mydoNotInsertInnerTable;

    JavaCodeStyleImportsPanel() {
    }

    @Override
    protected CodeStyleImportsBaseUI createKotlinUI(JComponent packages, JComponent importLayout) {
        this.createDoNotImportInnerList();
        this.myCbPreserveModuleImports = new JBCheckBox(JavaFrontbackBundle.message("checkbox.no.separate.module.import", new Object[0]));
        this.myCbDeleteUnusedModuleImports = new JBCheckBox(JavaFrontbackBundle.message("checkbox.delete.unused.module.import", new Object[0]));
        this.myFqnInJavadocOption = new FullyQualifiedNamesInJavadocOptionProvider();
        JavaCodeStyleImportsUI result = new JavaCodeStyleImportsUI(packages, importLayout, this.mydoNotInsertInnerTable, this.myCbPreserveModuleImports, this.myCbDeleteUnusedModuleImports, this.myFqnInJavadocOption.getPanel());
        result.init();
        return result;
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        JCheckBox cbDeleteUnusedModuleImports;
        JavaCodeStyleSettings javaSettings = JavaCodeStyleImportsPanel.getJavaSettings(settings);
        this.applyLayoutSettings(javaSettings);
        this.myFqnInJavadocOption.apply(settings);
        JCheckBox cbPreserveModuleImports = this.myCbPreserveModuleImports;
        if (cbPreserveModuleImports != null) {
            javaSettings.setPreserveModuleImports(cbPreserveModuleImports.isSelected());
        }
        if ((cbDeleteUnusedModuleImports = this.myCbDeleteUnusedModuleImports) != null) {
            javaSettings.setDeleteUnusedModuleImports(cbDeleteUnusedModuleImports.isSelected());
        }
        javaSettings.setDoNotImportInner(this.getInnerClassesNames());
        javaSettings.setLayoutOnDemandImportFromSamePackageFirst(this.myImportLayoutPanel.isLayoutOnDemandImportsFromSamePackageFirst());
    }

    @Override
    public void reset(CodeStyleSettings settings) {
        JBCheckBox cbLayoutOnDemandImportsFromSamePackageFirst;
        JCheckBox cbDeleteUnusedModuleImports;
        JavaCodeStyleSettings javaSettings = JavaCodeStyleImportsPanel.getJavaSettings(settings);
        this.resetLayoutSettings(javaSettings);
        this.myFqnInJavadocOption.reset(settings);
        for (String name : javaSettings.getDoNotImportInner()) {
            this.doNotInsertInnerListModel.addRow((Object)new InnerClassItem(name));
        }
        JCheckBox cbPreserveModuleImports = this.myCbPreserveModuleImports;
        if (cbPreserveModuleImports != null) {
            cbPreserveModuleImports.setSelected(javaSettings.isPreserveModuleImports());
        }
        if ((cbDeleteUnusedModuleImports = this.myCbDeleteUnusedModuleImports) != null) {
            cbDeleteUnusedModuleImports.setSelected(javaSettings.isDeleteUnusedModuleImports());
        }
        if ((cbLayoutOnDemandImportsFromSamePackageFirst = this.myImportLayoutPanel.getCbLayoutOnDemandImportsFromSamePackageFirst()) != null) {
            cbLayoutOnDemandImportsFromSamePackageFirst.setSelected(javaSettings.isLayoutOnDemandImportFromSamePackageFirst());
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        JBCheckBox cbLayoutOnDemandImportsFromSamePackageFirst;
        JCheckBox cbDeleteUnusedModuleImports;
        JavaCodeStyleSettings javaSettings = JavaCodeStyleImportsPanel.getJavaSettings(settings);
        boolean isModified = this.isModifiedLayoutSettings(javaSettings);
        isModified |= this.myFqnInJavadocOption.isModified(settings);
        isModified |= !javaSettings.getDoNotImportInner().equals(this.getInnerClassesNames());
        JCheckBox cbPreserveModuleImports = this.myCbPreserveModuleImports;
        if (cbPreserveModuleImports != null) {
            isModified |= JavaCodeStyleImportsPanel.isModified(cbPreserveModuleImports, javaSettings.isPreserveModuleImports());
        }
        if ((cbDeleteUnusedModuleImports = this.myCbDeleteUnusedModuleImports) != null) {
            isModified |= JavaCodeStyleImportsPanel.isModified(cbDeleteUnusedModuleImports, javaSettings.isDeleteUnusedModuleImports());
        }
        if ((cbLayoutOnDemandImportsFromSamePackageFirst = this.myImportLayoutPanel.getCbLayoutOnDemandImportsFromSamePackageFirst()) != null) {
            isModified |= JavaCodeStyleImportsPanel.isModified((JCheckBox)cbLayoutOnDemandImportsFromSamePackageFirst, javaSettings.isLayoutOnDemandImportFromSamePackageFirst());
        }
        return isModified;
    }

    private static JavaCodeStyleSettings getJavaSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JavaCodeStyleImportsPanel.$$$reportNull$$$0(0);
        }
        return (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
    }

    private void createDoNotImportInnerList() {
        this.doNotInsertInnerListModel = new ListTableModel(INNER_CLASS_COLUMNS);
        this.mydoNotInsertInnerTable = new TableView(this.doNotInsertInnerListModel);
        this.mydoNotInsertInnerTable.setShowGrid(false);
        this.mydoNotInsertInnerTable.getEmptyText().setText(JavaFrontbackBundle.message("do.not.import.inner.classes.no.classes", new Object[0]));
    }

    private List<String> getInnerClassesNames() {
        ArrayList<String> items = new ArrayList<String>();
        for (InnerClassItem item : this.doNotInsertInnerListModel.getItems()) {
            String name = item.getName().trim();
            if (name.isEmpty()) continue;
            items.add(name);
        }
        return items;
    }

    @Override
    protected boolean isShowLayoutOnDemandImportFromSamePackageFirstCheckbox() {
        return true;
    }

    @Override
    protected boolean isSupportModule() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/JavaCodeStyleImportsPanel", "getJavaSettings"));
    }

    static class InnerClassItem {
        private String myName;

        InnerClassItem(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }
    }

    private static abstract class MyColumnInfo
    extends ColumnInfo<InnerClassItem, String> {
        MyColumnInfo(@NlsContexts.ColumnName String name) {
            super(name);
        }

        public TableCellEditor getEditor(InnerClassItem item) {
            JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createLineBorder((Color)JBColor.BLACK));
            return new DefaultCellEditor(textField);
        }

        public boolean isCellEditable(InnerClassItem innerClass) {
            return true;
        }
    }
}

