/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.ASTNodeEnterProcessor;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainEnterProcessor
implements ASTNodeEnterProcessor {
    @Override
    public boolean doEnter(@NotNull Editor editor, @NotNull ASTNode astNode, boolean isModified) {
        if (editor == null) {
            PlainEnterProcessor.$$$reportNull$$$0(0);
        }
        if (astNode == null) {
            PlainEnterProcessor.$$$reportNull$$$0(1);
        }
        if (PlainEnterProcessor.expandCodeBlock(editor, astNode)) {
            return true;
        }
        PlainEnterProcessor.getEnterHandler("EditorStartNewLine").execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
        return true;
    }

    public static boolean expandCodeBlock(@NotNull Editor editor, @Nullable ASTNode astNode) {
        ASTNode block;
        PsiElement psiBlock;
        if (editor == null) {
            PlainEnterProcessor.$$$reportNull$$$0(2);
        }
        if (PlainEnterProcessor.processExistingBlankLine(editor, psiBlock = BasicJavaAstTreeUtil.toPsi(block = PlainEnterProcessor.getControlStatementBlock(editor.getCaretModel().getOffset(), astNode)), astNode)) {
            return true;
        }
        if (block == null) {
            return false;
        }
        EditorActionHandler enterHandler = PlainEnterProcessor.getEnterHandler("EditorStartNewLine");
        ASTNode firstElement = BasicJavaAstTreeUtil.getFirstBodyElement(block);
        if (firstElement == null) {
            firstElement = BasicJavaAstTreeUtil.getRBrace(block);
            enterHandler = PlainEnterProcessor.getEnterHandler("EditorEnter");
        }
        editor.getCaretModel().moveToOffset(firstElement != null ? firstElement.getTextRange().getStartOffset() : block.getTextRange().getEndOffset());
        enterHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
        return true;
    }

    private static EditorActionHandler getEnterHandler(String actionId) {
        return EditorActionManager.getInstance().getActionHandler(actionId);
    }

    @Nullable
    private static ASTNode getControlStatementBlock(int caret, ASTNode astNode) {
        ASTNode methodBody;
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_TRY_STATEMENT)) {
            ASTNode tryBlock = BasicJavaAstTreeUtil.getCodeBlock(astNode);
            if (tryBlock != null && caret < tryBlock.getTextRange().getEndOffset()) {
                return tryBlock;
            }
            for (ASTNode catchBlock : BasicJavaAstTreeUtil.getCatchBlocks(astNode)) {
                if (catchBlock == null || caret >= catchBlock.getTextRange().getEndOffset()) continue;
                return catchBlock;
            }
            return BasicJavaAstTreeUtil.getFinallyBlock(astNode);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_SYNCHRONIZED_STATEMENT)) {
            return BasicJavaAstTreeUtil.getCodeBlock(astNode);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_METHOD) && (methodBody = BasicJavaAstTreeUtil.getCodeBlock(astNode)) != null) {
            return methodBody;
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_SWITCH_STATEMENT)) {
            return BasicJavaAstTreeUtil.getCodeBlock(astNode);
        }
        ASTNode body = null;
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getThenBranch(astNode);
            if (body != null && caret > body.getTextRange().getEndOffset()) {
                body = BasicJavaAstTreeUtil.getElseBranch(astNode);
            }
        } else if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_WHILE_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getBlock(astNode);
        } else if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getForBody(astNode);
        } else if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_FOREACH_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getBlock(astNode);
        } else if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_DO_WHILE_STATEMENT)) {
            body = BasicJavaAstTreeUtil.getDoWhileBody(astNode);
        }
        return BasicJavaAstTreeUtil.is(body, BasicJavaElementType.BASIC_BLOCK_STATEMENT) ? BasicJavaAstTreeUtil.getCodeBlock(body) : null;
    }

    private static boolean processExistingBlankLine(@NotNull Editor editor, @Nullable PsiElement codeBlock, @Nullable ASTNode element) {
        if (editor == null) {
            PlainEnterProcessor.$$$reportNull$$$0(3);
        }
        PsiWhiteSpace whiteSpace = null;
        if (codeBlock == null) {
            PsiElement next;
            PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(element);
            if (psiElement != null && !BasicJavaAstTreeUtil.is(element, BasicJavaElementType.MEMBER_SET) && (next = PsiTreeUtil.nextLeaf((PsiElement)psiElement)) instanceof PsiWhiteSpace) {
                whiteSpace = (PsiWhiteSpace)next;
            }
        } else {
            whiteSpace = (PsiWhiteSpace)PsiTreeUtil.findChildOfType((PsiElement)codeBlock, PsiWhiteSpace.class);
            if (whiteSpace == null) {
                return false;
            }
            PsiElement lbraceCandidate = whiteSpace.getPrevSibling();
            if (lbraceCandidate == null) {
                return false;
            }
            ASTNode node = lbraceCandidate.getNode();
            if (node == null || node.getElementType() != JavaTokenType.LBRACE) {
                return false;
            }
        }
        if (whiteSpace == null) {
            return false;
        }
        TextRange textRange = whiteSpace.getTextRange();
        Document document = editor.getDocument();
        CharSequence whiteSpaceText = document.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
        if (StringUtil.countNewLines((CharSequence)whiteSpaceText) < 2) {
            return false;
        }
        int i = CharArrayUtil.shiftForward((CharSequence)whiteSpaceText, (int)0, (String)" \t");
        if (i >= whiteSpaceText.length() - 1) {
            assert (false) : String.format("code block: %s, white space: %s", codeBlock == null ? "undefined" : codeBlock.getTextRange(), whiteSpace.getTextRange());
            return false;
        }
        editor.getCaretModel().moveToOffset(i + 1 + textRange.getStartOffset());
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorLineEnd");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        actionHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/PlainEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doEnter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "expandCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processExistingBlankLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

