/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicSemicolonFixer;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemicolonFixer
extends AbstractBasicSemicolonFixer {
    @Override
    protected boolean fixReturn(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        if (editor == null) {
            SemicolonFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiReturnStatement) {
            PsiReturnStatement stmt = (PsiReturnStatement)psiElement;
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method != null && PsiTypes.voidType().equals(method.getReturnType()) && stmt.getReturnValue() != null) {
                Document doc = editor.getDocument();
                doc.insertString(stmt.getTextRange().getStartOffset() + "return".length(), (CharSequence)";");
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean getSpaceAfterSemicolon(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SemicolonFixer.$$$reportNull$$$0(1);
        }
        return CodeStyle.getSettings((PsiFile)psiElement.getContainingFile()).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_SEMICOLON;
    }

    @Override
    protected boolean isImportStatementBase(@Nullable PsiElement psiElement) {
        return psiElement instanceof PsiImportStatementBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/SemicolonFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixReturn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpaceAfterSemicolon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

