/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateProducerBase;
import com.intellij.database.dialects.base.generator.producers.ProducerUtilsKt;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J#\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00028\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J+\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017*\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017*\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0018R\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/base/generator/producers/CreateSequence;", "T", "Lcom/intellij/database/model/basic/BasicSequence;", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducerBase;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/basic/BasicSequence;)V", "produceCreate", "", "gatherSequenceIdentityParameters", "sequence", "parameters", "", "", "(Lcom/intellij/database/model/basic/BasicSequence;Ljava/util/List;)V", "gatherSequenceStartParameters", "identity", "Lcom/intellij/database/model/SequenceIdentity;", "(Lcom/intellij/database/model/basic/BasicSequence;Lcom/intellij/database/model/SequenceIdentity;Ljava/util/List;)V", "nextDefault", "Ljava/math/BigInteger;", "Lorg/jetbrains/annotations/Nullable;", "(Lcom/intellij/database/model/basic/BasicSequence;)Ljava/math/BigInteger;", "startDefault", "minimumDefault", "maximumDefault", "isAsc", "", "(Lcom/intellij/database/model/SequenceIdentity;)Z", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nSequenceProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SequenceProducers.kt\ncom/intellij/database/dialects/base/generator/producers/CreateSequence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ScriptingContext.kt\ncom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter\n*L\n1#1,178:1\n1#2:179\n226#3,5:180\n77#3,6:185\n231#3,5:191\n*S KotlinDebug\n*F\n+ 1 SequenceProducers.kt\ncom/intellij/database/dialects/base/generator/producers/CreateSequence\n*L\n129#1:180,5\n130#1:185,6\n129#1:191,5\n*E\n"})
public class CreateSequence<T extends BasicSequence>
extends CreateProducerBase<T> {
    public CreateSequence(@NotNull ScriptingContext context, @NotNull T element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        super(context, (BasicElement)element);
    }

    @Override
    public void produceCreate() {
        ArrayList parameters = new ArrayList();
        this.gatherSequenceIdentityParameters((BasicSequence)this.getElement(), parameters);
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> CreateSequence.produceCreate$lambda$0(this, parameters, arg_0)));
    }

    public void gatherSequenceIdentityParameters(@NotNull T sequence, @NotNull List<String> parameters) {
        Intrinsics.checkNotNullParameter(sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        SequenceIdentity sequenceIdentity = sequence.getSequenceIdentity();
        Intrinsics.checkNotNullExpressionValue((Object)sequenceIdentity, (String)"getSequenceIdentity(...)");
        SequenceIdentity identity = sequenceIdentity;
        BigInteger inc = BaseIntrospectionFunctions.nullize(identity.increment, BaseIntrospectionFunctions.incrementDefault());
        BigInteger mn = BaseIntrospectionFunctions.nullize(identity.min, this.minimumDefault(sequence));
        BigInteger mx = BaseIntrospectionFunctions.nullize(identity.max, this.maximumDefault(sequence));
        this.gatherSequenceStartParameters(sequence, identity, parameters);
        int idx = parameters.size();
        if (mn != null) {
            parameters.add("minvalue " + mn);
        }
        if (inc != null) {
            parameters.add("increment by " + inc);
        }
        if (mx != null) {
            parameters.add("maxvalue " + mx);
        }
        if (!this.isAsc(identity)) {
            CollectionsKt.reverse(parameters.subList(idx, parameters.size()));
        }
    }

    protected void gatherSequenceStartParameters(@NotNull T sequence, @NotNull SequenceIdentity identity, @NotNull List<String> parameters) {
        Intrinsics.checkNotNullParameter(sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        BigInteger cur = BaseIntrospectionFunctions.nullize((Boolean)this.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE) != false ? identity.next : sequence.getStartValue(), this.startDefault(sequence));
        if (cur != null) {
            parameters.add("start with " + cur);
        }
    }

    @Nullable
    protected final BigInteger nextDefault(@NotNull T $this$nextDefault) {
        Intrinsics.checkNotNullParameter($this$nextDefault, (String)"<this>");
        BigInteger bigInteger = $this$nextDefault.getStartValue();
        if (bigInteger == null) {
            bigInteger = this.startDefault($this$nextDefault);
        }
        return bigInteger;
    }

    @Nullable
    protected final BigInteger startDefault(@NotNull T $this$startDefault) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter($this$startDefault, (String)"<this>");
        SequenceIdentity it = $this$startDefault.getSequenceIdentity();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        if (this.isAsc(it)) {
            bigInteger = it.min;
            if (bigInteger == null) {
                bigInteger = this.minimumDefault($this$startDefault);
            }
        } else {
            bigInteger = it.max;
            if (bigInteger == null) {
                bigInteger = this.maximumDefault($this$startDefault);
            }
        }
        return bigInteger;
    }

    @Nullable
    protected BigInteger minimumDefault(@NotNull T $this$minimumDefault) {
        Intrinsics.checkNotNullParameter($this$minimumDefault, (String)"<this>");
        SequenceIdentity it = $this$minimumDefault.getSequenceIdentity();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.isAsc(it) ? BigInteger.ONE : null;
    }

    @Nullable
    protected BigInteger maximumDefault(@NotNull T $this$maximumDefault) {
        Intrinsics.checkNotNullParameter($this$maximumDefault, (String)"<this>");
        SequenceIdentity it = $this$maximumDefault.getSequenceIdentity();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.isAsc(it) ? null : BigInteger.ONE.negate();
    }

    protected boolean isAsc(@NotNull SequenceIdentity $this$isAsc) {
        Intrinsics.checkNotNullParameter((Object)$this$isAsc, (String)"<this>");
        return BaseIntrospectionFunctions.isAscSequenceIncrement$default($this$isAsc.increment, false, 1, null);
    }

    private static final Unit produceCreate$lambda$0(CreateSequence this$0, ArrayList $parameters, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        ElementProducer elementProducer = this$0;
        ObjectKind objectKind = ObjectKind.SEQUENCE;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$newCoding.plus($this$newCoding.unaryPlus(ProducerUtilsKt.createOrReplace(elementProducer, objectKind)), "sequence");
        ElementProducer elementProducer2 = this$0;
        ObjectKind objectKind2 = ObjectKind.SEQUENCE;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"SEQUENCE");
        $this$newCoding.plus($this$newCoding.plus(newCodingAdapter, ProducerUtilsKt.ifNotExists(elementProducer2, objectKind2, true)), this$0.fqName());
        if (!((Collection)$parameters).isEmpty()) {
            ScriptingContext.NewCodingAdapter this_$iv = $this$newCoding;
            boolean $i$f$indenting = false;
            boolean prev$iv = this_$iv.getOnNewLine();
            int length$iv = this_$iv.getBuilder().getLength();
            this_$iv.newLine();
            this_$iv.indent();
            boolean bl = false;
            ScriptingContext.NewCodingAdapter $this$iv = $this$newCoding;
            boolean nl$iv = true;
            boolean $i$f$withNewLines = false;
            boolean prev$iv2 = $this$iv.getStartWithNewLine();
            $this$iv.setStartWithNewLine(nl$iv);
            boolean bl2 = false;
            Iterator iterator = $parameters.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String p = (String)e;
                $this$newCoding.unaryPlus(p);
            }
            $this$iv.setStartWithNewLine(prev$iv2);
            this_$iv.unindent();
            if (length$iv == this_$iv.getBuilder().getLength()) {
                this_$iv.setOnNewLine(prev$iv);
            }
        }
        return Unit.INSTANCE;
    }
}

