/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.actions;

import com.intellij.CommonBundle;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0014J\b\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/debugger/actions/OpenUrlDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "comboBoxModel", "Ljavax/swing/DefaultComboBoxModel;", "", "urlComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "enableOkIfValid", "", "isUrlValid", "", "doOKAction", "getUrl", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nOpenUrlDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenUrlDialog.kt\ncom/intellij/javascript/debugger/actions/OpenUrlDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class OpenUrlDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultComboBoxModel<String> comboBoxModel;
    private ComboBox<String> urlComboBox;
    @NotNull
    private final DialogPanel panel;

    public OpenUrlDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
        this.project = project;
        this.comboBoxModel = new DefaultComboBoxModel();
        this.panel = BuilderKt.panel(arg_0 -> OpenUrlDialog.panel$lambda$0(this, arg_0));
        this.setTitle(JSDebuggerBundle.message("action.JavaScriptDebugger.OpenUrl.dialog.title", new Object[0]));
        List urls = RecentsManager.getInstance((Project)this.project).getRecentEntries("OPEN_URL_DIALOG");
        Collection collection = urls;
        if (collection == null || collection.isEmpty()) {
            this.comboBoxModel.setSelectedItem("http://");
        } else {
            this.comboBoxModel.addAll(urls);
        }
        this.init();
        this.initValidation();
    }

    private final void enableOkIfValid() {
        this.getOKAction().setEnabled(this.isUrlValid());
    }

    private final boolean isUrlValid() {
        boolean bl;
        ComboBox<String> comboBox = this.urlComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"urlComboBox");
            comboBox = null;
        }
        Component component = comboBox.getEditor().getEditorComponent();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.text.JTextComponent");
        String url = ((JTextComponent)component).getText();
        Intrinsics.checkNotNull((Object)url);
        if (((CharSequence)url).length() == 0) {
            return false;
        }
        try {
            boolean bl2;
            Url parsed = Urls.parseEncoded((String)url);
            if (parsed == null) {
                bl2 = false;
            } else {
                parsed.toExternalForm();
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    protected void doOKAction() {
        String url = this.getUrl();
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            Object[] objectArray = new Object[]{url};
            Messages.showErrorDialog((Project)this.project, (String)JSDebuggerBundle.message("action.JavaScriptDebugger.OpenUrl.dialog.error", objectArray), (String)CommonBundle.getErrorTitle());
        } else {
            super.doOKAction();
            RecentsManager.getInstance((Project)this.project).registerRecentEntry("OPEN_URL_DIALOG", url);
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).openFile(file, true);
            Intrinsics.checkNotNull((Object)fileEditorArray);
        }
    }

    private final String getUrl() {
        Object object = this.comboBoxModel.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.panel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        ComboBox<String> comboBox = this.urlComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"urlComboBox");
            comboBox = null;
        }
        return (JComponent)comboBox;
    }

    private static final Unit panel$lambda$0(OpenUrlDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = JSDebuggerBundle.message("action.JavaScriptDebugger.OpenUrl.dialog.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> OpenUrlDialog.panel$lambda$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(OpenUrlDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell it = cell = Row.comboBox$default((Row)$this$row, (ComboBoxModel)this$0.comboBoxModel, null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).applyToComponent(OpenUrlDialog::panel$lambda$0$0$0).validationOnInput((arg_0, arg_1) -> OpenUrlDialog.panel$lambda$0$0$1(this$0, arg_0, arg_1));
        boolean bl = false;
        this$0.urlComboBox = (ComboBox)it.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0$0(ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setPreferredSize((Dimension)JBUI.size((int)300, (int)$this$applyToComponent.getPreferredSize().height));
        $this$applyToComponent.setEditable(true);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo panel$lambda$0$0$1(OpenUrlDialog this$0, ValidationInfoBuilder $this$validationOnInput, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.enableOkIfValid();
        return null;
    }
}

