/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.SourceContentFile;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystem;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.AppUIUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/debugger/scripts/VmScriptFile;", "Lcom/intellij/javascript/debugger/scripts/SourceContentFile;", "script", "Lorg/jetbrains/debugger/Script;", "<init>", "(Lorg/jetbrains/debugger/Script;)V", "setContent", "", "requestor", "", "content", "", "fireEvent", "", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "ensureDownloaded", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getScript", "()Lorg/jetbrains/debugger/Script;", "setScript", "intellij.javascript.debugger.backend"})
public final class VmScriptFile
extends SourceContentFile {
    @NotNull
    private volatile Script script;

    public VmScriptFile(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        super(script.getUrl(), "");
        this.script = script;
    }

    public void setContent(@Nullable Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (Intrinsics.areEqual((Object)content, (Object)this.getContent())) {
            return;
        }
        super.setContent(requestor, content, fireEvent);
        if (fireEvent) {
            AppUIUtil.invokeOnEdt(() -> VmScriptFile.setContent$lambda$0(this));
        }
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return (VirtualFileSystem)VmScriptFileSystem.Companion.getInstance();
    }

    @NotNull
    public final Promise<VirtualFile> ensureDownloaded() {
        if (this.isLoaded()) {
            return Promises.resolvedPromise((Object)((Object)this));
        }
        Script script = this.script;
        Promise promise = script.getVm().getScriptManager().getSource(script).then(arg_0 -> VmScriptFile.ensureDownloaded$lambda$1(arg_0 -> VmScriptFile.ensureDownloaded$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    @NotNull
    public final Script getScript() {
        return this.script;
    }

    public final void setScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (!Intrinsics.areEqual((Object)this.script, (Object)script)) {
            this.setContent(null, "", false);
            this.script = script;
            this.ensureDownloaded();
        }
    }

    private static final void setContent$lambda$0(VmScriptFile this$0) {
        VirtualFile[] virtualFileArray = new VirtualFile[]{this$0};
        FileDocumentManager.getInstance().reloadFiles(virtualFileArray);
    }

    private static final VirtualFile ensureDownloaded$lambda$0(VmScriptFile this$0, String it) {
        String string = StringUtilRt.convertLineSeparators((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        this$0.setContent(null, string, true);
        return (VirtualFile)this$0;
    }

    private static final VirtualFile ensureDownloaded$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

