/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.include;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportLikeElement;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCssFileIncludeProvider
extends FileIncludeProvider {
    private static final Logger LOG = Logger.getInstance(AbstractCssFileIncludeProvider.class);

    @NotNull
    public abstract String getId();

    public abstract boolean acceptFile(@NotNull VirtualFile var1);

    public abstract void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> var1);

    public final FileIncludeInfo @NotNull [] getIncludeInfos(@NotNull FileContent inputData) {
        if (inputData == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(0);
        }
        if (!this.hasImports(inputData.getContentAsText())) {
            if (FileIncludeInfo.EMPTY == null) {
                AbstractCssFileIncludeProvider.$$$reportNull$$$0(1);
            }
            return FileIncludeInfo.EMPTY;
        }
        final ArrayList result = new ArrayList();
        final VirtualFile hostFile = inputData.getFile();
        final String hostFileExt = StringUtil.notNullize((String)hostFile.getExtension());
        inputData.getPsiFile().accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitCssImport(CssImport cssImport) {
                for (String uri : CssResolveUtil.getUriStrings((CssImport)cssImport)) {
                    if (!AbstractCssFileIncludeProvider.canBeResolvedToLocalFile(uri)) continue;
                    String uriExt = FileUtilRt.getExtension((String)uri);
                    AbstractCssFileIncludeProvider.this.addImports(result, hostFile, hostFileExt, uri, uriExt);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof CssImportLikeElement) {
                    AbstractCssFileIncludeProvider.this.handleImportLikeElement((CssImportLikeElement)element, hostFile, result);
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/include/AbstractCssFileIncludeProvider$1", "visitElement"));
            }
        });
        FileIncludeInfo[] fileIncludeInfoArray = result.toArray(FileIncludeInfo.EMPTY);
        if (fileIncludeInfoArray == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(2);
        }
        return fileIncludeInfoArray;
    }

    protected void handleImportLikeElement(@NotNull CssImportLikeElement rule, @NotNull VirtualFile hostFile, @NotNull List<FileIncludeInfo> result) {
        if (rule == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(3);
        }
        if (hostFile == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(4);
        }
        if (result == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(5);
        }
    }

    private static boolean canBeResolvedToLocalFile(@NotNull String uri) {
        if (uri == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(6);
        }
        return !HtmlUtil.hasHtmlPrefix((String)uri) && !uri.startsWith("\\\\");
    }

    protected boolean hasImports(@NotNull CharSequence hostFileText) {
        if (hostFileText == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(7);
        }
        return CharArrayUtil.indexOf((CharSequence)hostFileText, (CharSequence)"@import", (int)0) >= 0;
    }

    protected abstract void addImports(@NotNull List<FileIncludeInfo> var1, @NotNull VirtualFile var2, @NotNull String var3, @NotNull String var4, @NotNull String var5);

    @NotNull
    protected abstract Language getLanguage();

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        CssImport cssImport;
        PsiFile psiFile;
        PsiFileImpl psiFileImpl;
        if (info == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(9);
        }
        if ((psiFileImpl = (PsiFileImpl)ObjectUtils.tryCast((Object)(psiFile = (cssImport = CssElementFactory.getInstance((Project)context.getProject()).createImport(info.path, this.getLanguage())).getContainingFile()), PsiFileImpl.class)) == null) {
            LOG.error("Expected type: " + PsiFileImpl.class.getName() + ", actual type: " + (psiFile == null ? null : psiFile.getClass().getName()));
            return null;
        }
        psiFileImpl.setOriginalFile(context);
        return (PsiFileSystemItem)ArrayUtil.getFirstElement((Object[])CssResolveUtil.resolveImport((CssImport)cssImport));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/include/AbstractCssFileIncludeProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/include/AbstractCssFileIncludeProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeInfos";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleImportLikeElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeResolvedToLocalFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasImports";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

