/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.run.EelDatabaseHelperKt;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.lang.JavaVersion;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleRunConfiguration
extends RunConfigurationBase<Element>
implements RunProfile {
    public static final ExtensionPointName<ConsoleConfigurationParamProvider> ADJUSTERS = ExtensionPointName.create((String)"com.intellij.database.processParamProvider");
    public String VM_PARAMETERS;
    public Map<String, String> VM_PARAMETERS_GROUPS = Collections.emptyMap();
    public Map<String, String> VM_ENV;
    public DatabaseCredentials CREDENTIALS = DatabaseCredentials.getInstance();

    public void setOptionsFromDataSource(LocalDataSource dataSource) {
        ParametersList params = new ParametersList();
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        if (driver != null) {
            params.addParametersString(driver.getVmOptions());
        }
        params.addParametersString(dataSource.getVmOptions());
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>(dataSource.getVmEnv());
        if (driver != null) {
            env.putAll(driver.getVmEnv());
        }
        params.addParamsGroup("exports");
        for (ConsoleConfigurationParamProvider adjuster : (ConsoleConfigurationParamProvider[])ADJUSTERS.getExtensions()) {
            adjuster.populate(dataSource, params, env);
        }
        this.VM_PARAMETERS = ParametersList.join((List)params.getParameters());
        this.VM_PARAMETERS_GROUPS = ConsoleRunConfiguration.extractGroups(params);
        this.VM_ENV = env;
        this.setBeforeRunTasks(DataSourceUtil.instantiateBeforeTasks(this, dataSource.getBeforeTasks()));
        this.setName(dataSource.getName());
    }

    @Nullable
    private static Map<String, String> extractGroups(ParametersList params) {
        List groups = params.getParamsGroups();
        LinkedHashMap<String, String> res = groups.isEmpty() ? null : new LinkedHashMap<String, String>();
        for (ParamsGroup g : groups) {
            res.put(g.getId(), ParametersList.join((List)g.getParameters()));
        }
        return res;
    }

    @NotNull
    public static ConsoleRunConfiguration newConfiguration(@NotNull Project project) {
        if (project == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(0);
        }
        return new ConsoleRunConfiguration(project, "Default");
    }

    public ConsoleRunConfiguration(Project project, String name) {
        super(project, null, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        throw new UnsupportedOperationException();
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(2);
        }
        if (!(env.getRunnerSettings() instanceof RunContext)) {
            throw new ExecutionException(DatabaseBundle.message((String)"console.run.configuration.no.context.specified", (Object[])new Object[0]));
        }
        return new CommandLineState(env){

            private SimpleJavaParameters createJavaParameters() throws ExecutionException {
                RunContext runContext = (RunContext)Objects.requireNonNull(this.getEnvironment().getRunnerSettings());
                Project project = ConsoleRunConfiguration.this.getProject();
                if (!project.isOpen()) {
                    throw new ExecutionException(DatabaseBundle.message((String)"dialog.message.execution.cancelled", (Object[])new Object[0]));
                }
                SimpleJavaParameters params = new SimpleJavaParameters();
                Sdk sdk = runContext.getSdk();
                if (sdk != null) {
                    params.setJdk(sdk);
                } else {
                    params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
                }
                params.setCharset(EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
                ParametersList vm = params.getVMParametersList();
                vm.addParametersString(ConsoleRunConfiguration.this.VM_PARAMETERS);
                for (Map.Entry<String, String> e : ConsoleRunConfiguration.this.VM_PARAMETERS_GROUPS.entrySet()) {
                    if ("exports".equals(e.getKey()) && !ConsoleRunConfiguration.hasExports(params.getJdk())) continue;
                    vm.addParamsGroup(e.getKey()).addParametersString(e.getValue());
                }
                boolean idePreferIPv4 = Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Stack", "false"));
                boolean forced = vm.hasProperty("java.net.preferIPv4Stack");
                if (idePreferIPv4 && !forced) {
                    vm.addProperty("java.net.preferIPv4Stack", "true");
                }
                String hostName = System.getProperty("java.rmi.server.hostname");
                if (!vm.hasProperty("java.rmi.server.hostname") && hostName != null) {
                    vm.addProperty("java.rmi.server.hostname", hostName);
                }
                if (ConsoleRunConfiguration.this.VM_ENV != null) {
                    for (Map.Entry<String, String> entry : ConsoleRunConfiguration.this.VM_ENV.entrySet()) {
                        params.addEnv(entry.getKey(), entry.getValue());
                    }
                }
                runContext.collectClassPath(params.getClassPath());
                params.setWorkingDirectory(PathManager.getBinPath());
                params.setMainClass(runContext.getMainClassName());
                runContext.tuneParams(project, params);
                params.setUseDynamicClasspath(project);
                return params;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(1);
                }
                OSProcessHandler processHandler = this.startProcess();
                return new DefaultExecutionResult((ProcessHandler)processHandler);
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                boolean useEel;
                EelDescriptor descriptor = EelProviderUtil.getEelDescriptor((Project)ConsoleRunConfiguration.this.getProject());
                SimpleJavaParameters params = (SimpleJavaParameters)ReadAction.compute(this::createJavaParameters);
                RunnerSettings settings = this.getEnvironment().getRunnerSettings();
                if (settings instanceof JdbcConsoleRunContext) {
                    JdbcConsoleRunContext runContext = (JdbcConsoleRunContext)settings;
                    useEel = DatabaseArtifactContext.Companion.getInstance(ConsoleRunConfiguration.this.getProject(), runContext.getDataSource()).useEel();
                } else {
                    boolean bl = useEel = !(descriptor instanceof LocalEelDescriptor);
                }
                if (!useEel) {
                    OSProcessHandler processHandler = new OSProcessHandler(params.toCommandLine()){

                        @NotNull
                        protected BaseOutputReader.Options readerOptions() {
                            BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                            if (options == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return options;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleRunConfiguration$1$1", "readerOptions"));
                        }
                    };
                    ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                    OSProcessHandler oSProcessHandler = processHandler;
                    if (oSProcessHandler == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return oSProcessHandler;
                }
                KillableColoredProcessHandler killableColoredProcessHandler = EelDatabaseHelperKt.createProcess(descriptor, params);
                if (killableColoredProcessHandler == null) {
                    1.$$$reportNull$$$0(3);
                }
                return killableColoredProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ConsoleRunConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ConsoleRunConfiguration$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    public ConsoleRunConfiguration clone() {
        ConsoleRunConfiguration result = (ConsoleRunConfiguration)super.clone();
        result.VM_PARAMETERS = this.VM_PARAMETERS;
        result.VM_PARAMETERS_GROUPS = this.VM_PARAMETERS_GROUPS == null ? null : new LinkedHashMap<String, String>(this.VM_PARAMETERS_GROUPS);
        result.VM_ENV = this.VM_ENV == null ? null : new LinkedHashMap<String, String>(this.VM_ENV);
        return result;
    }

    public static boolean hasExports(@Nullable Sdk jdk) {
        String verStr = jdk == null ? null : jdk.getVersionString();
        JavaVersion ver = JavaVersion.tryParse((String)verStr);
        return ver != null && ver.feature >= 9;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ConsoleRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface RunContext
    extends RunnerSettings {
        public static final ExtensionPointName<ConsoleRunContextParametersTuner> PARAMETERS_TUNERS = ExtensionPointName.create((String)"com.intellij.database.consoleRunContextParametersTuner");

        public String getMainClassName();

        @Nullable
        default public Sdk getSdk() {
            return null;
        }

        public void collectClassPath(PathsList var1) throws ExecutionException;

        default public void tuneParams(@NotNull Project project, @NotNull SimpleJavaParameters params) throws ExecutionException {
            if (project == null) {
                RunContext.$$$reportNull$$$0(0);
            }
            if (params == null) {
                RunContext.$$$reportNull$$$0(1);
            }
        }

        default public void readExternal(Element element) throws InvalidDataException {
        }

        default public void writeExternal(Element element) throws WriteExternalException {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ConsoleRunConfiguration$RunContext";
            objectArray[2] = "tuneParams";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

