/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.protocolHandlers;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/gateway/protocolHandlers/WindowsProtocolHandler;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "install", "", "uninstall", "registryCreateKey", "keyName", "", "registrySetStringValue", "keyPath", "name", "value", "getInstallationPath", "intellij.gateway"})
@SourceDebugExtension(value={"SMAP\nWindowsProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsProtocolHandler.kt\ncom/jetbrains/gateway/protocolHandlers/WindowsProtocolHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,48:1\n13#2:49\n*S KotlinDebug\n*F\n+ 1 WindowsProtocolHandler.kt\ncom/jetbrains/gateway/protocolHandlers/WindowsProtocolHandler\n*L\n12#1:49\n*E\n"})
public final class WindowsProtocolHandler {
    @NotNull
    public static final WindowsProtocolHandler INSTANCE = new WindowsProtocolHandler();
    @NotNull
    private static final Logger logger;

    private WindowsProtocolHandler() {
    }

    public final void install() {
        this.registryCreateKey("Software\\Classes\\jetbrains-gateway");
        this.registryCreateKey("Software\\Classes\\jetbrains-gateway\\shell\\open\\command");
        this.registrySetStringValue("Software\\Classes\\jetbrains-gateway", "", "\"JetBrains Gateway Protocol\"");
        this.registrySetStringValue("Software\\Classes\\jetbrains-gateway", "URL Protocol", "\"\"");
        this.registrySetStringValue("Software\\Classes\\jetbrains-gateway\\shell\\open\\command", "", "\"" + this.getInstallationPath() + "\" \"%1\"");
    }

    public final void uninstall() {
        Advapi32Util.registryDeleteKey((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Software\\Classes\\jetbrains-gateway");
    }

    private final void registryCreateKey(String keyName) {
        logger.info("Register " + keyName + "...");
        boolean result = Advapi32Util.registryCreateKey((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)keyName, (int)256);
        if (result) {
            logger.info("Success");
        } else {
            logger.info("Can not register key " + keyName + " in HKEY_CURRENT_USER as KEY_WOW64_64KEY, probably the key already exists");
        }
    }

    private final void registrySetStringValue(String keyPath, String name, String value) {
        logger.info("Register " + keyPath + " " + name + "=" + value + "...");
        Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)keyPath, (String)name, (String)value, (int)256);
        String resultValue = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)keyPath, (String)name);
        if (Intrinsics.areEqual((Object)resultValue, (Object)value)) {
            logger.info("Success");
        } else {
            logger.error("Can not set value in " + keyPath + " " + name + " in HKEY_CURRENT_USER as KEY_WOW64_64KEY. Actual value: " + resultValue);
        }
    }

    private final String getInstallationPath() {
        String string = PathManager.getBinPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBinPath(...)");
        return StringsKt.replace$default((String)string, (String)"/", (String)"\\", (boolean)false, (int)4, null) + "\\gateway64.exe";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WindowsProtocolHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WindowsProtocolHandler.logger = logger;
    }
}

