/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.model.common.persistence.JavaeePersistenceConstants;
import com.intellij.jpa.model.xml.persistence.mapping.AccessType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

final class JpaImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> INJECTION_ANNOTATIONS = JpaImplicitUsageProvider.mapJavaeeClasses(JavaeePersistenceConstants.PERSISTENCE_CONTEXT_ANNO, JavaeePersistenceConstants.PERSISTENCE_UNIT_ANNO, JavaeePersistenceConstants.GENERATED_VALUE_ANNO);
    private static final List<String> LISTENER_ANNOTATIONS = JpaImplicitUsageProvider.mapJavaeeClasses(JavaeePersistenceConstants.POST_LOAD_ANNO, JavaeePersistenceConstants.POST_PERSIST_ANNO, JavaeePersistenceConstants.POST_REMOVE_ANNO, JavaeePersistenceConstants.POST_UPDATE_ANNO, JavaeePersistenceConstants.PRE_PERSIST_ANNO, JavaeePersistenceConstants.PRE_REMOVE_ANNO, JavaeePersistenceConstants.PRE_UPDATE_ANNO);
    private static final List<String> ENTITY_ANNOTATIONS = JpaImplicitUsageProvider.mapJavaeeClasses(JavaeePersistenceConstants.ENTITY_ANNO, JavaeePersistenceConstants.MAPPED_SUPERCLASS_ANNO, JavaeePersistenceConstants.EMBEDDABLE_ANNO);
    private static final List<String> STRONG_ENTITY_ANNOTATION = JpaImplicitUsageProvider.mapJavaeeClasses(JavaeePersistenceConstants.ENTITY_ANNO);
    private static final List<String> AUTO_PROPERTIES_ANNOTATIONS = ContainerUtil.concat(JpaImplicitUsageProvider.mapJavaeeClasses(JavaeePersistenceConstants.ID_ANNO, JavaeePersistenceConstants.VERSION_ANNO), List.of("org.hibernate.annotations.PartitionKey"));

    JpaImplicitUsageProvider() {
    }

    @NotNull
    private static List<String> mapJavaeeClasses(JavaeeClass ... javaeeClasses) {
        ArrayList<String> annotations = new ArrayList<String>();
        for (JavaeeClass javaeeClass : javaeeClasses) {
            annotations.add(javaeeClass.javax());
            annotations.add(javaeeClass.jakarta());
        }
        List<String> list = List.copyOf(annotations);
        if (list == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            boolean isSetter = PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
            if (isSetter && JpaImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOTATIONS)) {
                return true;
            }
            if (JpaImplicitUsageProvider.isAnnotated((PsiElement)method, LISTENER_ANNOTATIONS)) {
                return true;
            }
            if (method.isConstructor()) {
                if (method.getParameterList().getParametersCount() == 0 && JpaImplicitUsageProvider.isLikeEntityClass(method.getContainingClass())) {
                    return true;
                }
            } else if (PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
                String name = PropertyUtilBase.getPropertyName((PsiMethod)method);
                if (name == null) {
                    return false;
                }
                PsiClass containingClass = method.getContainingClass();
                PsiMethod getter = isSetter ? PropertyUtilBase.findPropertyGetter((PsiClass)containingClass, (String)name, (boolean)false, (boolean)true) : method;
                PsiMethod setter = isSetter ? method : PropertyUtilBase.findPropertySetter((PsiClass)containingClass, (String)name, (boolean)false, (boolean)true);
                return JpaImplicitUsageProvider.isAnnotated((PsiElement)getter, AUTO_PROPERTIES_ANNOTATIONS) || containingClass != null && JpaImplicitUsageProvider.isAnnotated((PsiElement)PropertyUtilBase.findPropertyField((PsiClass)containingClass, (String)name, (boolean)false), AUTO_PROPERTIES_ANNOTATIONS) || JpaInspectionUtil.getMemberAccessType((PsiElement)getter) == AccessType.PROPERTY || JpaInspectionUtil.getMemberAccessType((PsiElement)setter) == AccessType.PROPERTY;
            }
        } else {
            if (element instanceof PsiParameter) {
                PsiElement scope = ((PsiParameter)element).getDeclarationScope();
                return scope instanceof PsiMethod && JpaImplicitUsageProvider.isAnnotated(scope, LISTENER_ANNOTATIONS);
            }
            if (element instanceof PsiField) {
                return JpaImplicitUsageProvider.isAnnotated(element, AUTO_PROPERTIES_ANNOTATIONS);
            }
            if (element instanceof PsiClass) {
                PsiAnnotationMemberValue autoApplyValue;
                UExpression uElement;
                PsiClass psiClass = (PsiClass)element;
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, STRONG_ENTITY_ANNOTATION, (int)0)) {
                    return true;
                }
                PsiAnnotation converterAnnotation = psiClass.getAnnotation(JavaeePersistenceConstants.CONVERTER_ANNO.javax());
                if (converterAnnotation == null) {
                    converterAnnotation = psiClass.getAnnotation(JavaeePersistenceConstants.CONVERTER_ANNO.jakarta());
                }
                if (converterAnnotation != null && (uElement = (UExpression)UastContextKt.toUElement((PsiElement)(autoApplyValue = converterAnnotation.findAttributeValue("autoApply")), UExpression.class)) != null && Boolean.TRUE.equals(uElement.evaluate())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        PsiField psiField;
        PsiClass containingClass;
        if (element == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiField && JpaImplicitUsageProvider.isLikeEntityClass(containingClass = (psiField = (PsiField)element).getContainingClass()) && JpaImplicitUsageProvider.isFieldInitializedInScope(psiField, containingClass.getConstructors())) {
            return true;
        }
        return JpaImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOTATIONS);
    }

    private static boolean isLikeEntityClass(@Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, ENTITY_ANNOTATIONS, (int)0);
    }

    private static boolean isAnnotated(PsiElement owner, List<String> annotations) {
        return owner instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)owner), annotations, (int)0);
    }

    private static boolean isFieldInitializedInScope(@NotNull PsiField field, PsiMethod[] constructors) {
        if (field == null) {
            JpaImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return ((StreamEx)StreamEx.of((Object[])constructors).filter(constructor -> constructor.hasParameters() && constructor.getBody() != null)).allMatch(constructor -> ControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)constructor.getBody()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/JpaImplicitUsageProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mapJavaeeClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/JpaImplicitUsageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

