/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.jpa.model.annotations.mapping.EmbeddableImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.MappedSuperclassImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;

public abstract class AbstractUastJpaInspection
extends AbstractBaseUastLocalInspectionTool {
    protected AbstractUastJpaInspection() {
        super(new Class[]{UClass.class});
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            AbstractUastJpaInspection.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile())) == null || !JpaConfigurationModel.hasJpaSupport(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                AbstractUastJpaInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            AbstractUastJpaInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PersistenceClassRole[] roles;
        if (aClass == null) {
            AbstractUastJpaInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            AbstractUastJpaInspection.$$$reportNull$$$0(4);
        }
        if ((roles = AbstractUastJpaInspection.getPersistenceRoles(aClass)).length == 0) {
            return super.checkClass(aClass, manager, isOnTheFly);
        }
        PsiElement sourcePsi = aClass.getSourcePsi();
        if (sourcePsi == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(this, manager, sourcePsi.getContainingFile(), isOnTheFly){
            private final Set<Pair<TextRange, String>> myUniqueCheck = new HashSet<Pair<TextRange, String>>();

            public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
                if (problemDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.myUniqueCheck.add((Pair<TextRange, String>)Pair.create((Object)((ProblemDescriptorBase)problemDescriptor).getTextRange(), (Object)problemDescriptor.getDescriptionTemplate()))) {
                    super.registerProblem(problemDescriptor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/jpa/inspections/AbstractUastJpaInspection$1", "registerProblem"));
            }
        };
        this.checkClassAllRoles(aClass, roles, holder, isOnTheFly);
        for (PersistenceClassRole role : roles) {
            this.checkClass(aClass, role, holder, isOnTheFly);
        }
        return holder.getResultsArray();
    }

    private static PersistenceClassRole @NotNull [] getPersistenceRoles(@NotNull UClass aClass) {
        PsiClass psiClass;
        if (aClass == null) {
            AbstractUastJpaInspection.$$$reportNull$$$0(5);
        }
        if (EntityImpl.ENTITY_META.getJamElement((PsiModifierListOwner)(psiClass = aClass.getJavaPsi())) != null || MappedSuperclassImpl.MAPPED_SUPERCLASS_META.getJamElement((PsiModifierListOwner)psiClass) != null || EmbeddableImpl.EMBEDDABLE_META.getJamElement((PsiModifierListOwner)psiClass) != null) {
            PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
            if (persistenceClassRoleArray == null) {
                AbstractUastJpaInspection.$$$reportNull$$$0(6);
            }
            return persistenceClassRoleArray;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            JpaModuleConfiguration configuration = JpaConfigurationModel.getConfiguration(module);
            if (configuration == null) {
                if (PersistenceClassRole.EMPTY_ARRAY == null) {
                    AbstractUastJpaInspection.$$$reportNull$$$0(7);
                }
                return PersistenceClassRole.EMPTY_ARRAY;
            }
            List configFiles = configuration.getDescriptors();
            if (configFiles.isEmpty()) {
                if (PersistenceClassRole.EMPTY_ARRAY == null) {
                    AbstractUastJpaInspection.$$$reportNull$$$0(8);
                }
                return PersistenceClassRole.EMPTY_ARRAY;
            }
        }
        PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
        if (persistenceClassRoleArray == null) {
            AbstractUastJpaInspection.$$$reportNull$$$0(9);
        }
        return persistenceClassRoleArray;
    }

    protected void checkClassAllRoles(UClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
    }

    protected void checkClass(UClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/inspections/AbstractUastJpaInspection";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/inspections/AbstractUastJpaInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceRoles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceRoles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

