/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.plugins;

import com.intellij.ktor.KtorStarterIcons;
import com.intellij.ktor.initializr.KtorGeneratorWebAPI;
import com.intellij.ktor.initializr.json.KtorPluginDocumentation;
import com.intellij.ktor.initializr.json.KtorPluginSearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001HB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000\u00052\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0&H\u0002J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005J\u0014\u0010>\u001a\u00020\u001e2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020<0;J\u0014\u0010@\u001a\u00020\u001e2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020<0;J\u0006\u0010E\u001a\u00020<J\b\u0010F\u001a\u00020<H\u0002J\b\u0010G\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0015\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u0017\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0019\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R!\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)R!\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010+\u001a\u0004\b-\u0010)R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010+\u001a\u0004\b3\u00104R\u001b\u00106\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010+\u001a\u0004\b7\u0010\u000fR\u001a\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u001f\"\u0004\bC\u0010D\u00a8\u0006I"}, d2={"Lcom/intellij/ktor/initializr/plugins/KtorPluginModel;", "", "feature", "Lcom/intellij/ktor/initializr/json/KtorPluginSearchResult;", "allPlugins", "", "generatorApi", "Lcom/intellij/ktor/initializr/KtorGeneratorWebAPI;", "factory", "Lcom/intellij/ktor/initializr/plugins/KtorPluginModel$Factory;", "<init>", "(Lcom/intellij/ktor/initializr/json/KtorPluginSearchResult;Ljava/util/List;Lcom/intellij/ktor/initializr/KtorGeneratorWebAPI;Lcom/intellij/ktor/initializr/plugins/KtorPluginModel$Factory;)V", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "shortDescription", "Lcom/intellij/openapi/util/NlsSafe;", "getShortDescription", "vendor", "getVendor", "vendorUrl", "getVendorUrl", "version", "getVersion", "githubRepo", "getGithubRepo", "isRemovable", "", "()Z", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "findOrCreatePluginModels", "predicate", "Lkotlin/Function1;", "requiredPluginModels", "getRequiredPluginModels", "()Ljava/util/List;", "requiredPluginModels$delegate", "Lkotlin/Lazy;", "dependentPluginModels", "getDependentPluginModels", "dependentPluginModels$delegate", "findRecursivelyRequiredPlugins", "findRecursivelyDependentPlugins", "documentation", "Lcom/intellij/ktor/initializr/json/KtorPluginDocumentation;", "getDocumentation", "()Lcom/intellij/ktor/initializr/json/KtorPluginDocumentation;", "documentation$delegate", "documentationMarkdownString", "getDocumentationMarkdownString", "documentationMarkdownString$delegate", "selectCallbacks", "", "Lkotlin/Function0;", "", "unselectCallbacks", "onSelect", "body", "onUnselect", "selected", "getSelected", "setSelected", "(Z)V", "changeSelection", "select", "unselect", "Factory", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorPluginModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorPluginModel.kt\ncom/intellij/ktor/initializr/plugins/KtorPluginModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1563#2:138\n1634#2,3:139\n1563#2:142\n1634#2,3:143\n1869#2,2:146\n1869#2,2:148\n1869#2,2:151\n1869#2,2:153\n1#3:150\n*S KotlinDebug\n*F\n+ 1 KtorPluginModel.kt\ncom/intellij/ktor/initializr/plugins/KtorPluginModel\n*L\n48#1:138\n48#1:139,3\n51#1:142\n51#1:143,3\n79#1:146,2\n84#1:148,2\n89#1:151,2\n97#1:153,2\n*E\n"})
public final class KtorPluginModel {
    @NotNull
    private final KtorPluginSearchResult feature;
    @NotNull
    private final List<KtorPluginSearchResult> allPlugins;
    @NotNull
    private final KtorGeneratorWebAPI generatorApi;
    @NotNull
    private final Factory factory;
    private final boolean isRemovable;
    @NotNull
    private final Icon icon;
    @NotNull
    private final Lazy requiredPluginModels$delegate;
    @NotNull
    private final Lazy dependentPluginModels$delegate;
    @NotNull
    private final Lazy documentation$delegate;
    @NotNull
    private final Lazy documentationMarkdownString$delegate;
    @NotNull
    private final List<Function0<Unit>> selectCallbacks;
    @NotNull
    private final List<Function0<Unit>> unselectCallbacks;
    private boolean selected;

    private KtorPluginModel(KtorPluginSearchResult feature, List<KtorPluginSearchResult> allPlugins, KtorGeneratorWebAPI generatorApi, Factory factory) {
        this.feature = feature;
        this.allPlugins = allPlugins;
        this.generatorApi = generatorApi;
        this.factory = factory;
        this.isRemovable = this.feature.isRemovable();
        Icon icon = KtorStarterIcons.Plugin;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Plugin");
        this.icon = icon;
        this.requiredPluginModels$delegate = LazyKt.lazy(() -> KtorPluginModel.requiredPluginModels_delegate$lambda$0(this));
        this.dependentPluginModels$delegate = LazyKt.lazy(() -> KtorPluginModel.dependentPluginModels_delegate$lambda$0(this));
        this.documentation$delegate = LazyKt.lazy(() -> KtorPluginModel.documentation_delegate$lambda$0(this));
        this.documentationMarkdownString$delegate = LazyKt.lazy(() -> KtorPluginModel.documentationMarkdownString_delegate$lambda$0(this));
        this.selectCallbacks = new ArrayList();
        this.unselectCallbacks = new ArrayList();
        this.selected = !this.isRemovable;
        this.onSelect((Function0<Unit>)((Function0)() -> KtorPluginModel._init_$lambda$0(this)));
        this.onUnselect((Function0<Unit>)((Function0)() -> KtorPluginModel._init_$lambda$1(this)));
    }

    @NotNull
    public final String getId() {
        return this.feature.getId();
    }

    @NotNull
    public final String getName() {
        return this.feature.getName();
    }

    @NotNull
    public final String getShortDescription() {
        return this.feature.getShortDescription();
    }

    @NotNull
    public final String getVendor() {
        return this.feature.getVendor();
    }

    @NotNull
    public final String getVendorUrl() {
        return this.feature.getVendorUrl();
    }

    @NotNull
    public final String getVersion() {
        return this.feature.getVersion();
    }

    @Nullable
    public final String getGithubRepo() {
        return this.feature.getGithubLink();
    }

    public final boolean isRemovable() {
        return this.isRemovable;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    private final List<KtorPluginModel> findOrCreatePluginModels(Function1<? super KtorPluginSearchResult, Boolean> predicate) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.allPlugins), predicate), arg_0 -> KtorPluginModel.findOrCreatePluginModels$lambda$0(this, arg_0)));
    }

    private final List<KtorPluginModel> getRequiredPluginModels() {
        Lazy lazy = this.requiredPluginModels$delegate;
        return (List)lazy.getValue();
    }

    private final List<KtorPluginModel> getDependentPluginModels() {
        Lazy lazy = this.dependentPluginModels$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtorPluginModel> findRecursivelyRequiredPlugins() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getRequiredPluginModels();
        Collection collection = this.getRequiredPluginModels();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtorPluginModel ktorPluginModel = (KtorPluginModel)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.findRecursivelyRequiredPlugins());
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtorPluginModel> findRecursivelyDependentPlugins() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getDependentPluginModels();
        Collection collection = this.getDependentPluginModels();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtorPluginModel ktorPluginModel = (KtorPluginModel)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.findRecursivelyDependentPlugins());
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
    }

    private final KtorPluginDocumentation getDocumentation() {
        Lazy lazy = this.documentation$delegate;
        return (KtorPluginDocumentation)lazy.getValue();
    }

    @NotNull
    public final String getDocumentationMarkdownString() {
        Lazy lazy = this.documentationMarkdownString$delegate;
        return (String)lazy.getValue();
    }

    public final boolean onSelect(@NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.selectCallbacks.add(body);
    }

    public final boolean onUnselect(@NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.unselectCallbacks.add(body);
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean bl) {
        this.selected = bl;
    }

    public final void changeSelection() {
        if (this.selected) {
            this.unselect();
        } else {
            this.select();
        }
    }

    private final void select() {
        this.selected = true;
        Iterable $this$forEach$iv = this.selectCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void unselect() {
        this.selected = false;
        Iterable $this$forEach$iv = this.unselectCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final KtorPluginModel findOrCreatePluginModels$lambda$0(KtorPluginModel this$0, KtorPluginSearchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.factory.findOrCreate(it, this$0.allPlugins);
    }

    private static final List requiredPluginModels_delegate$lambda$0(KtorPluginModel this$0) {
        return this$0.findOrCreatePluginModels((Function1<? super KtorPluginSearchResult, Boolean>)((Function1)arg_0 -> KtorPluginModel.requiredPluginModels_delegate$lambda$0$0(this$0, arg_0)));
    }

    private static final boolean requiredPluginModels_delegate$lambda$0$0(KtorPluginModel this$0, KtorPluginSearchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.feature.getRequiredPluginIds().contains(it.getId());
    }

    private static final List dependentPluginModels_delegate$lambda$0(KtorPluginModel this$0) {
        return this$0.findOrCreatePluginModels((Function1<? super KtorPluginSearchResult, Boolean>)((Function1)arg_0 -> KtorPluginModel.dependentPluginModels_delegate$lambda$0$0(this$0, arg_0)));
    }

    private static final boolean dependentPluginModels_delegate$lambda$0$0(KtorPluginModel this$0, KtorPluginSearchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRequiredPluginIds().contains(this$0.feature.getId());
    }

    private static final KtorPluginDocumentation documentation_delegate$lambda$0(KtorPluginModel this$0) {
        Object object;
        KtorPluginModel ktorPluginModel = this$0;
        try {
            KtorPluginModel $this$documentation_delegate_u24lambda_u240_u240 = ktorPluginModel;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$documentation_delegate_u24lambda_u240_u240.generatorApi.getPluginDocumentation($this$documentation_delegate_u24lambda_u240_u240.feature.getId(), $this$documentation_delegate_u24lambda_u240_u240.feature.getVersion()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object documentation = object;
        KtorPluginDocumentation ktorPluginDocumentation = (KtorPluginDocumentation)(Result.isFailure-impl((Object)documentation) ? null : documentation);
        if (ktorPluginDocumentation == null) {
            ktorPluginDocumentation = KtorPluginDocumentation.Companion.getEmptyDocumentation();
        }
        return ktorPluginDocumentation;
    }

    private static final String documentationMarkdownString_delegate$lambda$0(KtorPluginModel this$0) {
        return this$0.getDocumentation().toMarkdownString();
    }

    private static final Unit _init_$lambda$0(KtorPluginModel this$0) {
        Iterable $this$forEach$iv = this$0.getRequiredPluginModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtorPluginModel it = (KtorPluginModel)element$iv;
            boolean bl = false;
            if (it.selected) continue;
            it.select();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(KtorPluginModel this$0) {
        Iterable $this$forEach$iv = this$0.getDependentPluginModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtorPluginModel it = (KtorPluginModel)element$iv;
            boolean bl = false;
            if (!it.selected) continue;
            it.unselect();
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ KtorPluginModel(KtorPluginSearchResult feature, List allPlugins, KtorGeneratorWebAPI generatorApi, Factory factory, DefaultConstructorMarker $constructor_marker) {
        this(feature, allPlugins, generatorApi, factory);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u001c\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0014R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ktor/initializr/plugins/KtorPluginModel$Factory;", "", "<init>", "()V", "featureIdToModel", "Ljava/util/HashMap;", "", "Lcom/intellij/ktor/initializr/plugins/KtorPluginModel;", "Lkotlin/collections/HashMap;", "generatorApi", "Lcom/intellij/ktor/initializr/KtorGeneratorWebAPI;", "create", "feature", "Lcom/intellij/ktor/initializr/json/KtorPluginSearchResult;", "allPlugins", "", "findOrCreate", "findById", "featureId", "clearModels", "", "intellij.ktor"})
    public static final class Factory {
        @NotNull
        private final HashMap<String, KtorPluginModel> featureIdToModel = new HashMap();
        @NotNull
        private final KtorGeneratorWebAPI generatorApi = KtorGeneratorWebAPI.Companion.getInstance();

        @NotNull
        public final KtorPluginModel create(@NotNull KtorPluginSearchResult feature, @NotNull List<KtorPluginSearchResult> allPlugins) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter(allPlugins, (String)"allPlugins");
            KtorPluginModel model = new KtorPluginModel(feature, allPlugins, this.generatorApi, this, null);
            ((Map)this.featureIdToModel).put(feature.getId(), model);
            return model;
        }

        @NotNull
        public final KtorPluginModel findOrCreate(@NotNull KtorPluginSearchResult feature, @NotNull List<KtorPluginSearchResult> allPlugins) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter(allPlugins, (String)"allPlugins");
            KtorPluginModel ktorPluginModel = this.findById(feature.getId());
            if (ktorPluginModel == null) {
                ktorPluginModel = this.create(feature, allPlugins);
            }
            return ktorPluginModel;
        }

        @Nullable
        public final KtorPluginModel findById(@NotNull String featureId) {
            Intrinsics.checkNotNullParameter((Object)featureId, (String)"featureId");
            return this.featureIdToModel.get(featureId);
        }

        public final void clearModels() {
            this.featureIdToModel.clear();
        }
    }
}

