/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.events;

import com.intellij.jpa.jpb.model.core.ParentDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.messages.Topic;

public class ExceptionEvent {
    public static final Topic<Listener> TOPIC = Topic.create((String)"Exception event", Listener.class);
    protected Object source;
    protected Throwable throwable;
    protected @NlsContexts.NotificationTitle String caption;
    protected boolean notification;
    protected boolean rootCauseOnly;

    public ExceptionEvent(Object source2, Throwable throwable) {
        this(source2, throwable, null);
    }

    public ExceptionEvent(Object source2, Throwable throwable, @NlsContexts.NotificationTitle String caption) {
        this(source2, throwable, caption, true, true);
    }

    public ExceptionEvent(Object source2, Throwable throwable, boolean notification, boolean rootCauseOnly) {
        this(source2, throwable, null, notification, rootCauseOnly);
    }

    public ExceptionEvent(Object source2, Throwable throwable, @NlsContexts.NotificationTitle String caption, boolean notification, boolean rootCauseOnly) {
        this.source = source2;
        this.throwable = throwable;
        this.caption = caption;
        this.notification = notification;
        this.rootCauseOnly = rootCauseOnly;
    }

    public Object getSource() {
        return this.source;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @NlsContexts.NotificationTitle
    public String getCaption() {
        return this.caption;
    }

    public boolean isNotification() {
        return this.notification;
    }

    public boolean isRootCauseOnly() {
        return this.rootCauseOnly;
    }

    public void post(Project project) {
        ((Listener)project.getMessageBus().syncPublisher(TOPIC)).onException(this);
    }

    public static void subscribe(Project project, Listener listener) {
        project.getMessageBus().connect((Disposable)ParentDisposable.getInstance(project)).subscribe(TOPIC, (Object)listener);
    }

    public static interface Listener {
        public void onException(ExceptionEvent var1);
    }
}

