/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.entity.attr;

import com.google.common.collect.ComparisonChain;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.jpa.jpb.model.HCodeFragmentFactory;
import com.intellij.jpa.jpb.model.backend.enumd.indexing.EnumSearch;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.SimpleEnumPsiType;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.ui.entity.EntityAttributeContext;
import com.intellij.jpa.jpb.model.ui.entity.attr.EntityAttributeBean;
import com.intellij.jpa.jpb.model.ui.propertyform.FormValueModel;
import com.intellij.jpa.jpb.model.ui.swing.JpbComboBoxWithComment;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUiUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeTypeField
extends EditorComboBox {
    private final JpbComboBoxWithComment.ItemWithCommentTextRenderer<String> itemWithCommentTextRenderer;

    private AttributeTypeField(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            AttributeTypeField.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AttributeTypeField.$$$reportNull$$$0(1);
        }
        super(document, project, (FileType)JavaFileType.INSTANCE);
        JpbComboBoxWithComment.RenderSettings renderSettings = new JpbComboBoxWithComment.RenderSettings();
        renderSettings.setCommentProvider(fqn -> {
            String s = StringUtil.substringBeforeLast((String)fqn, (String)".");
            return s.equals(fqn) ? "" : s;
        });
        renderSettings.setTextProvider(fqn -> {
            String s = StringUtil.substringAfterLast((String)fqn, (String)".");
            return s == null ? fqn : s;
        });
        this.itemWithCommentTextRenderer = new JpbComboBoxWithComment.ItemWithCommentTextRenderer(renderSettings);
    }

    public static AttributeTypeField create(@NotNull PsiClass entityClass, @NotNull EntityAttributeContext context, final @NotNull EntityAttributeBean attributeItem, final @NotNull FormValueModel valueModel, final @NotNull Runnable triggerCommit) {
        if (entityClass == null) {
            AttributeTypeField.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AttributeTypeField.$$$reportNull$$$0(3);
        }
        if (attributeItem == null) {
            AttributeTypeField.$$$reportNull$$$0(4);
        }
        if (valueModel == null) {
            AttributeTypeField.$$$reportNull$$$0(5);
        }
        if (triggerCommit == null) {
            AttributeTypeField.$$$reportNull$$$0(6);
        }
        return new Builder((PsiElement)entityClass, context){

            @Override
            public EntityAttribute.MappingType getMappingType() {
                return attributeItem.getMappingType();
            }

            @Override
            public boolean isId() {
                return attributeItem.isId();
            }

            @Override
            public boolean isVersion() {
                return attributeItem.isVersion();
            }

            @Override
            public String getDefaultTypeFqn() {
                Datatypes.BasicDatatype defaultType;
                Object typeValue = valueModel.getValue();
                Datatypes.BasicDatatype basicDatatype = this.isId() ? Datatypes.BasicDatatype.Long : (defaultType = this.isVersion() ? Datatypes.BasicDatatype.Integer : Datatypes.BasicDatatype.String);
                if (typeValue instanceof Datatype) {
                    return ((Datatype)typeValue).getFqn();
                }
                if (this.getMappingType() == EntityAttribute.MappingType.DATATYPE) {
                    return defaultType.getFqn();
                }
                return "";
            }

            @Override
            @NotNull
            public FormValueModel getValueModel() {
                FormValueModel formValueModel = valueModel;
                if (formValueModel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return formValueModel;
            }

            @Override
            @NotNull
            public Runnable getTriggerCommit() {
                Runnable runnable = triggerCommit;
                if (runnable == null) {
                    1.$$$reportNull$$$0(1);
                }
                return runnable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/jpa/jpb/model/ui/entity/attr/AttributeTypeField$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueModel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTriggerCommit";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }.create();
    }

    public void addNotify() {
        super.addNotify();
        this.setRenderer((ListCellRenderer)((Object)this.itemWithCommentTextRenderer));
    }

    @Nullable
    private static Datatype convertPsiTypeToDatatype(PsiType migrationType, EntityAttribute.MappingType mappingType) {
        Datatypes.BasicDatatype basicDatatype;
        if (mappingType == EntityAttribute.MappingType.DATATYPE) {
            return Datatypes.BasicDatatype.getInstanceWrapIfNull(migrationType);
        }
        if (mappingType == EntityAttribute.MappingType.ELEMENT_COLLECTION && (basicDatatype = Datatypes.BasicDatatype.getInstanceStrict(migrationType.getCanonicalText())) != null) {
            return basicDatatype;
        }
        if (!(migrationType instanceof PsiClassType)) {
            return null;
        }
        PsiClass resolvedClass = ((PsiClassType)migrationType).resolve();
        if (resolvedClass == null) {
            return null;
        }
        if (mappingType == EntityAttribute.MappingType.ENUM) {
            return SimpleEnumPsiType.getInstance(resolvedClass);
        }
        if (mappingType == EntityAttribute.MappingType.EMBEDDED && EntityUtil.isEmbeddable(resolvedClass)) {
            return EntityPsi.getInstance(resolvedClass);
        }
        if (mappingType == EntityAttribute.MappingType.ASSOCIATION && EntityUtil.isEntity(resolvedClass)) {
            return EntityPsi.getInstance(resolvedClass);
        }
        if (mappingType == EntityAttribute.MappingType.ELEMENT_COLLECTION) {
            return EntityPsi.getInstance(resolvedClass);
        }
        return null;
    }

    private static List<String> getEnumTypes(PsiElement contextElement) {
        Project project = contextElement.getProject();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        EnumSearch enumSearch = EnumSearch.getInstance(project);
        return ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(enumSearch.getEnums(contextElement.getResolveScope())).filter(psiClass -> {
            PsiFile containingFile = psiClass.getContainingFile();
            return containingFile != null && containingFile.getVirtualFile() != null && projectScope.accept(containingFile.getVirtualFile());
        })).map(PsiClass::getQualifiedName).filter(Objects::nonNull)).sorted(String::compareTo)).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "triggerCommit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/ui/entity/attr/AttributeTypeField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class Builder {
        @NotNull
        protected final PsiElement contextElement;
        @NotNull
        protected final EntityAttributeContext myContext;

        public Builder(@NotNull PsiElement contextElement, @NotNull EntityAttributeContext context) {
            if (contextElement == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (!(contextElement instanceof PsiClass) && !(contextElement instanceof PsiDirectory)) {
                throw new IllegalStateException("Unsupported context element type: " + String.valueOf(contextElement.getClass()));
            }
            this.contextElement = contextElement;
            this.myContext = context;
        }

        public AttributeTypeField create() {
            Runnable triggerCommit;
            Document document;
            Project project = this.contextElement.getProject();
            final HCodeFragmentFactory codeFragmentFactory = HCodeFragmentFactory.getInstance(project);
            final EntityAttribute.MappingType mappingType = this.getMappingType();
            if (this.contextElement instanceof PsiClass) {
                document = codeFragmentFactory.createTypeCodeDocument((PsiClass)this.contextElement, (JavaCodeFragment.VisibilityChecker)new TypeVisibilityChecker(mappingType, this.myContext));
            } else if (this.contextElement instanceof PsiDirectory) {
                document = codeFragmentFactory.createTypeCodeDocument((PsiDirectory)this.contextElement, (JavaCodeFragment.VisibilityChecker)new TypeVisibilityChecker(mappingType, this.myContext));
            } else {
                throw new IllegalStateException("Unsupported context element type: " + String.valueOf(this.contextElement.getClass()));
            }
            final AttributeTypeField typeField = new AttributeTypeField(document, project);
            String defaultTypeFqn = this.getDefaultTypeFqn();
            ReadAction.nonBlocking(() -> {
                LinkedList<String> historyTypes = new LinkedList<String>();
                if (mappingType == EntityAttribute.MappingType.DATATYPE) {
                    Collection<Datatypes.BasicDatatype> basicDatatypes = this.isVersion() ? this.getVersionDatatypes() : this.getBasicDatatypes();
                    historyTypes.addAll(ContainerUtil.map(basicDatatypes, Datatypes.BasicDatatype::getFqn));
                } else if (mappingType == EntityAttribute.MappingType.EMBEDDED) {
                    historyTypes.addAll(this.getEmbeddableTypes());
                } else if (mappingType == EntityAttribute.MappingType.ASSOCIATION) {
                    historyTypes.addAll(this.getEntityTypes());
                } else if (mappingType == EntityAttribute.MappingType.ENUM) {
                    historyTypes.addAll(AttributeTypeField.getEnumTypes(this.contextElement));
                } else if (mappingType == EntityAttribute.MappingType.ELEMENT_COLLECTION) {
                    Collection<Datatypes.BasicDatatype> basicDatatypes = this.getBasicDatatypes();
                    historyTypes.addAll(this.getEmbeddableTypes());
                    historyTypes.addAll(ContainerUtil.map(basicDatatypes, Datatypes.BasicDatatype::getFqn));
                }
                historyTypes.remove(defaultTypeFqn);
                historyTypes.add(0, defaultTypeFqn);
                return historyTypes;
            }).finishOnUiThread(ModalityState.any(), historyTypes -> ApplicationManager.getApplication().invokeLater(() -> {
                if (mappingType == EntityAttribute.MappingType.DATATYPE) {
                    typeField.setHistory(ArrayUtil.toStringArray((Collection)historyTypes));
                } else {
                    typeField.setHistory((String[])((StreamEx)StreamEx.of((Collection)historyTypes).sorted((s1, s2) -> ComparisonChain.start().compareTrueFirst(s1.equals(defaultTypeFqn), s2.equals(defaultTypeFqn)).compare(s1, s2, String::compareTo).result())).toArray((Object[])ArrayUtil.EMPTY_STRING_ARRAY));
                }
            }, ModalityState.stateForComponent((Component)((Object)typeField)))).submit((Executor)AppExecutorUtil.getAppExecutorService());
            final FormValueModel valueModel = this.getValueModel();
            if (!defaultTypeFqn.isEmpty()) {
                typeField.setText(defaultTypeFqn);
                if (valueModel != null && valueModel.getValue() == null) {
                    Datatypes.BasicDatatype defaultType = Datatypes.BasicDatatype.createUnsafe(defaultTypeFqn);
                    valueModel.setValue(defaultType);
                }
            }
            if (valueModel != null) {
                typeField.addDocumentListener(new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent event) {
                        Component rootPane;
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((rootPane = SwingUtilities.getRoot((Component)((Object)typeField))) != null && rootPane.isShowing()) {
                            PsiType migrationType = codeFragmentFactory.getMigrationType(document);
                            if (migrationType == null) {
                                valueModel.setValue(null);
                            } else {
                                ReadAction.nonBlocking(() -> AttributeTypeField.convertPsiTypeToDatatype(migrationType, mappingType)).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.current(), convertedType -> valueModel.setValue(convertedType)).submit((Executor)AppExecutorUtil.getAppExecutorService());
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/jpa/jpb/model/ui/entity/attr/AttributeTypeField$Builder$1", "documentChanged"));
                    }
                });
            }
            if ((triggerCommit = this.getTriggerCommit()) != null) {
                typeField.addFocusListener(new FocusAdapter(this){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (!e.isTemporary()) {
                            triggerCommit.run();
                        }
                    }
                });
                JpaUiUtil.setEnterKeyListener((JComponent)((Object)typeField), triggerCommit);
            }
            return typeField;
        }

        protected Collection<Datatypes.BasicDatatype> getBasicDatatypes() {
            if (this.isId()) {
                return Datatypes.BasicDatatype.popularIdTypes();
            }
            ArrayList<Datatypes.BasicDatatype> basicDatatypes = new ArrayList<Datatypes.BasicDatatype>(Datatypes.BasicDatatype.values());
            if (JpaUtils.isHibernate6Project(this.contextElement.getProject(), null)) {
                basicDatatypes.add(Datatypes.BasicDatatype.InetAddress);
                basicDatatypes.add(Datatypes.BasicDatatype.ZoneOffset);
            }
            return basicDatatypes;
        }

        protected Collection<Datatypes.BasicDatatype> getVersionDatatypes() {
            return Datatypes.BasicDatatype.versionTypes();
        }

        protected Collection<Datatypes.BasicDatatype> getDateAuditDatatypes() {
            return Datatypes.BasicDatatype.dateAuditTypes();
        }

        protected List<String> getEntityTypes() {
            return this.getEntityTypes(this.contextElement, it -> !this.myContext.getOrmFramework().equals(JpaOrmFramework.INSTANCE) || EntityUtil.isPersistentEntity(it));
        }

        protected List<String> getEmbeddableTypes() {
            if (!this.myContext.getOrmFramework().equals(JpaOrmFramework.INSTANCE)) {
                return List.of();
            }
            return this.getEntityTypes(this.contextElement, EntityUtil::isEmbeddable);
        }

        protected List<String> getEntityTypes(PsiElement contextElement, Function<PsiClass, Boolean> filter) {
            OrmUnitsProvider unitsProvider = OrmUnitsProvider.Companion.getEP_NAME().getExtensionList().stream().filter(it -> it.getFramework().equals(this.myContext.getOrmFramework())).findFirst().orElseThrow();
            return unitsProvider.getUnits(contextElement.getProject()).stream().flatMap(it -> it.getEntities().stream()).map(it -> it.getClassPsiPointer()).filter(it -> it != null).map(it -> (PsiClass)it.getElement()).filter(it -> it != null && (Boolean)filter.apply((PsiClass)it) != false).map(it -> it.getQualifiedName()).distinct().toList();
        }

        public abstract EntityAttribute.MappingType getMappingType();

        public abstract boolean isId();

        public boolean isVersion() {
            return false;
        }

        public abstract String getDefaultTypeFqn();

        @Nullable
        public FormValueModel getValueModel() {
            return null;
        }

        @Nullable
        public Runnable getTriggerCommit() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contextElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jpa/jpb/model/ui/entity/attr/AttributeTypeField$Builder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TypeVisibilityChecker
    implements JavaCodeFragment.VisibilityChecker {
        private final EntityAttribute.MappingType mappingType;
        private final EntityAttributeContext myContext;

        private TypeVisibilityChecker(EntityAttribute.MappingType mappingType, EntityAttributeContext context) {
            this.mappingType = mappingType;
            this.myContext = context;
        }

        public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
            if (!(declaration instanceof PsiClass)) {
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
            PsiClass psiClass = (PsiClass)declaration;
            if (psiClass.isAnnotationType() || psiClass.hasModifierProperty("private")) {
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
            boolean isVisible = false;
            boolean isEnum = psiClass.isEnum();
            boolean isEntity = EntityUtil.isEntity(psiClass) || !this.myContext.getOrmFramework().equals(JpaOrmFramework.INSTANCE);
            boolean isEmbeddable = EntityUtil.isEmbeddable(psiClass);
            if (this.mappingType == EntityAttribute.MappingType.DATATYPE) {
                isVisible = !isEnum && !isEntity;
            } else if (this.mappingType == EntityAttribute.MappingType.ASSOCIATION) {
                isVisible = isEntity && !isEmbeddable;
            } else if (this.mappingType == EntityAttribute.MappingType.EMBEDDED) {
                isVisible = isEmbeddable;
            } else if (this.mappingType == EntityAttribute.MappingType.ELEMENT_COLLECTION) {
                isVisible = isEmbeddable || !isEntity;
            } else if (this.mappingType == EntityAttribute.MappingType.ENUM) {
                isVisible = isEnum;
            }
            return isVisible ? JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE : JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }
    }
}

