/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.ptable;

import com.intellij.jpa.jpb.model.ui.ptable.PTableGroupImpl;
import com.intellij.jpa.jpb.model.ui.ptable.PTableGroupItem;
import com.intellij.jpa.jpb.model.ui.ptable.PTableItem;
import com.intellij.jpa.jpb.model.ui.ptable.StatelessItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.AbstractTableModel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class PTableModel
extends AbstractTableModel {
    private List<PTableItem<?>> myItems;
    private Project myProject;
    private final String[] columnNames = new String[]{"Property", "Value"};

    public PTableModel(Project project) {
        this.myProject = project;
        this.myItems = Collections.emptyList();
    }

    public void setItems(@NotNull List<PTableItem<?>> items2) {
        if (items2 == null) {
            PTableModel.$$$reportNull$$$0(0);
        }
        Set<PTableItem> openGroups = this.findOpenGroups(this.myItems);
        openGroups.addAll(((StreamEx)StreamEx.of(items2).flatMap(this::flatItem).select(PTableGroupImpl.class).filter(PTableGroupImpl::getNeedToExpand)).toList());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List resolvedItems2 = ContainerUtil.map(items2, PTableItem::resolveValue);
            this.myItems = new ArrayList(resolvedItems2);
            this.restoreOpenGroups(openGroups);
            this.fireTableDataChanged();
        } else {
            ReadAction.nonBlocking(() -> ContainerUtil.map((Collection)items2, PTableItem::resolveValue)).coalesceBy(new Object[]{this}).inSmartMode(this.myProject).finishOnUiThread(ModalityState.current(), resolvedItems -> {
                this.myItems = new ArrayList((Collection<PTableItem<?>>)resolvedItems);
                this.restoreOpenGroups(openGroups);
                this.fireTableDataChanged();
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private StreamEx<PTableItem<?>> flatItem(PTableItem<?> item) {
        StreamEx flattenChildren = StreamEx.of(item.getChildren()).flatMap(this::flatItem);
        return (StreamEx)StreamEx.of(item).append((Stream)flattenChildren);
    }

    public void moveUp(int row) {
        int insertIndex;
        if (row == 0) {
            throw new IllegalArgumentException();
        }
        PTableItem<?> item = this.myItems.get(row);
        PTableItem parent = item.getParent();
        if (parent instanceof PTableGroupItem) {
            PTableGroupItem group = (PTableGroupItem)parent;
            int indexInGroup = group.getChildren().indexOf(item);
            if (indexInGroup == 0) {
                throw new IllegalArgumentException();
            }
            group.deleteChild(item);
            group.addChild(indexInGroup - 1, item);
        }
        ArrayList itemsToMove = new ArrayList();
        itemsToMove.add(this.myItems.remove(row));
        while (this.myItems.size() > row && this.isDeepInheritor(this.myItems.get(row), item)) {
            itemsToMove.add(this.myItems.remove(row));
        }
        for (insertIndex = row - 1; insertIndex > 0 && this.myItems.get(insertIndex).getParent() != parent; --insertIndex) {
        }
        this.myItems.addAll(insertIndex, itemsToMove);
        this.fireTableStructureChanged();
    }

    public void moveDown(int row) {
        int insertIndex;
        if (row == this.myItems.size() - 1) {
            throw new IllegalArgumentException();
        }
        PTableItem<?> item = this.myItems.get(row);
        PTableItem parent = item.getParent();
        if (parent instanceof PTableGroupItem) {
            PTableGroupItem group = (PTableGroupItem)parent;
            int indexInGroup = group.getChildren().indexOf(item);
            if (indexInGroup == group.getChildren().size()) {
                throw new IllegalArgumentException();
            }
            group.deleteChild(item);
            group.addChild(indexInGroup + 1, item);
        }
        ArrayList itemsToMove = new ArrayList();
        itemsToMove.add(this.myItems.remove(row));
        while (this.myItems.size() > row && this.isDeepInheritor(this.myItems.get(row), item)) {
            itemsToMove.add(this.myItems.remove(row));
        }
        PTableItem<?> nextSibling = this.myItems.get(row);
        for (insertIndex = row + 1; insertIndex < this.myItems.size() && this.isDeepInheritor(this.myItems.get(insertIndex), nextSibling); ++insertIndex) {
        }
        this.myItems.addAll(insertIndex, itemsToMove);
        this.fireTableStructureChanged();
    }

    private boolean isDeepInheritor(PTableItem item, PTableItem parent) {
        do {
            if (!item.equals(parent)) continue;
            return true;
        } while ((item = item.getParent()) != null);
        return false;
    }

    public void insertRow(int row, @NotNull PTableItem item) {
        if (item == null) {
            PTableModel.$$$reportNull$$$0(1);
        }
        ReadAction.nonBlocking(() -> item.resolveValue()).coalesceBy(new Object[]{this}).inSmartMode(this.myProject).finishOnUiThread(ModalityState.current(), resolvedItem -> {
            this.myItems.add(row, (PTableItem<?>)resolvedItem);
            this.fireTableRowsInserted(row, row);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void deleteRow(int row) {
        this.myItems.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.myItems.get(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PTableItem<?> tableItem = this.myItems.get(row);
        ApplicationManager.getApplication().invokeLater(() -> {
            tableItem.setValue(value);
            ReadAction.nonBlocking(() -> tableItem.resolveValue()).coalesceBy(new Object[]{this}).inSmartMode(this.myProject).finishOnUiThread(ModalityState.current(), resolvedItem -> this.fireTableCellUpdated(row, col)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        });
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.myItems.get(row).isEditable(col);
    }

    public void collapse(int row) {
        this._collapse(row);
        this.fireTableDataChanged();
    }

    private void _collapse(int row) {
        if (row >= this.myItems.size()) {
            return;
        }
        PTableItem<?> item = this.myItems.get(row);
        if (item.hasChildren() && item.isExpanded()) {
            item.setExpanded(false);
            List<PTableItem> children = item.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this._collapse(row + 1);
                this.myItems.remove(row + 1);
            }
        }
    }

    public int getParent(int row) {
        if (row >= this.myItems.size()) {
            return row;
        }
        PTableItem<?> item = this.myItems.get(row);
        if (item.getParent() == null) {
            return row;
        }
        PTableItem parent = item.getParent();
        while (--row >= 0 && this.myItems.get(row) != parent) {
        }
        return row;
    }

    public void expand(int row) {
        this.expandWithoutNotifying(row);
        this.fireTableDataChanged();
    }

    private void expandWithoutNotifying(int row) {
        if (row >= this.myItems.size()) {
            return;
        }
        PTableItem<?> item = this.myItems.get(row);
        if (item.hasChildren() && !item.isExpanded()) {
            item.setExpanded(true);
            List<PTableItem> children = item.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.myItems.add(row + 1 + i, children.get(i));
            }
        }
    }

    @NotNull
    private Set<PTableItem> findOpenGroups(@NotNull List<PTableItem<?>> items2) {
        if (items2 == null) {
            PTableModel.$$$reportNull$$$0(2);
        }
        Set<PTableItem> set = items2.stream().filter(PTableItem::isExpanded).filter(it -> !(it instanceof StatelessItem)).collect(Collectors.toSet());
        if (set == null) {
            PTableModel.$$$reportNull$$$0(3);
        }
        return set;
    }

    private void restoreOpenGroups(@NotNull Set<PTableItem> openGroups) {
        if (openGroups == null) {
            PTableModel.$$$reportNull$$$0(4);
        }
        for (int row = 0; row < this.myItems.size(); ++row) {
            PTableItem<?> item = this.myItems.get(row);
            if (!openGroups.contains(item)) continue;
            this.expandWithoutNotifying(row);
        }
    }

    @TestOnly
    public List<PTableItem<?>> getItems() {
        return Collections.unmodifiableList(this.myItems);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/ptable/PTableModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/ptable/PTableModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findOpenGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findOpenGroups";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreOpenGroups";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

