/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MetadataDatatype {
    BOOLEAN(Boolean.class.getName()),
    DATE(Date.class.getName()),
    DATE_TIME(Date.class.getName()),
    BIG_DECIMAL(BigDecimal.class.getName()),
    CURRENCY(BigDecimal.class.getName()),
    DOUBLE(Double.class.getName()),
    INTEGER(Integer.class.getName()),
    LONG(Long.class.getName()),
    STRING(String.class.getName()),
    TIME(Date.class.getName()),
    UUID(UUID.class.getName()),
    CLASS(""),
    ENUM("");

    private String fqn;

    private MetadataDatatype(String fqn) {
        this.fqn = fqn;
    }

    public String getFqn() {
        return this.fqn;
    }

    @NotNull
    public static MetadataDatatype findByTemporalValue(@Nullable String value) {
        if ("DateTime".equals(value) || "TemporalType.DateTime".equals(value)) {
            MetadataDatatype metadataDatatype = DATE_TIME;
            if (metadataDatatype == null) {
                MetadataDatatype.$$$reportNull$$$0(0);
            }
            return metadataDatatype;
        }
        if ("DATE".equals(value) || "TemporalType.DATE".equals(value)) {
            MetadataDatatype metadataDatatype = DATE;
            if (metadataDatatype == null) {
                MetadataDatatype.$$$reportNull$$$0(1);
            }
            return metadataDatatype;
        }
        if ("TIME".equals(value) || "TemporalType.TIME".equals(value)) {
            MetadataDatatype metadataDatatype = TIME;
            if (metadataDatatype == null) {
                MetadataDatatype.$$$reportNull$$$0(2);
            }
            return metadataDatatype;
        }
        MetadataDatatype metadataDatatype = DATE;
        if (metadataDatatype == null) {
            MetadataDatatype.$$$reportNull$$$0(3);
        }
        return metadataDatatype;
    }

    @Nullable
    public static MetadataDatatype findByFqn(String fqn) {
        for (MetadataDatatype datatype : MetadataDatatype.values()) {
            if (!fqn.equals(datatype.getFqn())) continue;
            return datatype;
        }
        return null;
    }

    public boolean isNumber() {
        return this == LONG || this == INTEGER || this == DOUBLE || this == BIG_DECIMAL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/jpb/model/util/MetadataDatatype", "findByTemporalValue"));
    }
}

