/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jpa/jpb/model/util/SourceLanguageUtil;", "", "<init>", "()V", "getLanguage", "Lcom/intellij/jpa/jpb/model/model/SourceLanguage;", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageNN", "getLastSelectedLanguage", "getSupportedLanguages", "", "memorizeLastSelectedLanguage", "", "sourceLanguage", "intellij.javaee.jpa.jpb.model"})
public final class SourceLanguageUtil {
    @NotNull
    public static final SourceLanguageUtil INSTANCE = new SourceLanguageUtil();

    private SourceLanguageUtil() {
    }

    @Nullable
    public final SourceLanguage getLanguage(@NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!JpaUtils.isKotlinSupport(project)) {
            object = SourceLanguage.JAVA;
        } else {
            object = JpaPluginProjectConfig.Companion.getInstance(project);
            if (object == null || (object = ((JpaPluginProjectConfig)object).getState()) == null || (object = ((ProjectState)object).getScaffoldingLanguage()) == null) {
                object = this.getLastSelectedLanguage(project);
            }
        }
        return object;
    }

    @NotNull
    public final SourceLanguage getLanguageNN(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SourceLanguage sourceLanguage = this.getLanguage(project);
        if (sourceLanguage == null) {
            sourceLanguage = SourceLanguage.JAVA;
        }
        return sourceLanguage;
    }

    private final SourceLanguage getLastSelectedLanguage(Project project) {
        Object object = JpaPluginProjectConfig.Companion.getInstance(project);
        return object != null && (object = ((JpaPluginProjectConfig)object).getState()) != null ? ((ProjectState)object).getLastSelectedLanguage() : null;
    }

    @NotNull
    public final List<SourceLanguage> getSupportedLanguages(@NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List $this$getSupportedLanguages_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getSupportedLanguages_u24lambda_u240.add(SourceLanguage.JAVA);
        if (JpaUtils.isKotlinSupport(project)) {
            $this$getSupportedLanguages_u24lambda_u240.add(SourceLanguage.KOTLIN);
        }
        return CollectionsKt.build((List)list);
    }

    public final void memorizeLastSelectedLanguage(@NotNull Project project, @NotNull SourceLanguage sourceLanguage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)sourceLanguage), (String)"sourceLanguage");
            ProjectState.ScaffoldingLanguage language = ProjectState.ScaffoldingLanguage.fromSourceLanguage(sourceLanguage);
            Object object = JpaPluginProjectConfig.Companion.getInstance(project);
            if (object == null || (object = ((JpaPluginProjectConfig)object).getState()) == null) break block0;
            ((ProjectState)object).lastSelectedLanguage = language;
        }
    }
}

