/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"AUTH_MECHANISM", "", "supportsMongoAuthViaJdbcParameters", "", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getMongoApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "authMechanism", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoDatabaseCredentialsAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoDatabaseCredentialsAuthProvider.kt\ncom/intellij/database/dialects/mongo/MongoDatabaseCredentialsAuthProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class MongoDatabaseCredentialsAuthProviderKt {
    @NotNull
    public static final String AUTH_MECHANISM = "authMechanism";

    public static final boolean supportsMongoAuthViaJdbcParameters(@NotNull DatabaseConnectionPoint point) {
        int[] nArray;
        Version artifactVersion;
        Dbms dbms;
        Dbms dbms2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Dbms it = dbms2 = point.getDbms();
        boolean bl = false;
        Object object = !it.eq(Dbms.UNKNOWN) ? dbms2 : null;
        if (object == null) {
            Dbms dbms3 = DbImplUtilCore.getDbms((DatabaseDriver)point.getDatabaseDriver());
            object = dbms3;
            Intrinsics.checkNotNullExpressionValue((Object)dbms3, (String)"getDbms(...)");
        }
        if (!(dbms = object).eq(Dbms.MONGO)) {
            return false;
        }
        List list = point.getDatabaseDriver().getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArtifacts(...)");
        DatabaseDriver.ArtifactRef artifactRef = (DatabaseDriver.ArtifactRef)CollectionsKt.firstOrNull((List)list);
        Object object2 = artifactVersion = artifactRef != null ? artifactRef.getArtifactVersion() : null;
        return artifactVersion == null || artifactVersion.isOrGreater(nArray = new int[]{1, 16});
    }

    @NotNull
    public static final DatabaseAuthProvider.ApplicabilityLevel.Result getMongoApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level, @NotNull String authMechanism) {
        JdbcUrlParser parsed;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)authMechanism, (String)AUTH_MECHANISM);
        if (!MongoDatabaseCredentialsAuthProviderKt.supportsMongoAuthViaJdbcParameters(point)) {
            return DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE;
        }
        if (level.compareTo((Enum)DatabaseAuthProvider.ApplicabilityLevel.PREFERRED) < 0) {
            return DatabaseAuthProvider.ApplicabilityLevel.Result.APPLICABLE.clamp(level);
        }
        JdbcUrlParser jdbcUrlParser = parsed = JdbcUrlParserUtil.parsed((RawConnectionConfig)((RawConnectionConfig)point));
        return StringUtil.equalsIgnoreCase((CharSequence)(jdbcUrlParser != null ? jdbcUrlParser.getParameter(AUTH_MECHANISM) : null), (CharSequence)authMechanism) ? DatabaseAuthProvider.ApplicabilityLevel.Result.PREFERRED : DatabaseAuthProvider.ApplicabilityLevel.Result.APPLICABLE;
    }
}

