/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipOperandsFix
extends AbstractFix {
    private final XPathBinaryExpression myExpression;
    private final XPathToken myToken;

    public FlipOperandsFix(XPathToken token) {
        this.myToken = token;
        this.myExpression = (XPathBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)token, XPathBinaryExpression.class);
    }

    @NotNull
    public String getText() {
        String string = XPathBundle.message("intention.name.flip.binary.expression.to", this.myToken.getText(), this.myToken.getText().replace('<', '>'));
        if (string == null) {
            FlipOperandsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.flip.binary.expression", new Object[0]);
        if (string == null) {
            FlipOperandsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            FlipOperandsFix.$$$reportNull$$$0(2);
        }
        return this.myExpression != null && this.myExpression.isValid() && this.myExpression.getType() == XPathType.BOOLEAN && this.myExpression.getROperand() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            FlipOperandsFix.$$$reportNull$$$0(3);
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)this.myToken, XmlAttribute.class, (boolean)true);
        assert (attribute != null);
        XPathFile f = XPathChangeUtil.createXPathFile(this.myToken, FlipOperandsFix.getOperandText(this.myExpression.getROperand()) + " " + this.myToken.getText().replace('<', '>') + " " + FlipOperandsFix.getOperandText(this.myExpression.getLOperand()));
        PsiElement firstChild = f.getFirstChild();
        assert (firstChild != null);
        this.myExpression.replace(firstChild);
    }

    private static String getOperandText(XPathExpression operand) {
        return operand != null ? operand.getText() : "";
    }

    @Override
    protected boolean requiresEditor() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            FlipOperandsFix.$$$reportNull$$$0(4);
        }
        return new FlipOperandsFix((XPathToken)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myToken, (PsiFile)target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/FlipOperandsFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/FlipOperandsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

