/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.support.jaxen;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlToken;
import org.intellij.plugins.xpathView.support.jaxen.NodeIterator;

class PsiChildAxisIterator
extends NodeIterator {
    PsiChildAxisIterator(Object contextNode) {
        super((PsiElement)contextNode);
    }

    @Override
    protected PsiElement getFirstNode(PsiElement contextNode) {
        PsiElement n = contextNode.getFirstChild();
        n = PsiChildAxisIterator.skipToXmlElement(n);
        return n;
    }

    @Override
    protected PsiElement getNextNode(PsiElement contextNode) {
        PsiElement n = contextNode.getNextSibling();
        n = PsiChildAxisIterator.skipToXmlElement(n);
        return n;
    }

    private static PsiElement skipToXmlElement(PsiElement n) {
        while (n != null && (!PsiChildAxisIterator.isXmlElement(n) || PsiChildAxisIterator.isXmlToken(n) || PsiChildAxisIterator.isAttribute(n))) {
            n = n.getNextSibling();
        }
        return n;
    }

    private static boolean isAttribute(PsiElement n) {
        return n instanceof XmlAttribute;
    }

    private static boolean isXmlElement(PsiElement n) {
        return n instanceof XmlElement || n instanceof PsiWhiteSpace;
    }

    private static boolean isXmlToken(PsiElement n) {
        return n instanceof XmlToken;
    }
}

