/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.ruby;

import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultilineSupporter;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/inline/completion/ruby/RubyMultilineSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultilineSupporter;", "<init>", "()V", "parentClasses", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "[Ljava/lang/Class;", "isMultilineSuitable", "", "element", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "findCompoundStatement", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/blocks/RCompoundStatement;", "parent", "findParent", "intellij.fullLine.ruby"})
@SourceDebugExtension(value={"SMAP\nRubyMultilineSupporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyMultilineSupporter.kt\ncom/intellij/ml/inline/completion/ruby/RubyMultilineSupporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n320#2,7:81\n66#3,2:88\n1#4:90\n*S KotlinDebug\n*F\n+ 1 RubyMultilineSupporter.kt\ncom/intellij/ml/inline/completion/ruby/RubyMultilineSupporter\n*L\n41#1:81,7\n56#1:88,2\n*E\n"})
public final class RubyMultilineSupporter
implements MLCompletionMultilineSupporter {
    @NotNull
    private final Class<? extends PsiElement>[] parentClasses;

    public RubyMultilineSupporter() {
        Class[] classArray = new Class[]{RArgumentList.class, RBlockStatement.class, RCodeBlock.class, RConditionalStatement.class, RContainer.class, RFile.class, RListOfExpressions.class};
        this.parentClasses = classArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMultilineSuitable(@NotNull PsiElement element, @NotNull Document document, int offset) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!DocumentUtil.isAtLineEnd((int)offset, (Document)document)) {
            return false;
        }
        PsiElement psiElement2 = this.findParent(element);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement parent = psiElement2;
        RCompoundStatement compoundStatement = this.findCompoundStatement(element, parent);
        if (compoundStatement == null) {
            return PsiTreeUtil.hasErrorElements((PsiElement)parent);
        }
        PsiElement statement = PsiTreeUtilKt.isAncestor$default((PsiElement)((PsiElement)compoundStatement), (PsiElement)element, (boolean)false, (int)2, null) ? PsiTreeUtil.findPrevParent((PsiElement)((PsiElement)compoundStatement), (PsiElement)element) : null;
        List list2 = compoundStatement.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        RPsiElement rPsiElement = (RPsiElement)CollectionsKt.lastOrNull((List)list2);
        if (rPsiElement != null && (rPsiElement = PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)rPsiElement), (boolean)false, (boolean)false, (int)3, null)) != null) {
            RPsiElement $this$lastOrNull$iv = rPsiElement;
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiWhiteSpace))) continue;
                last$iv = element$iv;
            }
            psiElement = last$iv;
        } else {
            psiElement = null;
        }
        PsiElement lastStatement = psiElement;
        PsiElement psiElement3 = parent;
        if (psiElement3 instanceof RFile) {
            if (statement == null) return true;
            if (statement.getNextSibling() == null) return true;
            if (!(statement.getNextSibling() instanceof RContainer)) return false;
            return true;
        }
        if (psiElement3 instanceof RArgumentList) {
            if (((RArgumentList)parent).getArguments().isEmpty()) return true;
            List list3 = ((RArgumentList)parent).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getArguments(...)");
            Object object = CollectionsKt.last((List)list3);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            if (PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object)) > offset) return false;
            return true;
        }
        if (psiElement3 instanceof RConditionalStatement) {
            if (parent instanceof RModifierStatement) return false;
            if (lastStatement == null) return true;
            if (PsiTreeUtilKt.getEndOffset((PsiElement)lastStatement) > offset) return false;
            return true;
        }
        if (psiElement3 instanceof RBlockStatement || psiElement3 instanceof RCodeBlock || psiElement3 instanceof RMethod) {
            if (lastStatement == null) return true;
            if (PsiTreeUtilKt.getEndOffset((PsiElement)lastStatement) > offset) return false;
            return true;
        }
        if (psiElement3 instanceof RContainer) {
            return true;
        }
        if (!(psiElement3 instanceof RListOfExpressions)) return false;
        if (((RListOfExpressions)parent).getElements().isEmpty()) return true;
        List list4 = ((RListOfExpressions)parent).getElements();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getElements(...)");
        Object object = CollectionsKt.last((List)list4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        if (PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object)) > offset) return false;
        return true;
    }

    private final RCompoundStatement findCompoundStatement(PsiElement element, PsiElement parent) {
        Object object;
        RCompoundStatement compoundStatement;
        PsiElement leaf;
        PsiElement psiElement = element instanceof PsiWhiteSpace ? PsiTreeUtilKt.prevLeaf((PsiElement)element, (boolean)true) : element;
        if (psiElement == null) {
            psiElement = element;
        }
        PsiElement $this$parentOfType_u24default$iv = leaf = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        RCompoundStatement rCompoundStatement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RCompoundStatement.class, (boolean)true);
        if (rCompoundStatement != null) {
            RCompoundStatement rCompoundStatement2;
            RCompoundStatement it = rCompoundStatement2 = rCompoundStatement;
            boolean bl = false;
            v2 = PsiTreeUtilKt.isAncestor$default((PsiElement)parent, (PsiElement)((PsiElement)it), (boolean)false, (int)2, null) ? rCompoundStatement2 : null;
        } else {
            v2 = compoundStatement = null;
        }
        if (compoundStatement != null) {
            return compoundStatement;
        }
        PsiElement psiElement2 = parent;
        if (psiElement2 instanceof RArgumentList) {
            RMethod rMethod = RMethodNavigator.getByParameters((RArgumentList)((RArgumentList)parent));
            object = rMethod != null ? rMethod.getCompoundStatement() : null;
        } else {
            object = psiElement2 instanceof RCodeBlock ? ((RCodeBlock)parent).getCompoundStatement() : (psiElement2 instanceof RContainer ? ((RContainer)parent).getCompoundStatement() : null);
        }
        return object;
    }

    private final PsiElement findParent(PsiElement element) {
        Class<? extends PsiElement>[] classArray;
        PsiElement previous = element instanceof PsiWhiteSpace ? PsiTreeUtil.prevVisibleLeaf((PsiElement)element) : element;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)previous, (boolean)true, (Class[])Arrays.copyOf(classArray = this.parentClasses, classArray.length));
        if (parent instanceof RListOfExpressions && !Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)((RListOfExpressions)parent).getNextSibling()), (Object)RubyTokenTypes.tRPAREN)) {
            return this.findParent(parent);
        }
        return parent;
    }
}

