/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug;

import com.intellij.kubernetes.debug.KubectlDebugParameters;
import com.intellij.kubernetes.debug.recents.KubectlDebugRecentParametersTemplate;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerServiceViewDescriptor;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEphemeralContainerObjectImpl;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesCreateActionsUtilKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.registry.Registry;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0000\u001a$\u0010\u0012\u001a\u00020\u0011*\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u001a%\u0010\u0016\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0002\"\u0018\u0010\r\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"isKubectlDebugSupportEnabled", "", "()Z", "getSelectedPodAndContainer", "Lkotlin/Pair;", "Lio/kubernetes/client/openapi/models/V1Pod;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getContainersExceptEphemeral", "", "Lio/kubernetes/client/openapi/models/V1Container;", "pod", "isEphemeral", "(Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;)Z", "toRecent", "Lcom/intellij/kubernetes/debug/recents/KubectlDebugRecentParametersTemplate;", "Lcom/intellij/kubernetes/debug/KubectlDebugParameters;", "toNormal", "namespace", "", "target", "calculateDebugParametersTemplateName", "Lcom/intellij/openapi/util/NlsSafe;", "imageName", "optionalParameters", "executable", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubectlDebugUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubectlDebugUtils.kt\ncom/intellij/kubernetes/debug/KubectlDebugUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1869#2:66\n1870#2:68\n1869#2,2:69\n1#3:67\n*S KotlinDebug\n*F\n+ 1 KubectlDebugUtils.kt\ncom/intellij/kubernetes/debug/KubectlDebugUtilsKt\n*L\n30#1:66\n30#1:68\n33#1:69,2\n*E\n"})
public final class KubectlDebugUtilsKt {
    public static final boolean isKubectlDebugSupportEnabled() {
        return Registry.Companion.get("kubernetes.kubectl.debug.support.enabled").asBoolean();
    }

    @NotNull
    public static final Pair<V1Pod, KubernetesContainerObject> getSelectedPodAndContainer(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        V1Pod v1Pod = (V1Pod)ActionUtilsKt.getKubernetesResourceOrNull((AnActionEvent)event);
        if (v1Pod != null) {
            V1Pod it = v1Pod;
            boolean bl = false;
            return new Pair((Object)it, null);
        }
        KubernetesContainerServiceViewDescriptor kubernetesContainerServiceViewDescriptor = KubernetesCreateActionsUtilKt.getSelectedContainerDescriptor((AnActionEvent)event);
        if (kubernetesContainerServiceViewDescriptor != null && (kubernetesContainerServiceViewDescriptor = kubernetesContainerServiceViewDescriptor.getResource()) != null) {
            KubernetesContainerServiceViewDescriptor it = kubernetesContainerServiceViewDescriptor;
            boolean bl = false;
            return new Pair((Object)it.getParentPod(), (Object)it);
        }
        return new Pair(null, null);
    }

    @NotNull
    public static final List<V1Container> getContainersExceptEphemeral(@NotNull V1Pod pod) {
        List containers;
        block3: {
            Object object;
            V1Container container;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
            containers = new ArrayList();
            Object object2 = pod.getSpec();
            if (object2 != null && (object2 = object2.getContainers()) != null) {
                $this$forEach$iv = (Iterable)object2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    container = (V1Container)element$iv;
                    boolean bl = false;
                    if (container.getName() == null) continue;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)container);
                    containers.add(container);
                }
            }
            if ((object = pod.getSpec()) == null || (object = object.getInitContainers()) == null) break block3;
            $this$forEach$iv = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                container = (V1Container)element$iv;
                boolean bl = false;
                if (container.getName() == null) continue;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)container);
                containers.add(container);
            }
        }
        return containers;
    }

    public static final boolean isEphemeral(@NotNull KubernetesContainerObject $this$isEphemeral) {
        Intrinsics.checkNotNullParameter((Object)$this$isEphemeral, (String)"<this>");
        return $this$isEphemeral instanceof KubernetesEphemeralContainerObjectImpl;
    }

    @NotNull
    public static final KubectlDebugRecentParametersTemplate toRecent(@NotNull KubectlDebugParameters $this$toRecent) {
        Intrinsics.checkNotNullParameter((Object)$this$toRecent, (String)"<this>");
        return new KubectlDebugRecentParametersTemplate($this$toRecent.getImage(), $this$toRecent.getOptionalParameters(), $this$toRecent.getExecutable());
    }

    @NotNull
    public static final KubectlDebugParameters toNormal(@NotNull KubectlDebugRecentParametersTemplate $this$toNormal, @NotNull String namespace, @NotNull String pod, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)$this$toNormal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new KubectlDebugParameters(namespace, pod, target, $this$toNormal.getImage(), $this$toNormal.getOptionalParameters(), $this$toNormal.getExecutable());
    }

    @NotNull
    public static final String calculateDebugParametersTemplateName(@NotNull String imageName, @NotNull String optionalParameters, @NotNull String executable) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        Intrinsics.checkNotNullParameter((Object)optionalParameters, (String)"optionalParameters");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        return imageName + " " + optionalParameters + " -- " + executable;
    }
}

