/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.runtime;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.runtime.SpringRuntimeResourceContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spring/runtime/SpringRuntimeResourceContextBase;", "Lcom/intellij/spring/runtime/SpringRuntimeResourceContext;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "runConfigurationElement", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "workingDirectory", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getWorkingDirectory", "()Ljava/lang/String;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getRunConfigurationElement", "()Lcom/intellij/psi/PsiElement;", "intellij.spring.core.shared"})
public final class SpringRuntimeResourceContextBase
implements SpringRuntimeResourceContext {
    @NotNull
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final GlobalSearchScope searchScope;
    @NotNull
    private final String workingDirectory;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> pointer;

    public SpringRuntimeResourceContextBase(@NotNull Project project, @Nullable Module module, @Nullable PsiElement runConfigurationElement, @NotNull GlobalSearchScope searchScope, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        this.project = project;
        this.module = module;
        this.searchScope = searchScope;
        this.workingDirectory = workingDirectory;
        this.pointer = runConfigurationElement == null ? null : SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer(runConfigurationElement);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.module;
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public final SmartPsiElementPointer<PsiElement> getPointer() {
        return this.pointer;
    }

    @Override
    @Nullable
    public PsiElement getRunConfigurationElement() {
        SmartPsiElementPointer<PsiElement> smartPsiElementPointer = this.pointer;
        return smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
    }
}

