/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class ExprUnary
extends Expr {
    public static final int MINUS = 0;
    public static final int NOT = 1;
    private final int opCode;
    private final Expr expr;

    public ExprUnary(int opCode, Expr expr, Context context) {
        super(context);
        this.opCode = opCode;
        this.expr = expr;
    }

    @Override
    public int interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable) {
        if (this.opCode == 0) {
            return -this.expr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
        }
        return 1 - this.expr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
    }

    @Override
    public String toLongString() {
        return "ExprUnary{opCode=" + this.opCode + ", expr=" + this.expr.toLongString() + "}";
    }
}

